<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class DateBook_Payment_Gateway_bank
 *
 * @class DateBook_Payment_Gateway_bank
 * @package DateBook/Classes
 * @author Pagick Themes
 */


/**
 * Extends the payment gateway base class for Bank Payment
 *
 */
class DateBook_Payment_Gateway_bank extends DateBook_Payment_Gateway {

    /**
     * The features supported by the payment gateway
     *
     * @access public
     * @var array
     *
     */
    public $supports;


    /**
     * Constructor
     *
     */
    public function __construct( $data = array() ) {

		$this->supports = array('change_subscription_payment_method_admin');

	}


    /*
     * Save settings
     *
     */
	public function datebook_save_settings(){

		if(isset($_POST['datebook_gateway_slug']) && $_POST['datebook_gateway_slug'] == 'bank'){

			$gateway_settings = array();

			$gateway_settings['slug'] = 'bank';
			$gateway_settings['enabled'] = isset($_POST['enabled']) && $_POST['enabled'] == 1 ? 1 : 0;
			$gateway_settings['email'] = isset($_POST['email']) ? sanitize_text_field($_POST['email']) : '';
			$gateway_settings['logo_url'] = isset($_POST['logo_url']) ? sanitize_text_field($_POST['logo_url']) : '';
			$gateway_settings['logo_description'] = isset($_POST['logo_description']) ? sanitize_text_field($_POST['logo_description']) : '';
			$gateway_settings['bank_details'] = isset($_POST['bank_details']) ? stripslashes(sanitize_textarea_field($_POST['bank_details'])) : '';

			return $gateway_settings;
		
		}

	}


    /*
     * Settings page
     *
     */
	public function display_setting_page(){

		if (isset($_REQUEST['slug'])) {
				
			//Get entire array
			$item = get_option('datebook_gateways');
			$item = isset($item['bank']) ? $item['bank'] : '';

			// Get the location data if its already been entered
			$enabled = isset($item['enabled']) && $item['enabled'] == 1 ? 1 : 0;
			$email = isset($item['email']) ? $item['email'] : '';
			$logo_url = isset($item['logo_url']) ? $item['logo_url'] : '';
			$logo_description = isset($item['logo_description']) ? $item['logo_description'] : esc_html__('Pay via Bank; you can pay with bank transfer if you do not have a credit card.', 'datebook');
			$bank_details = isset($item['bank_details']) ? $item['bank_details'] : '';

	?>

	<h1><?php echo esc_html__( 'Bank Settings', 'datebook' ); ?></h1>

		<input type="hidden" name="datebook_gateway_slug" value="bank" />

		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Enable', 'datebook' ); ?></th>
				<td><label><input name="enabled" type="checkbox" value="1"<?php if ($enabled == 1){ echo ' checked'; } ?>><?php echo esc_html__( 'Yes', 'datebook' ); ?></label></td>
			</tr>
		</table>

		<table class="form-table paystack_setting_page">
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Bank details', 'datebook' ); ?></th>
				<td><textarea rows="6" name="bank_details" class="widefat"><?php echo esc_attr($bank_details); ?></textarea></td>
			</tr>
		</table>

		<hr>

		<table class="form-table paystack_setting_page">
			<tr valign="top">
				<th colspan="2" scope="row"><?php echo esc_html__( 'Logo and description', 'datebook' ); ?></th>
			</tr>
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Url to logo', 'datebook' ); ?></th>
				<td><input type="text" name="logo_url" value="<?php echo esc_url($logo_url); ?>" class="widefat" /></td>
			</tr>

			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Description about payment gateway', 'datebook' ); ?></th>
				<td><textarea rows="2" name="logo_description" class="widefat"><?php echo esc_attr($logo_description); ?></textarea></td>
			</tr>
		</table>

		<table class="form-table paystack_setting_page">
			<tr valign="top">
				<th scope="row"><?php echo esc_html__( 'Email', 'datebook' ); ?></th>
				<td><input type="text" name="email" value="<?php echo esc_attr($email); ?>" class="regular-text" /></td>
			</tr>
		</table>

		<?php
	
		}

	}


    /*
     * Redirect after payment to Subscription page
     *
	 * Third step of processing Subscription data
	 *
     */
    public function process_redirect_to_payment_gateway($payment_data) {

        // Do nothing if the payment id wasn't sent
        if( ! $payment_data['payment_id'] )
            return;

		$query_page_link = add_query_arg( array(
            'subscription_id'	=> $payment_data['subscription_plan_id'],
			'plan'				=> $payment_data['plan'],
			'payment_id'		=> $payment_data['payment_id'],
            'price'				=> $payment_data['amount'],
			'recurring'			=> $payment_data['recurring'],
			'payment_page'		=> $payment_data['payment_page'],
			'payment_gateway'	=> $payment_data['payment_gateway'],
			'datebooktkn'		=> $payment_data['datebooktkn']
		), get_permalink(of_get_option('my_upgrade_page')) );
		
		
		// Redirect only if tkn is set
		if( isset($payment_data['datebooktkn']) ) {
			wp_redirect($query_page_link);
			exit;
		}

    }


    /*
     * Process payment
	 * 
	 * Fourth step of processing Subscription data
	 *
	 * @access public
     */
    public static function datebook_process_payment_response() {

		if (isset($_GET['payment_page']) && $_GET['payment_page'] == '3' && isset($_GET['payment_id']) && isset($_GET['payment_gateway']) && $_GET['payment_gateway'] == 'bank' && ( isset( $_REQUEST['datebooktkn'] ) || wp_verify_nonce( $_REQUEST['datebooktkn'], 'datebook_new_subscription_form_nonce' ) )) {

			$post_data = $_GET;

			// Get payment id from custom variable sent by IPN
			$payment_id = isset( $post_data['payment_id'] ) ? $post_data['payment_id'] : 0;
			
			// Get the payment
			$payment = datebook_get_payment( $payment_id );
			
			// If the payment has already been completed do nothing
			if( $payment->status == 'completed' ) return;

			$profile_id = isset($payment->profile_id) ? $payment->profile_id : 0;

			// If the status is completed update the payment and also activate the member subscriptions
			if( $payment->id == $payment_id ) {

				$get_subscription_plans = get_option('datebook_subscription_plans');

				$subscription_plan_id = isset($payment->subscription_plan_id) ? $payment->subscription_plan_id : 0;
				$subscription_plan_user_id = isset($payment->user_id) ? $payment->user_id : 0;
				$subscription_plan_price_period = $payment->plan_price_period ? $payment->plan_price_period : 0;

				$subscription_plan_start_date = isset($payment->start_date) ? $payment->start_date : date('Y-m-d H:i:s');
				$subscription_plan_expiration_date = $payment->expiration_date ? $payment->expiration_date : '0000-00-00 00:00:00';

				$payment_data = array(
					'subscription_plan_id'   => $post_data['subscription_id'],
					'plan'              => $post_data['plan'],
					'payment_id'		=> $payment_id,
					'plan_price_period' => 0,
					'profile_id'		=> $profile_id,
					'user_id'		    => $subscription_plan_user_id,
					'start_date'		=> $subscription_plan_start_date,
					'expiration_date'	=> $subscription_plan_expiration_date,
					'transaction_id'	=> '',
					'status'			=> 'active',
					'date'			    => $subscription_plan_start_date,
					'price'			    => 0, 
					'recurring'		    => 0,
					'starts'			=> strtotime($subscription_plan_start_date),
					'ends'			    => $subscription_plan_expiration_date
				);
					
				$payment_data['payment_gateway'] = 'bank';

				// Let's activate Subscription for member after payment is made. Place this action at the end of payment process
				do_action('datebook_activate_subscription_after_payment', $payment_data);

			} else {

				// If payment status is not complete, something happened, so log it in the payment
				$log_data = array(
					'date'           => $post_data['subscr_date'],
					'payer_id'       => $post_data['payer_id'],
					'payer_email'    => $post_data['payer_email'],
					'payer_status'   => $post_data['payer_status']
				);

				$payment->add_log_entry( 'failure', esc_html__( 'The payment could not be completed successfully', 'datebook' ), $log_data );

			}
		}
	}


}