<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( !class_exists( 'DateBook_Class_Plugin_Panel' ) ) {

    /**
     * DateBook Plugin Panel
     *
     * Setting Page to Manage Plugins
     *
     */
    class DateBook_Class_Plugin_Panel {


        /**
         * @var array a setting list of parameters
         */
        public $settings = array();

        /**
         * @var array
         */
        protected $_tabs_path_files;

        /**
         * @var array
         */
        private $_main_array_options = array();

        /**
         * Constructor
         *
         * @param array $args
         */
        public function __construct( $args = array() ) {

            if ( !empty( $args ) ) {

                add_action( 'admin_menu', array( $this, 'add_setting_page' ), 20 );

            }

        }


        public function is_custom_tab( $options, $current_tab ) {
            foreach ( $options[ $current_tab ] as $section => $option ) {
                if ( isset( $option[ 'type' ] ) && isset( $option[ 'action' ] ) && 'custom_tab' == $option[ 'type' ] && !empty( $option[ 'action' ] ) ) {
                    return $option[ 'action' ];
                } else {
                    return false;
                }
            }

            return false;
        }

        /**
         * Fire the action to print the custom tab
         *
         */
        public function print_custom_tab( $action ) {
            do_action( $action );
        }


        /**
         * Get current tab
         *
         */
        function get_current_tab() {
            $admin_tabs = array_keys( $this->settings[ 'admin-tabs' ] );

            if ( !isset( $_GET[ 'page' ] ) || $_GET[ 'page' ] != $this->settings[ 'page' ] ) {
                return false;
            }
            if ( isset( $_REQUEST[ 'datebook_tab_options' ] ) ) {
                return $_REQUEST[ 'datebook_tab_options' ];
            } elseif ( isset( $_GET[ 'tab' ] ) && isset( $this->_tabs_path_files[ $_GET[ 'tab' ] ] ) ) {
                return $_GET[ 'tab' ];
            } elseif ( isset( $admin_tabs[ 0 ] ) ) {
                return $admin_tabs[ 0 ];
            } else {
                return 'general';
            }
        }


        /**
         * Get main array options
         *
         */
        function get_main_array_options() {
            if ( !empty( $this->_main_array_options ) ) {
                return $this->_main_array_options;
            }

            $options_path = $this->settings[ 'options-path' ];

            foreach ( $this->settings[ 'admin-tabs' ] as $item => $v ) {
                $path = $options_path . '/' . $item . '-options.php';
                $path = apply_filters( 'datebook_plugin_panel_item_options_path', $path, $options_path, $item, $this );
                if ( file_exists( $path ) ) {
                    $this->_main_array_options = array_merge( $this->_main_array_options, include $path );
                }
            }

            return $this->_main_array_options;
        }


        /**
         * add menu class in DateBook Plugins menu
         *
         */
        public static function add_menu_class_in_datebook_plugin( $menu ) {
            global $submenu;

            if ( !empty( $submenu[ 'datebook_plugin_panel' ] ) ) {
                $item_count = count( $submenu[ 'datebook_plugin_panel' ] );
                $columns    = absint( $item_count / 20 ) + 1;
                $columns    = max( 1, min( $columns, 3 ) );
                $columns    = apply_filters( 'datebook_plugin_fw_datebook_plugins_menu_columns', $columns, $item_count );

                if ( $columns > 1 ) {
                    $class = "datebook-plugin-fw-menu-$columns-columns";
                    foreach ( $menu as $order => $top ) {
                        if ( 'datebook_plugin_panel' === $top[ 2 ] ) {
                            $c                   = $menu[ $order ][ 4 ];
                            $menu[ $order ][ 4 ] = add_cssclass( $class, $c );
                            break;
                        }
                    }
                }
            }

            return $menu;
        }
    }
}




if ( !class_exists( 'DateBook_Class_Plugin_Panel_WooCommerce' ) ) {
    /**
     * DateBook Plugin Panel for WooCommerce
     *
     */
    class DateBook_Class_Plugin_Panel_WooCommerce extends DateBook_Class_Plugin_Panel {

        /**
         * @var array a setting list of parameters
         */
        public $settings = array();

        /**
         * @var array a setting list of parameters
         */
        public static $wc_type = array( 'checkbox', 'textarea', 'multiselect', 'multi_select_countries', 'image_width' );


        /**
         * @var bool
         */
        protected static $_actions_initialized = false;

        /**
         * Constructor
         *
         */
        public function __construct( $args = array() ) {
            $args = apply_filters( 'datebook_plugin_fw_wc_panel_option_args', $args );
            if ( !empty( $args ) ) {
                if ( isset( $args[ 'parent_page' ] ) && 'datebook_plugin_panel' === $args[ 'parent_page' ] )
                    $args[ 'parent_page' ] = 'datebook_plugin_panel';

                $this->settings         = $args;

                // init actions once to prevent multiple actions
                static::_init_actions();
            }
        }

        protected static function _init_actions() {
            if ( !static::$_actions_initialized ) {

                add_filter( 'add_menu_classes', array( __CLASS__, 'add_menu_class_in_datebook_plugin' ) );


                static::$_actions_initialized = true;
            }
        }


        /**
         * Show a tabbed panel to setting page
         *
         */
        public function datebook_panel() {
            $additional_info = array(
                'current_tab'    => $this->get_current_tab(),
                'available_tabs' => $this->settings[ 'admin-tabs' ],
                'default_tab'    => $this->get_available_tabs( true ), //get default tabs
                'page'           => $this->settings[ 'page' ]
            );

            $additional_info = apply_filters( 'datebook_admin_tab_params', $additional_info );
            $additional_info[ 'additional_info' ] = $additional_info;

            extract( $additional_info );

			add_thickbox();

			?>

			<div class="wrap">
				<div id="icon-users" class="icon32"><br/></div>

				<?php if( ! empty( $available_tabs ) ): ?>
                	<h2 class="nav-tab-wrapper woo-nav-tab-wrapper">
                    	<?php foreach( $available_tabs as $id => $label ): ?>
                        	<a href="?page=<?php echo esc_attr($page); ?>&tab=<?php echo esc_attr($id); ?>" class="nav-tab <?php echo ( $current_tab == $id ) ? 'nav-tab-active' : '' ?>"><?php echo esc_attr($label); ?></a>
						<?php endforeach; ?>
					</h2>

					<?php $this->print_panel_content() ?>

				<?php endif; ?>

			</div>

		<?php

        }


        /**
         * Returns current active tab slug
         *
         */
        public function get_current_tab() {
            global $pagenow;
            $tabs = $this->get_available_tabs();

            if ( $pagenow == 'admin.php' && isset( $_REQUEST[ 'tab' ] ) && in_array( $_REQUEST[ 'tab' ], $tabs ) ) {
                return $_REQUEST[ 'tab' ];
            } else {
                return $tabs[ 0 ];
            }
        }


        /**
         * Return available tabs
         *
         */
        public function get_available_tabs( $default = false ) {
            $tabs = array_keys( $this->settings[ 'admin-tabs' ] );

            return $default ? $tabs[ 0 ] : $tabs;
        }


        /**
         * Print the panel content
         *
         */
        public function print_panel_content() {
            $datebook_options       = $this->get_main_array_options();
            $current_tab       = $this->get_current_tab();
            $custom_tab_action = $this->is_custom_tab( $datebook_options, $current_tab );

            if ( $custom_tab_action ) {
                $this->print_custom_tab( $custom_tab_action );

                return;
            }
        }


    }
}