<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Post_Type_Classifieds
 *
 * @class DateBook_Post_Type_Classifieds
 * @package DateBook/Classes/Post_Types
 * @author Pagick Themes
 */
class DateBook_Post_Type_Classifieds {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'init', array( __CLASS__, 'datebook_definition' ) );

		add_action( 'classifiedcats_add_form_fields', array( __CLASS__, 'process_add_category' ), 10, 2);
		add_action( 'classifiedcats_edit_form_fields', array( __CLASS__, 'process_edit_category'), 10, 2);

		add_action( 'edited_classifiedcats', array( __CLASS__, 'process_save_category' ));
		add_action( 'create_classifiedcats', array( __CLASS__, 'process_save_category' ));

		//add_action('{DATEBOOK_CLASSIFIEDS_TYPE}_edit_form', 'edit_form'); 
		//add_action('{DATEBOOK_CLASSIFIEDS_TYPE}_add_form','edit_form');

	}


	/**
	 * Custom post type definition
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_definition() {

		if(of_get_option('what_pagebuilder_for_classified') == '2'){
			if(of_get_option('page_created_for_classified') > 0){
				$slug_rewritten = get_post_field('post_name', of_get_option('page_created_for_classified'));
			} else {
				$slug_rewritten = of_get_option('classifieds_permalink_slug');
			}
		} else if(of_get_option('classifieds_permalink_slug')){
			$slug_rewritten = DateBook_Utilities::datebook_makeslug(of_get_option('classifieds_permalink_slug'));
		} else {
			$slug_rewritten = DATEBOOK_CLASSIFIEDS_TYPE;
		}

		$post_types = array(
			array(esc_html__( 'Classifieds', 'datebook' ), $slug_rewritten, 'dashicons-megaphone', esc_html__( 'Add classified advert', 'datebook' ))
		);

		foreach ($post_types as $t) {
			$args = array(
				'label' => $t[0],
				'description ' => $t[3],
				'public' => true,
				'publicly_queryable' => true,
				'exclude_from_search' => true,
				'show_ui' => true,
				'show_in_rest' => true,
				'rest_controller_class' => 'WP_REST_Posts_Controller',
				'show_in_menu' => true,
				'menu_position' => 52,
				'hierarchical' => false,
				'menu_icon' => $t[2], // dashicons-location, dashicons-format-chat, dashicons-admin-comments, dashicons-email-alt, dashicons-pressthis, dashicons-megaphone
				'has_archive' => false,
				'query_var' => true,
				'rewrite' => array('slug' => $t[1]),
				'supports' => array('title','editor','author','excerpt','custom-fields','comments'),
				'capabilities' => array(
					'create_posts' => false
				),
				'map_meta_cap' => true
			);
			register_post_type( DATEBOOK_CLASSIFIEDS_TYPE, $args );
			
		}
		
		$tax_slug_rewritten = of_get_option('classifieds_tax_permalink_slug') ? DateBook_Utilities::datebook_makeslug(of_get_option('classifieds_tax_permalink_slug')) : 'classcategory';

		register_taxonomy(DATEBOOK_CLASSIFIEDS_TAX, DATEBOOK_CLASSIFIEDS_TYPE, array(
				'hierarchical' => true,
				'label' => esc_html__( 'Subjects', 'datebook' ),
				'sort' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'query_var' => true,
				'args' => array( 'orderby' => 'term_order' ),
				'rewrite' => array( 'slug' => $tax_slug_rewritten )
			)
		);


	}


	/**
	 * Get languages
	 *
	 * @access public
	 * @return void
	 */
	private static function get_languages(){

		global $wp_locale_all;

		// get languages
		$languages_array = array();

		$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

		$languages = DateBook_Localization::datebook_all_available_language_files();

		foreach($languages as $language) {
			if($language['checked'] == 1){
				$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
			}
		}
		
		return $languages_array;
	}


	/**
	 * Add custom taxonomy - Multilingual category
	 *
	 * @access public
	 * @return void
	 */
	public static function process_add_category( $term ) {
		
		$languages_array = self::get_languages();
		
		foreach ( $languages_array as $language_key => $language_name ) {

		?>

			<div class="form-field">
				<label for="taxClassCategory_<?php echo esc_attr($language_key); ?>"><?php echo sprintf( esc_html__( 'Subject (%1$s)', 'datebook' ), $language_name ); ?></label><input type="text" name="taxClassCategory_<?php echo esc_attr($language_key); ?>" id="taxClassCategory_<?php echo esc_attr($language_key); ?>" value="" />
			</div>

		<?php
		
		}

	}


	/**
	 * Edit custom taxonomy - Multilingual category
	 *
	 * @access public
	 * @return void
	 */
	public static function process_edit_category( $term ) {
		
		$languages_array = self::get_languages();

		// put the term ID into a variable
		$t_id = $term->term_id;

		foreach ( $languages_array as $language_key => $language_name ) {

			$term_category = get_term_meta( $t_id, 'datebook_classcat_' . esc_attr($language_key), true );

			?>

			<tr class="form-field">
				<th><label for="taxClassCategory_<?php echo esc_attr($language_key); ?>"><?php echo sprintf( esc_html__( 'Subject (%1$s)', 'datebook' ), $language_name ); ?></label></th>
				<td><input type="text" name="taxClassCategory_<?php echo esc_attr($language_key); ?>" id="taxClassCategory_<?php echo esc_attr($language_key); ?>" value="<?php echo esc_attr( $term_category ) ? esc_attr( $term_category ) : ''; ?>"></td>
			</tr>

			<?php

		}
	}


	/**
	 * Saving custom taxonomy - Multilingual category
	 *
	 * @access public
	 * @return void
	 */
	public static function process_save_category( $term_id ) {
		
		$languages_array = self::get_languages();

		foreach ( $languages_array as $language_key => $language_name ) {

			if ( isset( $_POST['taxClassCategory_' . $language_key] ) ) {
				$term_category = $_POST['taxClassCategory_' . $language_key];
				if( $term_category ) {
					 update_term_meta( $term_id, 'datebook_classcat_' . esc_attr($language_key), esc_attr($term_category) );
				}
			}
		}
	}  


}

DateBook_Post_Type_Classifieds::init();