<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Post_Type_Tour
 *
 * @class DateBook_Post_Type_Tour
 * @package DateBook/Classes/Post_Types
 * @author Pagick Themes
 */
class DateBook_Post_Type_Tour {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'init', array( __CLASS__, 'datebook_definition' ) );

	}
	

	/**
	 * Custom post type definition
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_definition() {

		if(of_get_option('what_pagebuilder_for_tour') == '2'){
			if(of_get_option('page_created_for_tour') > 0){
				$slug_rewritten = get_post_field('post_name', of_get_option('page_created_for_tour'));
			} else {
				$slug_rewritten = of_get_option('tour_permalink_slug');
			}
		} else if(of_get_option('tour_permalink_slug')){
			$slug_rewritten = DateBook_Utilities::datebook_makeslug(of_get_option('tour_permalink_slug'));
		} else {
			$slug_rewritten = DATEBOOK_TOUR_TYPE;
		}
		
		$post_types = array(
			array(esc_html__( 'Tours', 'datebook' ), $slug_rewritten, 'dashicons-location', esc_html__( 'Add tour', 'datebook' ))
		);
		
		foreach ($post_types as $t) {
			$args = array(
				'label' => $t[0],
				'description ' => $t[3],
				'public' => true,
				'publicly_queryable' => true,
				'exclude_from_search' => true,
				'show_ui' => true,
				'show_in_rest' => true,
				'rest_controller_class' => 'WP_REST_Posts_Controller',
				'show_in_menu' => true,
				'menu_position' => 53,
				'hierarchical' => false,
				'menu_icon' => $t[2], // dashicons-location, dashicons-format-chat, dashicons-admin-comments, dashicons-email-alt, dashicons-pressthis, dashicons-megaphone
				'has_archive' => false,
				'query_var' => true,
				'rewrite' => array('slug' => $t[1]),
				'supports' => array('title','editor','author','excerpt','custom-fields','comments'),
				'capabilities' => array(
					'create_posts' => false
				),
				'map_meta_cap' => true
			);
			register_post_type( DATEBOOK_TOUR_TYPE, $args );
		}
	
	}

}

DateBook_Post_Type_Tour::init();