<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Latest Posts

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_posts_widgets' );

// Posts widget.
function datebook_posts_widgets() {
	register_widget( 'DateBook_Posts_widget' );
}

// Widget class.
class DateBook_Posts_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-posts-widget', 'description' => esc_html__( 'Displays posts that users left on profiles.', 'datebook' ) );

		parent::__construct( 'datebook_posts_widget', esc_html__( 'DateBook: Latest Posts', 'datebook' ), $widget_ops );
		
		add_action( 'save_post', array($this, 'flush_widget_cache') );
        add_action( 'deleted_post', array($this, 'flush_widget_cache') );
        add_action( 'switch_theme', array($this, 'flush_widget_cache') );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['posts_count'] = (int) $new_instance['posts_count'];
        $instance['show_date'] = (bool) $new_instance['show_date'];
        $this->flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['widget_recent_entries']) )
            delete_option('widget_recent_entries');

        return $instance;
    }
	
/*-----------------------------------------------------------------------------------*/
/*	Flush Widget
/*-----------------------------------------------------------------------------------*/
	
	function flush_widget_cache() {
        wp_cache_delete('widget_recent_posts', 'widget');
    }
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {
        $title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $posts_count = (isset($instance['posts_count']) && (int)$instance['posts_count'] > 0) ? (int)$instance['posts_count'] : 10;
        $show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
?>
        <p>
		<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'datebook' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>

        <p>
        <input id="<?php echo esc_attr($this->get_field_id( 'posts_count' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_count' )); ?>" type="text" value="<?php echo esc_attr($posts_count); ?>" size="3" />
		<label for="<?php echo esc_attr($this->get_field_id( 'posts_count' )); ?>"><?php esc_html_e( 'Number of posts', 'datebook' ); ?></label>		
		</p>

        <p>
		<input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_date' )); ?>" /> <label for="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>"><?php esc_html_e( 'Display post date?', 'datebook' ); ?></label></p>
<?php
    }


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
        $cache = wp_cache_get('widget_recent_posts', 'widget');

        if ( !is_array($cache) )
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $cache[ $args['widget_id'] ] ) ) {
            echo esc_attr($cache[ $args['widget_id'] ]);
            return;
        }

        ob_start();
        extract($args);

        $posts_per_page = ((int)$instance['posts_count'] > 0) ? (int)$instance['posts_count'] : 10;
        $show_date = isset( $instance['show_date'] ) ? (bool)$instance['show_date'] : false;

        $r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => $posts_per_page, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
        if ($r->have_posts()) : ?>

        <?php echo $before_widget; ?>
		
		<h4 class="datebook-title-aside"><?php esc_html_e( 'Latest posts', 'datebook' ); ?></h4>

		<hr />

		<ul class="media-list">
			<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li class="media">
				<a href="<?php the_permalink() ?>" title="<?php echo esc_attr( get_the_title() ? get_the_title() : get_the_ID() ); ?>"><?php if ( get_the_title() ) the_title(); else the_ID(); ?></a>
				<?php if ( $show_date ) : ?>
				<div class="clear"></div>
				<span class="datebook-post-date"><?php echo DateBook_Utilities::datebook_date_i18n( 2, get_the_time()); ?></span>
				<?php endif; ?>
			</li>
			<?php endwhile; ?>
		</ul>

        <?php echo $after_widget; ?>
<?php
        // Reset the global $the_post as this query will have stomped on it
        wp_reset_postdata();

        endif;

        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('widget_recent_posts', $cache, 'widget');
    }

}
?>