<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Latest profiles (Images only)

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_latest_profiles_images_widgets' );

// Register widget.
function datebook_latest_profiles_images_widgets() {
	register_widget( 'DateBook_Latest_Profiles_images_widget' );
}

// Widget class.
class DateBook_Latest_Profiles_images_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-latest-profiles-images-widget', 'description' => esc_html__( 'Displays latest profiles (Images only).', 'datebook' ) );

		parent::__construct( 'datebook_latest_profiles_images_widget', esc_html__( 'DateBook: Latest Profiles (Images only)', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['posts_per_page'] = strip_tags($new_instance['posts_per_page']);
		$instance['sort_by'] = strip_tags($new_instance['sort_by']);
		$instance['enabled_tooltip'] = !empty($new_instance['enabled_tooltip']) ? 1 : 0;
		$instance['enabled_country'] = !empty($new_instance['enabled_country']) ? 1 : 0;
		$instance['round_image'] = !empty($new_instance['round_image']) ? 1 : 0;

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Latest Profiles (Images only)',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$posts_per_page = (isset($instance['posts_per_page'])) ? strip_tags($instance['posts_per_page']) : '3_2';
		$sort_by = !empty($instance['sort_by']) ? strip_tags($instance['sort_by']) : 'descending';
		$enabled_tooltip = isset($instance['enabled_tooltip']) ? (bool) $instance['enabled_tooltip'] : true;
		$enabled_country = isset($instance['enabled_country']) ? (bool) $instance['enabled_country'] : true;
		$round_image = isset($instance['round_image']) ? (bool) $instance['round_image'] : true;

		?>

		<!-- Widget Title: Text Input -->

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'datebook' ) ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>"><?php esc_html_e('Number of Latest Profiles', 'datebook' ); ?></label>

			<?php

			$amount_of_profiles = array(
				0 => '2_1', // 2 profiles
				1 => '3_1', // 3 profiles
				2 => '2_2', // 4 profiles
				3 => '4_1', // 4 profiles
				4 => '2_3', // 6 profiles
				5 => '3_2', // 6 profiles
				6 => '2_4', // 8 profiles
				7 => '4_2', // 8 profiles
				8 => '3_3', // 9 profiles
				9 => '2_5', // 10 profiles
				10 => '2_6', // 12 profiles
				11 => '3_4', // 12 profiles
				12 => '4_3', // 12 profiles
				13 => '4_4'  // 16 profiles
				);
				
				?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>" name="<?php echo esc_attr($this->get_field_name('posts_per_page')); ?>">

				<?php foreach ($amount_of_profiles as $key => $column_row ): 
				$colrow = explode('_', $column_row);
				$amount = $colrow[0] * $colrow[1];
				?>
				<option value="<?php echo esc_attr($column_row);?>" <?php if ($posts_per_page == $column_row) { echo 'selected="selected"'; } ?>><?php echo esc_attr($amount);?> <?php esc_html_e('profiles', 'datebook' ); ?> - <?php echo esc_attr($colrow[0]);?> <?php esc_html_e('columns', 'datebook' ); ?> / <?php echo esc_attr($colrow[1]);?> <?php esc_html_e('rows', 'datebook' ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('sort_by')); ?>"><?php esc_html_e('Sort by date', 'datebook' );?></label>
			<?php $answers = array('desc' => 'New first','asc' => 'Old first','rand' => 'Random'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('sort_by')); ?>" name="<?php echo esc_attr($this->get_field_name('sort_by')); ?>">
				<?php foreach ($answers as $key => $answer ): ?>
				<option <?php if ($sort_by == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_attr($answer);?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_tooltip')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_tooltip')); ?>" <?php checked($enabled_tooltip); ?> /> <?php esc_html_e("Show Tooltip", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_country')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_country')); ?>" <?php checked($enabled_country); ?> /> <?php esc_html_e("Show City and Country", 'datebook' );?>
		</p>

		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('round_image')); ?>" name="<?php echo esc_attr($this->get_field_name('round_image')); ?>" <?php checked($round_image); ?> /> <?php esc_html_e("Round images", 'datebook' );?>
		</p>

		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$posts_per_page = (isset($instance['posts_per_page'])) ? strip_tags($instance['posts_per_page']) : '3_2';
		$enabled_tooltip = isset($instance['enabled_tooltip']) ? (bool)$instance['enabled_tooltip'] : 1;
		$enabled_country = isset($instance['enabled_country']) ? (bool)$instance['enabled_country'] : 1;
		$round_image = isset($instance['round_image']) && $instance['round_image'] > 0 ? '' : 'latest-profile-img';
		
		$sort_by = "RAND";
		if(!empty($instance['sort_by']) && is_array($instance['sort_by'])):
			$sort_by =  array_filter($instance['sort_by']);
		elseif(!empty($instance['sort_by'])):
			$sort_by = $instance['sort_by'];
		endif;
		

		/* Display Widget */
		?>

		<!-- sidebar -->

		<?php

			/* Before widget (defined by themes). */
			echo $before_widget;

			// display the Loop
			global $allowedposttags;

			// count profiles and devide on columns and rows
			$colrow = explode('_', $posts_per_page);
			$posts_per_page = $colrow[0] * $colrow[1];
			$column_number = 12 / $colrow[0]; // 12 - number of bootstrap columns
			

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => $sort_by,
				'posts_per_page' => $posts_per_page
			);

			$the_query = new WP_Query( $args );

			if ( $the_query->have_posts()) :

				// Check if Retina enabled in Theme Options
				$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

				?>

				<div class="card-header">

					<h4 class="mb-0 datebook-title-aside"><?php esc_html_e( 'Latest profiles', 'datebook' ); ?></h4>

				</div>
				<div class="card-body">
				<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">
				<div class="row"> 

				<?php

				while ( $the_query->have_posts() ) : $the_query->the_post();

					$profile_id = absint(get_the_ID());
			
					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					if(isset($datebook_get_data['city'])){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
						$city = isset($term_data->city) ? $term_data->city : '';
						$country = isset($term_data->country) ? $term_data->country : '';

					}

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

					if ($gender == 1) {
						$gender_icon = 'fa fa-venus fa-lg';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars fa-lg';
					} else {
						$gender_icon = 'fa fa-user fa-lg';
					}

					$location_tooltip = (isset($enabled_country) && $enabled_country == 1) ? '<br />' . $city . ', ' . $country : '';

					$get_the_title = get_the_title();

					$title_for_alt = $get_the_title . ', ' . $age;

					if (isset($city)) {
						$title_for_alt .= esc_attr($city);
					}
					if (!empty($city) && !empty($country)) {
						$title_for_alt .= ", ";
					}
					if (isset($country)) {
						$title_for_alt .= esc_attr($country);
					}

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_latest_profiles_images_sidebar', $gender, true);

				?>

				<div class="col-lg-<?php echo esc_attr($column_number); ?> col-md-<?php echo esc_attr($column_number); ?> col-sm-<?php echo esc_attr($column_number); ?> datebook-padding-less text-center">
						<a href="<?php the_permalink(); ?>" class="thumbnail <?php echo esc_attr($round_image); ?>" <?php if ($enabled_tooltip == 1) { ?> data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="<?php echo esc_attr($age) . "<i class='" . esc_attr($gender_icon) . "'></i>" . wp_kses( $location_tooltip, $allowedposttags ); ?>"<?php } ?> title="<?php echo esc_attr($get_the_title); ?>"><img src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" class="img-circle" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a> 
				</div>

				<?php endwhile; ?>
				
				</div>
				</div>
			</div>

		<?php

		endif;

		wp_reset_postdata();

		/* After widget (defined by themes). */
		echo $after_widget;


		?>

		<!-- /sidebar -->

		<?php
	}

}