<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Related profiles by country

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_related_profiles_bycountry_widgets' );

// Register widget.
function datebook_related_profiles_bycountry_widgets() {
	register_widget( 'DateBook_Related_Profiles_bycountry_widget' );
}

// Widget class.
class DateBook_Related_Profiles_bycountry_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-related-profiles-bycountry-widget', 'description' => esc_html__( 'Displays related profiles by country.', 'datebook' ) );

		parent::__construct( 'datebook_related_profiles_bycountry_widget', esc_html__( 'DateBook: Related Profiles by Country', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['columns'] = strip_tags($new_instance['columns']);
		$instance['rows'] = strip_tags($new_instance['rows']);
		$instance['roundness'] = !empty($new_instance['roundness']) ? $new_instance['roundness'] : 'rounded';
		$instance['sort_by'] = strip_tags($new_instance['sort_by']);
		$instance['enabled_tooltip'] = !empty($new_instance['enabled_tooltip']) ? 1 : 0;
		$instance['enabled_country'] = !empty($new_instance['enabled_country']) ? 1 : 0;
		$instance['enabled_city'] = !empty($new_instance['enabled_city']) ? 1 : 0;

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Related Profiles',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = isset( $instance['title'] ) ? $instance['title'] : '';
		$columns =  (isset($instance['columns'])) ? strip_tags($instance['columns']) : '3';
		$rows =  (isset($instance['rows'])) ? strip_tags($instance['rows']) : '3';
		$roundness =  (isset($instance['roundness'])) ? strip_tags($instance['roundness']) : 'rounded';
		$sort_by = !empty($instance['sort_by']) ? strip_tags($instance['sort_by']) : 'descending';
		$enabled_tooltip = isset($instance['enabled_tooltip']) ? (bool) $instance['enabled_tooltip'] : true;
		$enabled_country = isset($instance['enabled_country']) ? (bool) $instance['enabled_country'] : true;
		$enabled_city = isset($instance['enabled_city']) ? (bool) $instance['enabled_city'] : true;
		?>

		<!-- Widget Title: Text Input -->

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'datebook' ) ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('columns')); ?>"><?php esc_html_e('Number of columns', 'datebook' ); ?></label>
			<?php $number_of_columns = array(1 => '1', 2 => '2', 3 => '3', 4 => '4'); ?>

			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('columns')); ?>" name="<?php echo esc_attr($this->get_field_name('columns')); ?>">
				<?php
				
				foreach ($number_of_columns as $key => $column ) : 

				?>

				<option value="<?php echo esc_attr($column);?>" <?php if ($columns == $column) { echo 'selected="selected"'; } ?>><?php echo esc_attr($column);?></option>

				<?php endforeach; ?>

			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'rows' )); ?>"><?php esc_html_e('Number of rows:', 'datebook' ) ?></label>
			<input type="number" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'rows' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'rows' )); ?>" value="<?php echo esc_attr($rows); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('roundness')); ?>"><?php esc_html_e('Roundness', 'datebook' ); ?></label>
			<?php $roundness_array = array('noround' => esc_html__('No round', 'datebook' ), 'rounded' => esc_html__('Rounded', 'datebook' ), 'rounded-circle' => esc_html__('Rounded circle', 'datebook' )); ?>

			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('roundness')); ?>" name="<?php echo esc_attr($this->get_field_name('roundness')); ?>">
				<?php
				
				foreach ($roundness_array as $key => $round) : 

				?>

				<option value="<?php echo esc_attr($key);?>" <?php if ($roundness == $key) { echo 'selected="selected"'; } ?>><?php echo esc_attr($round);?></option>

				<?php endforeach; ?>

			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('sort_by')); ?>"><?php esc_html_e('Sort by date', 'datebook' );?></label>
			<?php $answers = array('desc' => 'New first','asc' => 'Old first','rand' => 'Random'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('sort_by')); ?>" name="<?php echo esc_attr($this->get_field_name('sort_by')); ?>">
				<?php foreach ($answers as $key => $answer ): ?>
				<option <?php if ($sort_by == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_attr($answer);?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_tooltip')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_tooltip')); ?>" <?php checked($enabled_tooltip); ?> /> <?php esc_html_e("Show Tooltip", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_country')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_country')); ?>" <?php checked($enabled_country); ?> /> <?php esc_html_e("Show Country", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_city')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_city')); ?>" <?php checked($enabled_city); ?> /> <?php esc_html_e("Show City", 'datebook' );?>
		</p>

		<?php

	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$columns = (isset($instance['columns']) && $instance['columns'] > 0) ? strip_tags($instance['columns']) : 3;
		$rows = (isset($instance['rows']) && $instance['rows'] > 0) ? strip_tags($instance['rows']) : 3;
		$roundness =  (isset($instance['roundness'])) ? strip_tags($instance['roundness']) : 'rounded';
		$enabled_tooltip = isset($instance['enabled_tooltip']) ? (bool)$instance['enabled_tooltip'] : 1;
		$enabled_country = isset($instance['enabled_country']) ? (bool)$instance['enabled_country'] : 1;
		$enabled_city = isset($instance['enabled_city']) ? (bool)$instance['enabled_city'] : 1;
		
		$sort_by = '';
		if(!empty($instance['sort_by']) && is_array($instance['sort_by'])):
			$sort_by =  array_filter($instance['sort_by']);
		elseif(!empty($instance['sort_by'])):
			$sort_by = explode(',',$instance['sort_by']);
		endif;
		

		/* Display Widget */
		?>
		<!-- sidebar -->
		<?php
		if (get_post_type() == DATEBOOK_POST_TYPE) {

			/* Before widget (defined by themes). */
			//echo $before_widget;

			$related_profiles_from_countries = 1;
			
			$datebook_widget_options = array( 
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'related_profiles_from_countries' => $related_profiles_from_countries, 
				'columns' => $columns,
				'rows' => $rows,
				'roundness' => $roundness,
				'enabled_tooltip' => $enabled_tooltip, 
				'enabled_country' => $enabled_country,
				'enabled_city' => $enabled_city,
				'sort_by' => $sort_by 
			);
			set_query_var( 'datebook_widget_options', $datebook_widget_options );
			
			echo DateBook_Template_Loader::load( 'widgets/related-profiles-sidebar' );

			/* After widget (defined by themes). */
			//echo $after_widget;

		}
		?>
		<!-- /sidebar -->
		<?php
	}

}
?>