<?php
/*
 * Moderation panel for checking all posts, images, tours, classifieds, comments. Shown in the body.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_image_sizes;

$columns_image_format = 'image_avatar';
$search_default_thumbnail = 0;

// And here shall come the future posts - doesn't work
$args = array(
	'numberposts'		=> '20',
	'post_type'			=> 'profile',
	'post_status'		=> 'publish', //'draft, publish, future, pending, private',
	'meta_key'			=> 'new',
	'meta_value'		=> '1'
);

$recent_posts = wp_get_recent_posts(  $args );

?>

<div class="datebook-moderation-panel mb-3">

	<h4><?php esc_html_e( 'New profiles', 'datebook' ); ?>:</h4>

	<ul class="list-group">

	<?php

	foreach( $recent_posts as $recent ){

		$profile_id = absint($recent["ID"]);

		$get_profile_data = get_post_meta($profile_id, "profile_personal_data", true);
		$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

		$country = $region = $city = '';
		if(isset($datebook_get_data['city'])){

			$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
			$city = isset($term_data->city) ? $term_data->city : '';
			$country = isset($term_data->country) ? $term_data->country : '';

		}

		$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) : '';

		$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
		$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';
		$wishtravel = isset($datebook_get_data['wishtravel']) ? $datebook_get_data['wishtravel'] : 0;

		$verified = isset($datebook_get_data['verified']) ? $datebook_get_data['verified'] : 0;

		$topad = get_post_meta($profile_id, "topad", true);
		$featured = get_post_meta($profile_id, "featured", true);

		$title_for_alt = $recent["post_title"] . ', ' . $age;

		if (isset($city)) {
			$title_for_alt .= esc_attr($city);
		}
		if (!empty($city) && !empty($country)) {
			$title_for_alt .= ", ";
		}
		if (isset($country)) {
			$title_for_alt .= esc_attr($country);
		}

		if ($gender == 1) {
			$gender_icon = esc_html__( 'Woman', 'datebook' );
		} else if ($gender == 2) {
			$gender_icon = esc_html__( 'Man', 'datebook' );
		} else {
			$gender_icon = esc_html__( 'Gender unknown', 'datebook' );
		}

		$post = get_post($profile_id);
		$date = $post->post_date;

		$all_photos_args = array(
			'post_parent' => $profile_id, 
			'post_status' => 'inherit', 
			'post_type' => 'attachment', 
			'post_mime_type' => 'image',
			'posts_per_page' => -1,			
			'meta_query' => array(
				array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
			)
		);

		$all_photos_query = new WP_Query( $all_photos_args );

		$all_photos_count = $all_photos_query->found_posts - 1;
		$all_photos_count = ($all_photos_count > 0) ? $all_photos_count : 0;

		$featured_class = $featured == '1' ? ' datebook-featured-style mini' : '';

		$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);

		?>

		<li id="<?php echo esc_attr($profile_id); ?>" class="list-group-item">

			<div class="row">
				<div class="col-lg-9 col-md-9 col-sm-12">

					<a class="float-left mr-2" href="<?php echo esc_url(get_permalink($recent["ID"])); ?>" title="<?php echo esc_attr($recent["post_title"]); ?>" target="_blank"><img width="<?php echo esc_attr($datebook_image_sizes[$columns_image_format]['width']); ?>" height="<?php echo esc_attr($datebook_image_sizes[$columns_image_format]['height']); ?>" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" data-rjs="2" /></a> 
				
					<p class="mb-1 small">
					
					<span class="h6"> <a href="<?php echo esc_url(get_permalink($recent["ID"])); ?>" title="<?php echo esc_attr($recent["post_title"]); ?>" target="_blank"><?php echo esc_html($recent["post_title"]); ?></a> 
				
						<?php

						if ($verified == '1') {

							echo ' <i class="fas fa-check-square text-green" title="'.esc_html__( 'Verification', 'datebook' ).'"></i>';

						}

						$top_profile_label = '';

						if ($topad == '1') {

							echo '<span class="badge amber darken-2 datebook-top-label">'.esc_html__( 'Top', 'datebook' ).'</span>';

						}

						?>
						
					</span>

					<?php
					
					$added_date = isset($recent['post_date']) ? DateBook_Utilities::datebook_date_i18n(2, $recent['post_date']) : esc_html__( 'unknown', 'datebook' );
						
					?>

					<span class="ml-2"><?php echo esc_html__( 'Submitted on', 'datebook' ) . ': ' . esc_attr($added_date); ?></span>
					
					</p>
					
					<p class="mb-1 small">

					<?php echo esc_attr($age); ?> 

					<span class="badge badge-pill badge-info"><?php if(isset($datebook_sexualorientation_titles[$sexualorientation])){ echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' ); } ?></span> 

					<span class="badge badge-info"><?php echo esc_attr($gender_icon); ?></span>
					
					</p>
					
					<p class="mb-0 small">

					<?php 

					if (isset($city)) {
						echo esc_attr($city);
					}
					if (!empty($city) && !empty($country)) {
						echo ", ";
					}
					if (isset($country)) {
						echo esc_attr($country);
					}

					?>

					<?php if ($wishtravel) { ?>

						<span class="badge badge-secondary"><?php echo esc_html__( 'Ready to travel', 'datebook' ); ?></span>

					<?php } ?>
					
					</p>
					
				</div>

				<div class="col-lg-3 col-md-3 col-sm-12 text-center">

					<button id="datebook-moderate-approve-profile" class="btn btn-sm btn-success" value="<?php echo absint($profile_id); ?>" type="submit"><?php echo esc_html__( 'Approve', 'datebook' ); ?></button>
					<button id="datebook-moderate-delete-profile" class="btn btn-sm btn-light" value="<?php echo absint($profile_id); ?>" type="submit"><?php echo esc_html__( 'Delete', 'datebook' ); ?></button>

				</div>
			</div>

			<?php if ($recent["post_content"]) { ?>

				<p class="mt-1 small"><em><?php echo esc_attr($recent["post_content"]); ?></em></p>

			<?php } ?>

		</li>

	<?php } ?>

	</ul>
</div>