<?php
/**
 * Classified ads displayed on Classifieds page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

global $current_user, $datebook_gender_titles;

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

$get_term_slug = $tax_array = '';

if ( is_tax(DATEBOOK_CLASSIFIEDS_TAX) ) {

	$get_term_slug = get_query_var(DATEBOOK_CLASSIFIEDS_TAX);

	$tax_array = array(
        array (
            'taxonomy' => DATEBOOK_CLASSIFIEDS_TAX,
            'field' => 'slug',
            'terms' => $get_term_slug,
        )
    );
	
	$term_active = '';

} else {
	
	$term_active = ' active';
	
}


$posts_per_page = of_get_option('classifieds_per_page') > 0 ? of_get_option('classifieds_per_page') : '40'; // show 40 classifieds if not set in Admin Dashboard

$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

$args = array(
	'post_type' => DATEBOOK_CLASSIFIEDS_TYPE,
	'post_status' => 'publish',
	'orderby' => 'date',
	'order' => 'DESC',
	'posts_per_page' => $posts_per_page,
	'paged' => $paged,
	'tax_query' => $tax_array
);

$the_query = new WP_Query( $args );


$add_item_link = add_query_arg( array(
	'action' => 'newclassified'
), get_permalink(of_get_option('my_classifieds_page')) );

?>

<div class="datebook-classifieds-page">
	<div class="row">
		<div class="col">

			<h1><?php esc_html_e( 'Classifieds', 'datebook' ); ?></h1>

		</div>

		<div class="col">

			<a href="<?php echo esc_url($add_item_link);?>" class="btn btn-sm btn-secondary float-right"><?php esc_html_e( 'Add a classified', 'datebook' ); ?></a>

		</div>
	</div>

	<?php

	$args = array(
		'name'					=> 'subject',
		'hide_empty'			=> 0,
		'use_desc_for_title'	=> 0,
		'hierarchical'			=> true,
		'number'				=> NULL,
		'echo'					=> 0,
		'depth'					=> 1,
		'current_category'		=> 0,
		'hide_if_empty'			=> true,
		'pad_counts'			=> 0,
		'taxonomy'				=> DATEBOOK_CLASSIFIEDS_TAX
	);

	if(!empty(wp_dropdown_categories($args))){
		$datebook_categories_exists = 1;
	} else {
		$datebook_categories_exists = 0;
	}
	
	if($datebook_categories_exists == 1){
	
		?>

		<ul class="nav nav-pills mt-3 mb-3">

			<li class="nav-item"><a class="nav-link<?php echo esc_attr($term_active); ?>" href="<?php echo esc_url(get_permalink(of_get_option('all_classifieds_page'))); ?>" title="<?php esc_html_e( 'All', 'datebook' ); ?>"><?php esc_html_e( 'All', 'datebook' ); ?></a></li>

			<?php

			$args = array(
				'orderby'            => 'name',
				'order'              => 'ASC',
				'show_last_update'   => 0,
				'style'              => 'list',
				'show_count'         => 1,
				'hide_empty'         => 0,
				'use_desc_for_title' => 1,
				//'child_of'           => $catMain->term_id,
				'exclude'            => '',
				'exclude_tree'       => '',
				'include'            => '',
				'hierarchical'       => true,
				'title_li'           => '',
				'show_option_none'   => '',
				'number'             => NULL,
				'echo'               => 1,
				'depth'              => 1,
				'current_category'   => 0,
				'pad_counts'         => 0,
				'walker'			 => new Walker_Classified_Categories($get_term_slug),
				'taxonomy'           => DATEBOOK_CLASSIFIEDS_TAX
				);

			wp_list_categories( $args );
	
			?>

		</ul>

	<?php } ?>

	<hr />


	<?php

	if ( $the_query->have_posts() ) {
		
		// Check if Retina enabled in Theme Options
		$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;
		
		while ( $the_query->have_posts() ) : $the_query->the_post();

			$classifieds_id = get_the_ID();

			$profile_id = get_post_meta($classifieds_id, 'profile_classifieds_id', true);
			
			if (!empty($profile_id) && $profile_id > 1) {
				
				$profile_data = get_post($profile_id);
				
				if (!empty($profile_data) && $profile_data->post_status == 'publish') {

					$term_list = wp_get_post_terms($classifieds_id, DATEBOOK_CLASSIFIEDS_TAX, array('fields' => 'all'));

					$term_vals = isset($term_list[0]->term_id) ? get_term_meta($term_list[0]->term_id) : '';

					if($datebook_categories_exists == 1){
						$subject_name = isset($term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0]) ? $term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0] : (isset($term_list[0]->name) ? $term_list[0]->name : esc_html__( 'Common', 'datebook' ));
						$subject_name_out = ' &#8212; ' . $subject_name;
					} else {
						$subject_name_out = '';
					}

				?>

				<div class="row">
					<div class="col-lg-8 col-md-8 col-sm-8 mb-2">
						<div class="datebook-classifieds-body">

							<h4 class="datebook-classifieds-heading"><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>

							<small class="text-grey" title="<?php esc_html_e( 'Date added', 'datebook' ); ?>"><i class="fa fa-clock-o"></i> <?php echo DateBook_Utilities::datebook_date_i18n(2, get_the_time('Y-m-d H:i:s', $classifieds_id)); ?><?php echo esc_attr($subject_name_out); ?></small>
						</div>
					</div>

					<div class="col-lg-4 col-md-4 col-sm-4 mb-4">

					<?php

					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					$country = $region = $city = '';

					if(isset($datebook_get_data['city'])){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
						$city = isset($term_data->city) ? $term_data->city : '';
						$country = isset($term_data->country) ? $term_data->country : '';

					}

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
					$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';

					if ($gender == 1) {
						$gender_icon = 'fa fa-venus fa-lg';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars fa-lg';
					} else {
						$gender_icon = 'fa fa-user fa-lg';
					}

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($classifieds_id, 'image_classifieds_other_page', $gender, true, $datebook_get_data);
		
					if ($thumbnail_url['image_exists'] == 'no') {
						$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_classifieds_other_page', $gender, true, $datebook_get_data);
					}

					?>

						<a class="float-left mr-2 mb-4" href="<?php echo esc_url(get_permalink($profile_id)); ?>" title="<?php echo esc_attr($profile_data->post_title); ?>"> <img class="rounded-circle shadow" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" width="<?php echo esc_attr( $thumbnail_url['width'] ); ?>" height="<?php echo esc_attr( $thumbnail_url['height'] ); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /> </a>

						<h6 class="mt-0 mb-1 datebook-profile-heading datebook-ellipsis small"><a class="" href="<?php echo esc_url(get_permalink($profile_id)); ?>" title="<?php echo esc_attr($profile_data->post_title); ?>"><?php echo esc_html($profile_data->post_title); ?></a></h6>

						<p class="small mb-1">
				
						<?php if(!empty($age)){ ?><span><?php echo esc_attr($age) . ' ' . esc_html__( 'years old', 'datebook' ); ?></span>, <?php } ?> 

						<span title="<?php if(isset($datebook_gender_titles[$gender])){ echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span> <br />

						<?php 

						if (isset($city)) {
						echo esc_attr($city);
						}
						if (!empty($city) && !empty($country)) {
							echo ', ';
						}
						if (isset($country)) {
							echo esc_attr($country);
						}

						?>

						</p>
					</div>
				</div>

			<?php }} ?>

		<?php endwhile; ?>

		<?php

		wp_reset_postdata();

		$total = ceil($the_query->found_posts / $posts_per_page);

		$base = get_permalink(of_get_option('all_classifieds_page'));
		$format = get_option('permalink_structure') ? 'page/%#%/' : '?paged=%#%';

		if (isset($the_query->found_posts) && $the_query->found_posts > $posts_per_page) {

			echo '<hr />';

		}

		DateBook_Utilities::datebook_custom_pagination($total, $paged, $format, $base);

	} else {

		esc_html_e( 'No classifieds yet', 'datebook' );

	}

?>
</div>