<?php
/*
 * Comment form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_query;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_the_ID();

/*$basepath = implode('/', array_slice(explode('/', $_SERVER['SCRIPT_NAME']), 0, -1)) . '/';
$uri = substr($_SERVER['REQUEST_URI'], strlen($basepath));
if (strstr($uri, '?')) $uri = substr($uri, 0, strpos($uri, '?'));
$profile_slug = basename(trim($uri, '/'));*/

$comment_page_permalink = get_permalink($profile_id);

$comment_args = array(
	'orderby' => 'comment_date_gmt',
	'order' => 'DESC',
	'status'  => 'approve',
	'post_id' => $profile_id,
	'meta_key' => 'comment_type',
    'meta_value' => DATEBOOK_REVIEW_TYPE,
	'no_found_rows' => false,
	'update_comment_meta_cache' => false
);

$comment_args = apply_filters( 'comments_template_query_args', $comment_args );
$comment_query = new WP_Comment_Query( $comment_args );
$comments_flat = $comment_query->comments;
$wp_query->comments = apply_filters( 'comments_array', $comments_flat, $profile_id );
$comments = &$wp_query->comments;
$wp_query->comment_count = count($wp_query->comments);

?>

<div class="datebook-profile-comments">

		<h2 class="mb-4"><?php esc_html_e( 'Reviews', 'datebook' ); ?> <span class="badge indigo"><?php echo absint($wp_query->comment_count); ?></span></h2>

		<?php

		if ( $wp_query->comment_count > 0 ) {

			foreach ( $comments as $comment ) {

				$comment_id = $comment->comment_ID;
				$comment_post_time = DateBook_Utilities::datebook_date_i18n(2, $comment->comment_date);

				$commenter_id = get_user_meta( $comment->user_id, 'profile_postid', true);
				$commenter_id = isset($commenter_id) && $commenter_id > 0 ? $commenter_id : 0;

				$commenter_data = get_post($commenter_id);
				
				$commenter_data_id = isset($commenter_data->ID) && $commenter_data->ID > 0 ? $commenter_data->ID : 0;
				
				$post_title = isset($commenter_data->post_title) ? $commenter_data->post_title : esc_html__( 'Deleted', 'datebook' );

				$get_profile_data = get_post_meta($commenter_data_id, 'profile_personal_data', true);
				$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

				$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($commenter_id, 'image_avatar', $gender, true, $datebook_get_data);
				
				$get_permalink_commenter = $commenter_id > 0 ? get_permalink($commenter_id) : '';

				?>

				<div class="media">
					<div class="media-left">

						<?php if (isset($commenter_data->ID) && $commenter_data->ID > 0 && isset($commenter_data->post_title)) { ?>

							<a id="commentid_<?php echo absint($comment_id); ?>" href="<?php echo esc_url($get_permalink_commenter); ?>" title="<?php echo esc_attr($post_title); ?>"><img class="rounded-circle" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" data-rjs="2" /></a>

						<?php } else { ?>

							<img class="rounded-circle" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" data-rjs="2" />

						<?php } ?>

					</div>
					<div class="media-body">

						<?php 

						if ($current_user_id == $comment->user_id || is_super_admin()) {

							$delete_review_url = add_query_arg( array(
								'show' => 'reviews',
								'action' => 'deletereview',
								'sid' => $comment_id
							), $comment_page_permalink );

							?>

							<a class="btn btn-sm btn-grey float-right" href="<?php echo esc_url($delete_review_url); ?>" title="<?php esc_html_e( 'Delete this review', 'datebook' ); ?>"><i class="fa fa-trash"></i></a>

						<?php } ?>

						<h5 class="datebook-profile-heading datebook-ellipsis small">

						<?php if (isset($commenter_data->ID) && $commenter_data->ID > 0 && isset($commenter_data->post_title)) { ?>

							<a href="<?php echo esc_url($get_permalink_commenter); ?>" title="<?php echo esc_attr($post_title); ?>"><?php echo esc_attr($post_title); ?></a> 

						<?php } else { ?>

							<?php echo esc_attr($post_title); ?>

						<?php } ?>

						<span class="small text-grey">(<?php echo esc_attr($comment_post_time); ?>)</span></h5>

						<?php echo DateBook_Class_Reviews::datebook_reviews_show_rating( $profile_id, $comment->comment_ID ) ?>
						
						<?php if ( $comment->comment_approved == '0' ) { ?>
							<?php echo esc_html__( 'Your review is awaiting moderation.', 'datebook' ); ?>
						<?php } ?>
						
						<p><?php echo wp_kses_post($comment->comment_content); ?></p>
						
						<?php
						$reviews_settings = of_get_option('enable_reply_reviews') ? 1 : 0;
						if (current_user_can( 'administrator' ) || $reviews_settings == 1) {
						?>
						<div class="reply">
							<?php comment_reply_link( array_merge( $args, array( 'add_below' => 'review' ) ) ) ?>
						</div>
						<?php } ?>

					</div>
				</div>
				<?php } ?>

			<?php } else { ?>

				<div class="card border-0 mb-3">
					<div class="card-body text-center">

						<h4 class="card-title"><?php esc_html_e( 'No reviews', 'datebook' ); ?></h4>

					</div>
                    
					<img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-reviews.png');?>" alt="" />
                    
				</div>

			<?php } ?>

		<div class="datebook-registerpage">

			<?php if (is_user_logged_in()) {

				$review_form_url = add_query_arg( array(
					'show' => 'reviews'
				), $comment_page_permalink );

				?>

				<form action="<?php echo esc_url($review_form_url);?>" method="post">

					<input type="hidden" name="action" value="submit_review" />
					<input type="hidden" name="comment_type" value="profile_review" />
					<input type="hidden" name="review_type" value="profile_review" />
					<input type="hidden" name="comment_parent" id="comment_parent" value="0" />
					
					<?php echo DateBook_Class_Reviews::datebook_review_rating_html(); ?>

					<div class="form-group">
						<label for="datebook-comment-description" class="control-label"><?php esc_html_e( 'Write your review', 'datebook' ); ?></label>
						<textarea name="review_description" rows="2" cols="50" id="datebook-comment-description" class="form-control"></textarea>
						<div class="datebook-charcount">
			    	        <div class="progress">
            				  <div id="datebook-progressslide" class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
			            	</div>
						</div>
					</div>
					<div class="form-group">
						<button type="submit" name="submit" class="btn btn-primary"><?php esc_html_e( 'Submit', 'datebook' ); ?></button> <div id="datebook-count" class="badge badge-light float-right"> <?php echo esc_attr(of_get_option('review_max_chars')) . ' ' . esc_html__( 'characters max', 'datebook' ); ?> </div>
					</div>
				</form>

			<?php

			} else {

				echo '<div class="alert alert-warning">'.esc_html__( 'You need to', 'datebook' ).' <a class="btn-link" href="'.esc_url(get_permalink(of_get_option('registration_page'))).'">'.esc_html__( 'register', 'datebook' ).'</a> '.esc_html__( 'or', 'datebook' ).' <a class="btn-link" href="'.esc_url(get_permalink(of_get_option('login_page'))).'">'.esc_html__( 'login', 'datebook' ).'</a> '.esc_html__( 'to be able to post a review', 'datebook' ).'</div>';
				
			}

			?>

		</div>
	</div>