<?php
/*
 * Contact form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_alert_error, $datebook_alert_text;


if (isset($datebook_alert_text['success_text']) && $_POST['action'] == 'contactus') {

	echo '<div class="alert alert-success">' . esc_attr($datebook_alert_text['success_text']) . '</div>';

}

if (isset($datebook_alert_text['error_required_fields']) && $_POST['action'] == 'contactus') {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';

}

?>


<div class="datebook-custom-card card">
	<div class="card-body">

<h1><?php esc_html_e( 'Contact us', 'datebook' ); ?></h1>

<hr />

<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-12">

		<p class="h4 mb-4"><?php esc_html_e( 'Write to us', 'datebook' ); ?></p>

		<!-- Material form contact -->
		<form action="<?php echo esc_url(get_permalink(get_the_ID())); ?>" method="post">
			<input type="hidden" name="action" value="contactus" />
			<input type="text" name="emails" value="" style="display:none;" />

		    <!-- Material input text -->
		    <div class="md-form <?php if (isset($datebook_alert_text['your_name'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_name'])); } ?>">

        		<i class="fa fa-user prefix grey-text"></i>
		        <input type="text" name="contacting_name" id="datebook-contacting-name" class="form-control" value="<?php if (isset($contacting_name)) { echo esc_attr($contacting_name); } ?>" />
        		<label for="datebook-contacting-name"><?php esc_html_e( 'Name', 'datebook' ); ?></label>

				<?php 

				if (isset($datebook_alert_text['your_name'])) {

					echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_name'])."</em>";

				}

				?>

		    </div>

			<!-- Material input email -->
			<div class="md-form <?php if (isset($datebook_alert_text['your_email'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_email'])); } ?>">

				<i class="fa fa-envelope prefix grey-text"></i>
				<input type="text" name="contacting_email" id="datebook-contacting-email" value="<?php if (isset($contacting_email)) { echo sanitize_email($contacting_email); } ?>" class="form-control" />
				<label for="datebook-contacting-email"><?php esc_html_e( 'Email', 'datebook' ); ?>:</label>
				
				<?php 

				if (isset($datebook_alert_text['your_email'])) {

					echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_email'])."</em>";

				}

				?>

			</div>

			<!-- Material textarea message -->
			<div class="md-form <?php if (isset($datebook_alert_text['your_text'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_text'])); } ?>">

				<i class="fa fa-pencil prefix grey-text"></i>
				<textarea type="text" name="contacting_text" id="datebook-contacting-text" rows="5" cols="42" class="form-control md-textarea"><?php if (isset($contacting_text)) { echo esc_textarea($contacting_text); } ?></textarea>
				<label for="datebook-contacting-text"><?php esc_html_e( 'Message', 'datebook' ); ?>:</label>

				<?php 

				if (isset($datebook_alert_text['your_text'])) {

					echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_text'])."</em>";

				}

				?>

			</div>
			
			<div class="text-center mt-4">

				<button type="submit" name="submit" class="btn btn-primary"><?php esc_html_e( 'Send message', 'datebook' ); ?></button>

			</div>
			
		</form>
		<!-- Material form contact -->
		
	</div>


	<hr class="datebook-clear20 d-xl-none d-md-none d-sm-block" />


	<div class="col-lg-6 col-md-6 col-sm-12">
	
		<p class="h4 mb-4"><?php esc_html_e( 'Our location', 'datebook' ); ?></p>

		<address>

		<?php if (of_get_option('company_title_' . DATEBOOK_WPLANG) != '') { ?>
		<p class="h5 mb-3"><?php echo esc_attr(of_get_option('company_title_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		<?php if (of_get_option('contact_phone_number_' . DATEBOOK_WPLANG) != '') { ?>
		<p><abbr title="<?php esc_html_e( 'Phone', 'datebook' ); ?>"><?php esc_html_e( 'Phone', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option('contact_phone_number_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		<?php if (of_get_option('contact_address_street_' . DATEBOOK_WPLANG) != '') { ?>
		<p><abbr title="<?php esc_html_e( 'Address', 'datebook' ); ?>"><?php esc_html_e( 'Address', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option('contact_address_street_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		<?php if (of_get_option('contact_address_city_' . DATEBOOK_WPLANG) != '') { ?>
		<p><abbr title="<?php esc_html_e( 'City', 'datebook' ); ?>"><?php esc_html_e( 'City', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option('contact_address_city_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		<?php if (of_get_option('contact_address_country_' . DATEBOOK_WPLANG) != '') { ?>
		<p><abbr title="<?php esc_html_e( 'Country', 'datebook' ); ?>"><?php esc_html_e( 'Country', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option('contact_address_country_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		<?php if (of_get_option('contact_email_' . DATEBOOK_WPLANG) != '') { ?>
		<p><abbr title="<?php esc_html_e( 'Email', 'datebook' ); ?>"><?php esc_html_e( 'Email', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option('contact_email_' . DATEBOOK_WPLANG)); ?></p>
		<?php } ?>

		</address>

	</div>
</div>

</div>
</div>