<?php
/*
 * Contact form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_alert_error, $datebook_alert_text;


if (isset($datebook_alert_text['success_text']) && $_POST['action'] == 'contactus') {

	echo '<div class="alert alert-success">' . esc_attr($datebook_alert_text['success_text']) . '</div>';

}

if (isset($datebook_alert_text['error_required_fields']) && $_POST['action'] == 'contactus') {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';

}

?>

<!-- Material form contact -->
<form action="<?php echo esc_url(get_permalink(get_the_ID())); ?>" method="post">
	<input type="hidden" name="action" value="contactus" />
	<input type="text" name="emails" value="" style="display:none;" />

    <!-- Material input text -->
    <div class="md-form <?php if (isset($datebook_alert_text['your_name'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_name'])); } ?>">

		<i class="fa fa-user prefix grey-text"></i>
		<input type="text" name="contacting_name" id="datebook-contacting-name" class="form-control" value="<?php if (isset($contacting_name)) { echo esc_attr($contacting_name); } ?>" />
        <label for="datebook-contacting-name"><?php esc_html_e( 'Name', 'datebook' ); ?></label>

		<?php 

		if (isset($datebook_alert_text['your_name'])) {

			echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_name'])."</em>";

		}

		?>

    </div>

	<!-- Material input email -->
	<div class="md-form <?php if (isset($datebook_alert_text['your_email'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_email'])); } ?>">

		<i class="fa fa-envelope prefix grey-text"></i>
		<input type="text" name="contacting_email" id="datebook-contacting-email" value="<?php if (isset($contacting_email)) { echo sanitize_email($contacting_email); } ?>" class="form-control" />
		<label for="datebook-contacting-email"><?php esc_html_e( 'Email', 'datebook' ); ?>:</label>

		<?php 

		if (isset($datebook_alert_text['your_email'])) {

			echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_email'])."</em>";

		}

		?>

	</div>

	<!-- Material textarea message -->
	<div class="md-form <?php if (isset($datebook_alert_text['your_text'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['your_text'])); } ?>">

		<i class="fa fa-pencil prefix grey-text"></i>
		<textarea type="text" name="contacting_text" id="datebook-contacting-text" rows="5" cols="42" class="form-control md-textarea"><?php if (isset($contacting_text)) { echo esc_textarea($contacting_text); } ?></textarea>
		<label for="datebook-contacting-text"><?php esc_html_e( 'Message', 'datebook' ); ?>:</label>

		<?php 

		if (isset($datebook_alert_text['your_text'])) {

			echo '<em class="text-error">'.esc_attr($datebook_alert_text['your_text'])."</em>";

		}

		?>

	</div>

	<div class="text-center mt-4">

		<button type="submit" name="submit" class="btn btn-primary"><?php esc_html_e( 'Send message', 'datebook' ); ?></button>

	</div>

</form>
<!-- Material form contact -->