<?php
/*
 * Contact form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="datebook-custom-card card">
	<div class="card-body">

		<h1><?php esc_html_e( 'Contact us', 'datebook' ); ?></h1>

		<hr />

		<div class="row">
			<div class="col-lg-6 col-md-6 col-sm-12">

				<?php echo DateBook_Contact_Page::datebook_return_contact_form(); ?>

			</div>

			<hr class="datebook-clear20 d-xl-none d-md-none d-sm-block" />

			<div class="col-lg-6 col-md-6 col-sm-12">

				<p class="h4 mb-4"><?php esc_html_e( 'Our location', 'datebook' ); ?></p>

				<address>

				<?php if (of_get_option("company_title_" . DATEBOOK_WPLANG) != "") { ?>
					<p class="h5 mb-3"><?php echo esc_attr(of_get_option("company_title_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				<?php if (of_get_option("contact_phone_number_" . DATEBOOK_WPLANG) != "") { ?>
					<p><abbr title="<?php esc_html_e( 'Phone', 'datebook' ); ?>"><?php esc_html_e( 'Phone', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option("contact_phone_number_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				<?php if (of_get_option("contact_address_street_" . DATEBOOK_WPLANG) != "") { ?>
					<p><abbr title="<?php esc_html_e( 'Address', 'datebook' ); ?>"><?php esc_html_e( 'Address', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option("contact_address_street_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				<?php if (of_get_option("contact_address_city_" . DATEBOOK_WPLANG) != "") { ?>
					<p><abbr title="<?php esc_html_e( 'City', 'datebook' ); ?>"><?php esc_html_e( 'City', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option("contact_address_city_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				<?php if (of_get_option("contact_address_country_" . DATEBOOK_WPLANG) != "") { ?>
					<p><abbr title="<?php esc_html_e( 'Country', 'datebook' ); ?>"><?php esc_html_e( 'Country', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option("contact_address_country_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				<?php if (of_get_option("contact_email_" . DATEBOOK_WPLANG) != "") { ?>
					<p><abbr title="<?php esc_html_e( 'Email', 'datebook' ); ?>"><?php esc_html_e( 'Email', 'datebook' ); ?>:</abbr> <?php echo esc_attr(of_get_option("contact_email_" . DATEBOOK_WPLANG)); ?></p>
				<?php } ?>

				</address>

			</div>
		</div>
	</div>
</div>