<?php
/*
 * Background image (pattern) selector for Featured profile page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$bg_topsuggest_image = of_get_option('bg_featured_images_panel');

$datebook_topsuggest_bg = 'style="background: #000 url(' . esc_url($bg_topsuggest_image) . ') no-repeat center center; background: -ms-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -moz-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -o-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-gradient(linear, left top, left bottom, color-stop(0, rgba(0, 0, 0, 0)), color-stop(100, rgba(255, 255, 255, 0.4))) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-linear-gradient(top, rgba(0, 0, 0, 0) 0%, rgba(255, 255, 255, 0.8) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: linear-gradient(to bottom, rgba(0, 0, 0, 0) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover;"';
			
?>

<div class="card card-image border-0 mb-3 white datebook-featured-images-panel" <?php echo $datebook_topsuggest_bg; ?>>

	<div class="card-body">

		<h6 class="card-title mb-0"><?php esc_html_e( 'Choose a background for your profile', 'datebook' ); ?> <button class="btn btn-sm btn-info p-1 pl-3 pr-3" type="button" data-toggle="collapse" data-target="#collapseTopOfferOnSearch" aria-expanded="false" aria-controls="collapseTopOfferOnSearch"><?php esc_html_e( 'show', 'datebook' ); ?></button></h6>

		<div class="collapse mt-2" id="collapseTopOfferOnSearch">

		<hr />

		<ul class="list-inline m-0">

		<?php

		$count_image = 0;

		foreach ( $featured_background_images as $value ) :
		
			$count_image++;
			$count_random = rand(1000000, 100000000000000);

			$selected = ( $value == $featured_pattern ) ? ' active' : '';

			echo '<li class="list-inline-item mb-2 datebook-featured-image-id-' . $count_image . '-' . $count_random . '' . $selected . '"><a class="datebook-featured-image" profile-id="' . esc_attr( $profile_id ) . '" data-url="' . esc_attr( $value ) . '" data-id="' . esc_attr( $count_image . '-' . $count_random ) . '" href="javascript:void(0)">';
			echo '<img src="' . esc_url( $value ) . '" alt="" />';
			echo '</a></li>';

		endforeach;

		?>

		</ul>

		</div>
	</div>
</div>