<?php
/**
 * The default template for displaying Featured profiles
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

// Get current user ID
if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
	}

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );
$featured_period = get_post_meta($profile_id, 'featured', true);

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

$plans_count = $suggest_plan_count = 0;

if ($shortcode == 1) {

} else {

	// Check if Payment and Subscription are activated
	if (DateBook_Utilities::check_if_gateway_activated()) {

		// Get Subscription plans
		$get_subscription_plans = get_option('datebook_subscription_plans');

		if (is_array($get_subscription_plans)){

			foreach($get_subscription_plans as $key => $value){

				if (isset($value['active']) && $value['active'] == 1) {

					$plans_count++;

				}
				if (isset($value['suggest_featured_position']) && $value['suggest_featured_position'] == 1) {

					$suggest_plan_count++;

				}
			}
		}
	}

}


if (is_user_logged_in() && ($plans_count > 0 || $suggest_plan_count > 0)){
	if ($featured_period == 0){
		$quantity = $quantity - 1;
	}
}


if ($with_images == 1) {

	$show_feat_profiles_args = array(
		'key' => 'profile_photo_id',
		'value' => '',
		'compare' => '!=',
	);

} else {

	$show_feat_profiles_args = '';

}

$args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'orderby' => 'rand',
	'meta_query' => array(
		array(
			'key' => 'featured',
			'value' => '1',
			'compare' => '=',
			'type' => 'NUMERIC'
		),
		$show_feat_profiles_args
	),
	'posts_per_page' => $quantity
);

$the_query = new WP_Query( $args );


if ( $the_query->have_posts() ) : 

	
	$featured_panel_topmargin = $featured_panel_margin ? 'mt-' . $featured_panel_margin . ' mb-' . $featured_panel_margin : '';

	$datebook_featured_front_class = ($is_front_page == 1) ? 'datebook-featured-front' : 'datebook-featured-other';
	
	$image_feature_array = $is_front_page == 1 ? 'image_feature_front' : 'image_feature_other';

	if (of_get_option( 'featured_panel_width' ) == 'full') {

	?>

	<div id="<?php echo esc_attr($datebook_featured_front_class); ?>" class="mb-3 <?php echo esc_attr($featured_panel_topmargin); ?>" style="background:<?php echo esc_attr($featured_panel_color); ?>">
		<div class="container">

<?php } else { ?>

	<div id="<?php echo esc_attr($datebook_featured_front_class); ?>" class="container mb-3 <?php echo esc_attr($featured_panel_topmargin); ?>">
		<div style="background:<?php echo esc_attr($featured_panel_color); ?>">

<?php }

	$margin_out = !empty($margin) ? 'margin:' . $margin . 'rem;' : '';
	$margin_left_right = !empty($margin) ? 'margin-left:-' . $margin . 'rem; margin-right:-' . $margin . 'rem;' : '';

	$padding_out = !empty($padding) ? 'padding:' . $padding . 'rem;' : '';

	$border_mode = '';

	if($border_width == '0' && is_numeric($border_width)) {
		$border_bootstrap = '';
		$border_width_out = ' border-width: 0px !important;';
	} else if($border_width > 0 && is_numeric($border_width)) {
		$border_bootstrap = ' border';
		$border_width_out = ' border-width: ' . $border_width . 'px !important;';
	} else if (isset($border_width) && !empty($border_width) && preg_match('/^\d+(?:,\d+)*$/', $border_width) ){
		$border_bootstrap = ' border';
		$get_border_number = explode(',', $border_width);
		$border_mode = 'random';
	} else {
		$border_bootstrap = '';
		$border_width_out = '';
	}

	$border_style_out = !empty($border_bootstrap) && !empty($border_style) ? 'border-style:' . $border_style . ';' : '';


	switch($how_many_columns_on_mobile) {
		case 0 : $mobile_columns = 'd-none d-md-block'; $columns_mobile_clear = 1; break; // 0 columns
		case 1 : $mobile_columns = 'col-sm-12'; $columns_mobile_clear = 1; break; // 1 columns
		case 2 : $mobile_columns = 'col-sm-6 col-6'; $columns_mobile_clear = 2; break; // 2 columns
		case 3 : $mobile_columns = 'col-sm-4 col-4'; $columns_mobile_clear = 3; break; // 3 columns
		case 4 : $mobile_columns = 'col-sm-3 col-3'; $columns_mobile_clear = 4; break; // 4 columns
		case 5 : $mobile_columns = 'col-sm-2 col-2'; $columns_mobile_clear = 6; break; // 6 columns
		default: $mobile_columns = 'col-sm-4 col-6'; $columns_mobile_clear = 3; break; // 3 columns
	}

	$display_on_mobile = $how_many_columns_on_mobile > 0 ? 'd-md-none' : 'd-none';

	switch($how_many_columns_on_tablet) {
		case 0 : $tablet_columns = $display_on_mobile . ' d-lg-block'; $columns_tablet_clear = 2; break; // 0 columns
		case 1 : $tablet_columns = 'col-md-6'; $columns_tablet_clear = 2; break; // 2 columns
		case 2 : $tablet_columns = 'col-md-4'; $columns_tablet_clear = 3; break; // 3 columns
		case 3 : $tablet_columns = 'col-md-3'; $columns_tablet_clear = 4; break; // 4 columns
		case 4 : $tablet_columns = 'col-md-2'; $columns_tablet_clear = 6; break; // 6 columns
		case 5 : $tablet_columns = 'col-md-1'; $columns_tablet_clear = 12; break; // 12 columns
		default: $tablet_columns = 'col-md-3'; $columns_tablet_clear = 4; break; // 4 columns
	}
	
	$display_on_tablet = $how_many_columns_on_tablet > 0 ? 'd-lg-none' : 'd-none';

	switch($how_many_columns_on_normal) {
		case 0 : $normal_columns = $display_on_tablet . ' d-xl-block'; $columns_normal_clear = 2; $columns_image_format = 'image_medium'; break; // 0 columns
		case 1 : $normal_columns = 'col-lg-6'; $columns_normal_clear = 2; $columns_image_format = 'image_medium'; break; // 2 columns
		case 2 : $normal_columns = 'col-lg-4'; $columns_normal_clear = 3; $columns_image_format = $image_feature_array; break; // 3 columns
		case 3 : $normal_columns = 'col-lg-3'; $columns_normal_clear = 4; $columns_image_format = 'image_medium'; break; // 4 columns
		case 4 : $normal_columns = 'col-lg-2'; $columns_normal_clear = 6; $columns_image_format = 'image_medium'; break; // 6 columns
		case 5 : $normal_columns = 'col-lg-1'; $columns_normal_clear = 12; $columns_image_format = 'image_medium'; break; // 12 columns
		default: $normal_columns = 'col-lg-2'; $columns_normal_clear = 6; $columns_image_format = 'image_medium'; break; // 6 columns
	}

	$display_on_normal = $how_many_columns_on_normal > 0 ? '' : 'd-none';

	switch($how_many_columns_on_large) {
		case 0 : $large_columns = $display_on_normal . ' d-xl-none'; $columns_large_clear = 2; $columns_image_format = $image_feature_array; break; // 0 columns
		case 1 : $large_columns = 'col-xl-6'; $columns_large_clear = 2; $columns_image_format = $image_feature_array; break; // 2 columns
		case 2 : $large_columns = 'col-xl-4'; $columns_large_clear = 3; $columns_image_format = $image_feature_array; break; // 3 columns
		case 3 : $large_columns = 'col-xl-3'; $columns_large_clear = 4; $columns_image_format = $image_feature_array; break; // 4 columns
		case 4 : $large_columns = 'col-xl-2'; $columns_large_clear = 6; $columns_image_format = $image_feature_array; break; // 6 columns
		case 5 : $large_columns = 'col-xl-1'; $columns_large_clear = 12; $columns_image_format = $image_feature_array; break; // 12 columns
		default: $large_columns = 'col-xl-1'; $columns_large_clear = 12; $columns_image_format = $image_feature_array; break; // 12 columns
	}


	$quantity_columns_class = $mobile_columns . ' ' . $tablet_columns . ' ' . $normal_columns . ' ' . $large_columns;


	$display_responsive_123 = $display_responsive_4 = '';
	
	if(($style == 1 || $style == 2 || $style == 3) && $how_many_columns_on_large == 5){
		$display_responsive_123 = 'd-block d-lg-none d-xl-none';
		$display_responsive_4 = 'd-none d-lg-block d-xl-block';
	}


	$show_age = isset($featured_info_front['age']) && $featured_info_front['age'] == 1 && DateBook_Utilities::datebook_show_field('birthdate', 1) ? 1 : 0;


	$show_sexual_orientation = (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

	$show_gender = (isset($featured_info_front['gender']) && $featured_info_front['gender'] == 1 && DateBook_Utilities::datebook_show_field('gender', 1) && (of_get_option('gender_allowed') != '' || of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

	$show_location = DateBook_Utilities::datebook_show_field('countrycity', 1) ? 1 : 0;
	
	$datebook_profiles_list = ($style == 3) ? ' datebook-profiles-list' : '';

	switch ($style) {
		case '1' : $card_img = ' card-img-top'; $style_full_content = 'datebook-featured-full'; break;
		case '2' : $card_img = ' card-img'; $style_full_content = 'datebook-featured-short'; break;
		case '3' : $card_img = ' card-img-top'; $style_full_content = 'datebook-featured-short'; break;
		case '4' : $card_img = ' card-img-top'; $style_full_content = 'datebook-featured-short'; break;
		default: $card_img = ' card-img-top'; $style_full_content = 'datebook-featured-full'; break;
	}

	// set up cache folder
	$upload_dir = wp_upload_dir();
	$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');
	
	$border_color_out = '';

	?>

	<div class="datebook-featured-header">
		<div class="row<?php echo esc_attr($datebook_profiles_list); ?>" style=" <?php echo esc_attr($margin_left_right);?>">

		<?php

		if (is_user_logged_in() && $suggest_plan_count > 0 && $featured_period == 0){
			
			$datebook_add_featured_sign = DATEBOOK_URL . 'assets/images/offer-featured-position.png';

			// display the panel suggesting Featured position
			include DateBook_Template_Loader::locate( 'featured/offer-featured-status' );

		}

		while ( $the_query->have_posts() ) : $the_query->the_post();

			$profile_id = absint(get_the_ID());

			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			$country = $region = $city = '';

			if($show_location == 1 && isset($datebook_get_data['city'])){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$city = isset($term_data->city) ? $term_data->city : '';
				$country = isset($term_data->country) ? $term_data->country : '';

			}

			$age = 0;
			if($show_age == 1){

				$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : '';

				if($age > 0){
					$age_title = $age . ' ' . esc_html__( 'years old', 'datebook' );
				}
			}

			$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';
			$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

			if ($gender == 1) {
				$gender_icon = 'fa fa-venus fa-lg';
			} else if ($gender == 2) {
				$gender_icon = 'fa fa-mars fa-lg';
			} else {
				$gender_icon = 'fa fa-user fa-lg';
			}

			$all_photos_args = array(
				'post_parent' => $profile_id, 
				'post_status' => 'inherit', 
				'post_type' => 'attachment', 

				'post_mime_type' => 'image', 
				'order' => 'ASC', 
				'orderby' => 'menu_order ID',
				'posts_per_page' => -1,
				'meta_query' => array(
					array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
				)
			);

			$all_photos = new WP_Query( $all_photos_args );
			$all_photos_count = $all_photos->found_posts - 1;
			$all_photos_count = ($all_photos_count > 0) ? $all_photos_count : 0;


			$get_the_title = get_the_title();

			$location = '';

			if ($city_show == 1) {
				$location .= $city;
			}
			if ($city_show == 1 && $country_show == 1) {
				$location .= ',';
			}
			if ($country_show == 1) {
				$location .= ' ';
				$location .= $country;
			}

			$title_for_alt = $get_the_title;

			if($show_age == 1 && $age > 0){
				$title_for_alt .= ', ' . $age_title;
			}

			if ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])){
				
				$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
				
				$title_for_alt .= ', ';
				$title_for_alt .= esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );
			}

			if ($show_gender == 1 && $gender > 0 && isset($datebook_gender_titles[$gender])){
				$title_for_alt .= ', ';
				$title_for_alt .= esc_html__( $datebook_gender_titles[$gender], 'datebook' );
			}

			if ($show_location == 1 && $city_show ==1 && $country_show == 1) {
				$title_for_alt .= ', ';
				$title_for_alt .= $location;
			}

			if($border_mode == 'random'){
				$first_border = (isset($get_border_number[0]) && is_numeric($get_border_number[0])) ? $get_border_number[0] > 0 ? $get_border_number[0] : 1 : 1;
				$last_border = (isset($get_border_number[1]) && is_numeric($get_border_number[1])) ? $get_border_number[1] > 0 ? $get_border_number[1] : 12 : 12;
				$border_width_out = ' border-width: ' . mt_rand($first_border, $last_border) . 'px !important;';
			}

			if(!empty($border_color)){
				$border_color_out = 'border-color: ' . $border_color . ' !important;';
			} else if(!empty($color_gamma)){
				$border_color_out = 'border-color: ' . DateBook_Utilities::create_random_color($border_color, $color_gamma) . ' !important;';
			} else {
				$border_color_out = '';
			}

			$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data);

			if($thumbnail_url['image_exists'] == 'yes'){

				$profile_image_url = $thumbnail_url['img_full_url'];

			} else {

				$profile_image_url = $cache_url . $columns_image_format . '.png';

			}

			?>

		<div class="<?php echo esc_attr($quantity_columns_class);?> datebook-profile-caption">
			<div class="row">
		
			<?php if ($style == 1 || $style == 2 || $style == 3) { ?>

			<div class="<?php echo esc_attr($display_responsive_123);?> w-100 <?php if($style == 2){ ?> view overlay zoom<?php } else if($style == 3){ ?> datebook-hide datebook-profiles<?php } ?>" style=" <?php echo esc_attr($margin_out);?>">

				<div class="card datebook-featured-profile <?php echo esc_attr($style_full_content); ?>" style=" <?php echo esc_attr($border_width_out . $border_style_out . $border_color_out); ?>">
					<div class="view overlay datebook-profile-caption">

						<a class="w-100 datebook-profile-inline-caption white" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 95%"><img class="img-fluid<?php echo esc_attr($card_img); ?>" width="<?php echo esc_attr($thumbnail_url['width']); ?>" height="<?php echo esc_attr($thumbnail_url['height']); ?>" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($get_the_title); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a> 

						<?php if ($enable_profile_comments == '1' && $comments_show == 1) { 

							$count_profile_comments = DateBook_Utilities::datebook_count_profile_comments($profile_id);

							?>

							<span class="datebook-profile-comment-caption" title="<?php echo esc_attr($count_profile_comments); ?> <?php esc_html_e( 'Comments', 'datebook' );?>"><i class="fa fa-comments"></i> <?php echo esc_attr($count_profile_comments); ?></span>

						<?php } ?>

						<?php if ($moreimages_show == '1') { ?>

							<span class="datebook-profile-pictures-caption" title="<?php echo esc_attr($all_photos_count); ?> <?php echo esc_html__( 'more photos', 'datebook' ); ?>"><i class="fa fa-camera"></i> <?php echo esc_attr($all_photos_count); ?> </span>

						<?php } ?>
								
					</div>

					<div class="card-body <?php if($style == 2){ ?> mask flex-center rgba-white-strong<?php } else if($style == 3){ ?> datebook-hide-body<?php } ?> datebook-search-profile-body over" style=" <?php echo esc_attr($padding_out); ?>">
					
					<div class="datebook-profile-body">

						<h5 class="card-title datebook-profile-heading datebook-ellipsis-width"><a href="<?php the_permalink(); ?>"><?php echo esc_html($get_the_title); ?></a></h5>

						<?php if($show_age == 1 || ($show_sexual_orientation == 1 && $sexorientation_show == '1') || ($show_gender == 1 && $gender > 0)){ ?>

							<p class="card-text mb-1">

							<?php if($show_age == 1 && $age > 0){ ?>

								<span title="<?php echo esc_attr($age_title); ?>"><?php echo esc_attr($age); ?> <?php if ($columns_large_clear == 6) { ?><span class="d-none"><?php } ?><?php echo esc_html__( 'years old', 'datebook' ); ?><?php if ($columns_large_clear > 3) { ?></span><?php } ?></span> 

							<?php } ?>

							<?php if ($show_sexual_orientation == 1 && $sexorientation_show == '1') { ?>

							<span class="badge badge-pill badge-info shadow-none"><?php if(isset($datebook_sexualorientation_titles[$sexualorientation])){
								
								$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
								
								echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' ); } ?></span> 

							<?php } ?>

							<?php if ($show_gender == 1 && $gender > 0){ ?>

								<span title="<?php if(isset($datebook_gender_titles[$gender])){ echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>

							<?php } ?>	

							</p>

						<?php } ?>

						<?php if ($show_location == 1 && ($city_show == 1 || $country_show == 1)) { ?>
							<p class="card-text datebook-ellipsis" title="<?php echo esc_attr($location); ?>"><?php echo esc_attr($location); ?></p>
						<?php } ?>
						
						</div>

					</div>
				</div>
			</div>

		<?php } if ($style == 4 || $how_many_columns_on_large == 5) { ?>

				<a class="<?php echo esc_attr($style_full_content . ' ' . $display_responsive_4 . ' ' . $border_bootstrap); ?> thumbnail w-100 text-center bg-white datebook-featured-profile datebook-featured-compact" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 75%; <?php echo esc_attr($margin_out . $border_width_out . $border_style_out . $border_color_out); ?>" data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="
				<?php

				if($show_age == 1 && $age > 0){

					echo esc_attr($age_title);

				}

				if ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])){
					
					if($show_age == 1){
						echo ', ';
					}
					
					$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;

					echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );

				}

				if ($show_gender == 1 && $gender > 0){

					echo " <i class='" . esc_attr($gender_icon) . "'></i>";

				}


				if ($show_location == 1) {

					if($show_age == 1 && $age > 0 || ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])) || ($show_gender == 1 && $gender > 0)){
						echo '<br />';
					}

					if ($city_show == 1 && !empty($city)) {
						echo esc_attr($city);
					}
					if ($city_show == 1 && !empty($city) && $country_show == 1 && !empty($country)) {
						echo ', ';
					}
					if ($country_show == 1 && !empty($country)) {
						echo esc_attr($country);
					}
				
				}

				?>"><img class="img-fluid w-100<?php echo esc_attr($card_img); ?>" width="<?php echo esc_attr($thumbnail_url['width']); ?>" height="<?php echo esc_attr($thumbnail_url['height']); ?>" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> />
				
				<?php if ($enable_profile_comments == '1' && $comments_show == 1) { 
					$count_profile_comments = DateBook_Utilities::datebook_count_profile_comments($profile_id);
				?>
				<span class="datebook-profile-comment-caption" title="<?php echo esc_attr($count_profile_comments); ?> <?php esc_html_e( 'Comments', 'datebook' );?>"><i class="fa fa-comments"></i> <?php echo esc_attr($count_profile_comments); ?></span>
				<?php } ?>

				<?php if ($moreimages_show == 1) { ?>
				<span class="datebook-profile-pictures-caption" title="<?php echo esc_attr($all_photos_count); ?> <?php echo esc_html__( 'more photos', 'datebook' ); ?>"><i class="fa fa-camera"></i> <?php echo esc_attr($all_photos_count); ?> </span>
				<?php } ?>
				
				</a>

		<?php } ?>

		</div>
		</div>

		<?php endwhile; ?>

		</div>
	</div>
	
	<?php wp_reset_postdata(); ?>

	</div>				
</div>

<?php

endif;

if ($shortcode == 1) { ?>

	<?php /*?><div class="datebook-custom-card card border-0 w-100">
		<div class="card-body">

			<p class="lead text-center"><?php echo esc_html__( 'No featured profiles yet', 'datebook' ); ?></p>

		</div>
	</div><?php */?>

<?php }