<?php
/*
 * Password Forgot form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_form_error, $datebook_alert_error, $datebook_alert_text;
		
if ( is_wp_error( $datebook_form_error ) ) {
	
	$datebook_alert_error = array();
	$datebook_alert_text = array();
	
	foreach($datebook_form_error->get_error_codes() as $code){
		
		$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
		$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);
		
	}
	
}

?>

<!--Header-->
<div class="header text-center">
	<h2><?php esc_html_e( 'Forgot password?', 'datebook' ); ?></h2>
</div>
<!--Header-->

<div class="mx-4 mt-4">

	<?php if (isset($datebook_alert_text['error_login'])) { ?>
		<div class="alert alert-danger text-center"><?php echo esc_attr($datebook_alert_text['error_login']); ?></div>
	<?php } ?>

	<?php if (isset($datebook_alert_text['success_login'])) { ?>
		<div class="alert alert-success text-center"><?php echo esc_attr($datebook_alert_text['success_login']); ?></div>
	<?php } ?>

	<p><?php esc_html_e( 'Enter your email address and we\'ll send you a link you can use to pick a new password.', 'datebook' ); ?></p>

	<!--Body-->
	<form name="forgotform" id="datebook-forgotform" action="<?php echo esc_url(get_permalink(of_get_option('forgot_password_page'))); ?>" method="post" class="form-signin">

		<input type="hidden" name="forgotpassword" value="1" />

		<div class="md-form">
			<i class="fa fa-envelope prefix grey-text"></i>
			<input type="text" name="log" id="user_login" value="" class="form-control" />
			<label for="user_login"><?php echo esc_html__( 'Email', 'datebook' ); ?></label>
		</div>

		<div class="text-center mb-4">
			<button type="submit" name="submit" class="btn btn-primary btn-lg btn-block"><?php esc_html_e( 'Submit', 'datebook' ); ?></button>
		</div>

		<p class="font-small grey-text d-flex justify-content-center">
			<a href="<?php echo esc_url(get_permalink(of_get_option('login_page'))); ?>" class="dark-grey-text font-weight-bold ml-1"><?php esc_html_e( 'Login', 'datebook' ); ?></a>
		</p>

	</form>

</div>