<?php
/*
 * Password Reset form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_form_error, $datebook_alert_error, $datebook_alert_text, $takekeyreset;
		
if ( is_wp_error( $datebook_form_error ) ) {
	
	$datebook_alert_error = array();
	$datebook_alert_text = array();
	
	foreach($datebook_form_error->get_error_codes() as $code){
		
		$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
		$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);
		
	}
	
}

?>
<!--Header-->
<div class="header text-center">
	<h2><?php esc_html_e( 'Create new password', 'datebook' ); ?></h2>
</div>
<!--Header-->

<div class="card-body mx-4 mt-4">

	<?php if (isset($datebook_alert_text['error_login'])) { ?>

		<div class="alert alert-danger text-center"><?php echo esc_attr($datebook_alert_text['error_login']); ?></div>

	<?php } ?>

	<?php if (isset($datebook_alert_text['success_login'])) { ?>

		<div class="alert alert-success text-center"><?php echo esc_attr($datebook_alert_text['success_login']); ?></div>

	<?php } ?>

	<!--Body-->
	<form name="resetform" id="datebook-resetform" action="<?php echo esc_url(get_permalink(of_get_option('login_page'))); ?>" method="post" class="form-signin">

		<input type="hidden" name="action" value="resetpassword" />
		<input type="hidden" name="keyreset" value="<?php echo esc_attr($takekeyreset); ?>" />

		<div class="md-form">
			<i class="fa fa-lock prefix grey-text"></i>
			<input type="password" name="pwd1" id="new_pass" value="" class="form-control" />
			<label for="new_pass"><?php esc_html_e( 'Create password', 'datebook' ); ?></label>
		</div>

		<div class="md-form pb-3">
			<i class="fa fa-lock prefix grey-text"></i>
			<input type="password" name="pwd2" id="repeat_pass" value="" class="form-control" />
			<label for="repeat_pass"><?php esc_html_e( 'Confirm password', 'datebook' ); ?></label>
		</div>

		<div class="text-center mb-4">
			<button type="submit" name="submit" class="btn btn-primary btn-lg btn-block"><?php esc_html_e( 'Submit', 'datebook' ); ?></button>
		</div>

		<p class="font-small grey-text d-flex justify-content-center">
			<a href="<?php echo esc_url(get_permalink(of_get_option('login_page'))); ?>" class="dark-grey-text font-weight-bold ml-1"><?php esc_html_e( 'Login', 'datebook' ); ?></a>
		</p>

	</form>

</div>