<?php
/*
 * Sidebar: Edit links shown to logged user only
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if (is_user_logged_in()) {

	$page_id = get_the_ID();

	if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
		$current_user_id = DATEBOOK_CURRENT_USER_ID;
	} else {
		global $current_user;
		wp_get_current_user();
		$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
	}
	
	// If profile ID is not set in post_meta table then let's insert it
	$profile_postid = get_user_meta( $current_user_id, 'profile_postid', true );

	$profile = get_post($profile_postid);

	$profile_id = isset($profile->ID) && $profile->ID > 0 ? $profile->ID : 0;
	$profile_status = isset($profile->post_status) && $profile->post_status == 'publish' ? 'publish' : 'private';
	

	// Show Administrator Dashboard to control Profile
	do_action('datebook_featured_images_panel');

	?>

	<div class="datebook-custom-card card datebook-profile-status-sidebar">
		<div class="card-body">

		<?php

		echo '<p class="m-0">';
		echo '<span>' . esc_html__( 'Profile status', 'datebook' ) . ':</span> ';

		// Show user's profile status: Active or Suspended
		if ($profile_status == 'publish') {

			echo '<span class="badge badge-success shadow-none float-right">' . esc_html__( 'Active', 'datebook' ) . '</span>';

		} else {

			$notactive = get_post_meta($profile_id, 'notactive', true);

			if ($notactive == 1) {
				echo '<span class="badge badge-danger shadow-none float-right">' . esc_html__( 'Suspended', 'datebook' ) . '</span>';
			} else {
				echo '<span class="badge badge-danger shadow-none float-right">' . esc_html__( 'Inactive', 'datebook' ) . '</span>';
			}

		}
		
		echo '</p>';
		
		$plans_count = 0;
		if (DateBook_Utilities::check_if_gateway_activated()) {

			// Get Subscription plans
			$get_subscription_plans = get_option('datebook_subscription_plans');

			if (is_array($get_subscription_plans)){

				foreach($get_subscription_plans as $key => $value){

					if (isset($value['active']) && $value['active'] == 1) {

						$plans_count++;

					}
				}
			}
		}

		if ($plans_count > 0){

			// Show user's topad expiration
			echo '<p class=" mt-3 small">';
			echo esc_html__( 'Top', 'datebook' ) . ': ';
			if (get_post_meta($profile_id, 'topad', true) == 1) {

				$topad_ends = get_post_meta($profile_id, 'topad_ends', true);

				$topad_ends_time = isset($topad_ends) && $topad_ends > 0 ? esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(1, $topad_ends, false) : esc_html__( 'unlimited period', 'datebook' );

				echo '<span class="badge badge-success shadow-none float-right" title="' . esc_html__( 'Your Top status is active', 'datebook' ).' ' . $topad_ends_time . '">' . esc_html__( 'Active', 'datebook' ) . '</span> ' . $topad_ends_time;
			} else {
				echo '<span class="badge badge-light shadow-none float-right">' . esc_html__( 'Inactive', 'datebook' ) . '</span>';
			}
			echo '</p>';

			// Show user's featured expiration
			echo '<p class="m-0 small">';
			echo esc_html__( 'Featured', 'datebook' ) . ': ';
			if (get_post_meta($profile_id, 'featured', true) == 1) {

				$featured_ends = get_post_meta($profile_id, 'featured_ends', true);

				$featured_ends_time = isset($featured_ends) && $featured_ends > 0 ? esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(1, $featured_ends, false) : esc_html__( 'unlimited period', 'datebook' );

				echo '<span class="badge badge-success shadow-none float-right" title="' . esc_html__( 'Your Featured status is active', 'datebook' ).' ' . $featured_ends_time . '">' . esc_html__( 'Active', 'datebook' ) . '</span> ' . $featured_ends_time;
			} else {
				echo '<span class="badge badge-light shadow-none float-right">' . esc_html__( 'Inactive', 'datebook' ) . '</span>';
			}
			echo '</p>';

		}

		?>

		</div>
	</div>

<!-- sidebar -->
<div class="datebook-custom-card card datebook-profile-edit-sidebar">
	<div class="list-group list-group-flush">

		<?php if (of_get_option('contact_method') == 1 || of_get_option('contact_method') == 3) { ?>

			<a class="list-group-item<?php if ($page_id == of_get_option('my_messages_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_messages_page'))); ?>" title=""><i class="fas fa-envelope"></i> <?php esc_html_e( 'Messages', 'datebook' ); ?> <span class="float-right"><?php do_action('datebook_new_msg_alert', 'nosup'); ?></span></a>

		<?php } ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_edit_profile_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_edit_profile_page'))); ?>"><i class="fas fa-edit"></i> <?php esc_html_e( 'Edit profile', 'datebook' ); ?></a> 

		<a class="list-group-item<?php if ($page_id == of_get_option('my_photos_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_photos_page'))); ?>"><i class="fas fa-image"></i> <?php esc_html_e( 'Photos', 'datebook' ); ?></a>

		<?php if (of_get_option('enable_verification') == '1') { ?>

			<a class="list-group-item<?php if ($page_id == of_get_option('my_verification_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_verification_page'))); ?>"><i class="far fa-check-square"></i> <?php esc_html_e( 'Verification', 'datebook' ); ?></a>

		<?php } ?>

		<?php if (of_get_option('enable_friendship') == '1') { ?>

			<a class="list-group-item<?php if ($page_id == of_get_option('my_friends_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_friends_page'))); ?>"><i class="fas fa-user-friends"></i> <?php esc_html_e( 'Friends', 'datebook' ); ?></a>

		<?php } ?>

		<?php

		$enable_favorite_profiles = of_get_option('enable_favorite_profiles');

		if (isset($enable_favorite_profiles['1']) && $enable_favorite_profiles['1'] == '1'){

		?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_favorites_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_favorites_page'))); ?>"><i class="fas fa-bookmark"></i> <?php esc_html_e( 'Favorites', 'datebook' ); ?></a>

		<?php } ?>

		<?php if (of_get_option('enable_blacklisted_profiles') == '1') { ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_blacklist_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_blacklist_page'))); ?>"><i class="fas fa-user-secret"></i> <?php esc_html_e( 'Blacklist', 'datebook' ); ?></a>

		<?php } ?>

		<?php if (of_get_option('enable_profile_comments') == '1') { ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_comments_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_comments_page'))); ?>"><i class="fas fa-comments"></i> <?php esc_html_e( 'Comments', 'datebook' ); ?></a>

		<?php } ?>

		<?php if (of_get_option('enable_classifieds') == '1') { ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_classifieds_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_classifieds_page'))); ?>"><i class="fas fa-bullhorn"></i> <?php esc_html_e( 'Classifieds', 'datebook' ); ?></a>

		<?php } ?>

		<?php if (of_get_option('enable_profile_tours') == '1') { ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_tours_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_tours_page'))); ?>"><i class="fas fa-map-marker"></i> <?php esc_html_e( 'Tours', 'datebook' ); ?></a>

		<?php } ?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_views_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_views_page'))); ?>"><i class="fas fa-eye"></i> <?php esc_html_e( 'Who viewed me', 'datebook' ); ?></a>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_settings_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_settings_page'))); ?>"><i class="fas fa-sliders-h"></i> <?php esc_html_e( 'Settings', 'datebook' ); ?></a>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_privacy_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_privacy_page'))); ?>"><i class="fas fa-lock"></i> <?php esc_html_e( 'Privacy', 'datebook' ); ?></a>

		<?php
		
		$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;
		
		if($enable_subscription == 1){
			
		?>

		<a class="list-group-item<?php if ($page_id == of_get_option('my_upgrade_page')) { echo ' active'; } ?> datebook-transparent" href="<?php echo esc_url(get_permalink(of_get_option('my_upgrade_page'))); ?>" ><i class="fas fa-certificate"></i> <?php esc_html_e( 'Subscriptions', 'datebook' ); ?></a></li>

		<?php } ?>
				
		

	</div>
	<div class="card-footer">

		<?php

		$login_url = add_query_arg( array(
			'action' => 'logout'
		), get_permalink(of_get_option('login_page')) );

		?>

		<a href="<?php echo esc_url($login_url); ?>"><i class="fas fa-minus-circle"></i> <?php esc_html_e( 'Logout', 'datebook' ); ?></a>

	</div>
</div>
	
<?php } ?>