<?php
/**
 * Logo and menu template
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$logo_url = home_url();

if (get_theme_mod( 'datebook_advanced_control', 2) == 2 && get_theme_mod( 'datebook_logo' ) != '') {

	echo '<a class="navbar-brand datebook-logo datebook-logo-block text-center" href="' . esc_url($logo_url) . '" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '"><img src="' . esc_url(get_theme_mod( 'datebook_logo' )) . '" alt="' . esc_attr(get_bloginfo('name')) . '" /></a>';

} else if (get_theme_mod( 'datebook_advanced_control', 1) == 1) {
	
	$logo_insidemenu_exists = isset($logo_insidemenu_exists) && $logo_insidemenu_exists == 1 ? '' : ' mr-0';

	if ($is_front_page == 1 && of_get_option( 'website_logo_front' )) {

		echo '<a class="navbar-brand' . $logo_insidemenu_exists . ' datebook-logo datebook-logo-block text-center" href="' . esc_url($logo_url) . '" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '"><img src="' . esc_url(of_get_option( 'website_logo_front' )) . '" alt="' . esc_attr(get_bloginfo('name')) . '" />';

		DateBook_Menu::quantity_registered_users();

		echo '</a>';
		
	} else if ($is_front_page == 0 && of_get_option( 'website_logo_other' )) {

		echo '<a class="navbar-brand' . $logo_insidemenu_exists . ' datebook-logo datebook-logo-block text-center" href="' . esc_url($logo_url) . '" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '"><img src="' . esc_url(of_get_option( 'website_logo_other' )) . '" alt="' . esc_attr(get_bloginfo('name')) . '" /></a>';

	} else {

		echo '<a class="navbar-brand mr-0 datebook-logo datebook-logo-block text-center" href="' . esc_url($logo_url) . '" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '"><img src="' . esc_url(DATEBOOK_URL . 'assets/images/logo.png') . '" alt="' . esc_attr(get_bloginfo('name')) . '" /></a>';

	}

} else {

	echo '<h1 class="navbar-brand mb-0 h1"><a class="datebook-logo datebook-logo-block text-center" href="' . esc_url($logo_url) . '" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '">' . esc_attr(get_bloginfo('name')) . '</a></h1>';

}