<?php
/**
 * Create pages for Search, Classifieds, Tours, Contact
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);

if ($page_id == of_get_option('search_results_page')) {

	if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' . $datebook_wplang ) ? 1 : 0;
	} else {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' ) ? 1 : 0;
	}
	
} else if ($page_id == of_get_option('all_classifieds_page')) {
	
	if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-classifieds' . $datebook_wplang ) ? 1 : 0;
	} else {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-classifieds' ) ? 1 : 0;
	}

} else if ($page_id == of_get_option('all_tours_page')) {
	
	if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-tours' . $datebook_wplang ) ? 1 : 0;
	} else {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-tours' ) ? 1 : 0;
	}

} else {

	if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' . $datebook_wplang ) ? 1 : 0;
	} else {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' ) ? 1 : 0;
	}

}

?>

<!-- content -->
<div class="row datebook-padding-less">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-xl-9 col-lg-9 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-3 tooltip-demo">

			<?php

			if ($page_id == of_get_option('terms_page')) {

			}

			if ($page_id == of_get_option('search_results_page')) {
				do_action('datebook_search_page');
			}
			
			if ($page_id == of_get_option('all_classifieds_page')) {
				do_action('datebook_show_classifieds');
			}

			if ($page_id == of_get_option('all_tours_page')) {
				do_action('datebook_show_tours');
			}

			if ($page_id == of_get_option('contact_page')) {
				do_action('datebook_contact_form');
			}
			

			?>


		</div>
	</div>
	
	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>
	
	<div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php 

			if ($page_id == of_get_option('search_results_page')) {
				if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
					dynamic_sidebar('datebook-search' . $datebook_wplang);
				} else {
					dynamic_sidebar('datebook-search');
				}
			} else if ($page_id == of_get_option('all_classifieds_page')) {
				if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
					dynamic_sidebar('datebook-classifieds' . $datebook_wplang);
				} else {
					dynamic_sidebar('datebook-classifieds');
				}
			} else if ($page_id == of_get_option('all_tours_page')) {
				if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
					dynamic_sidebar('datebook-tours' . $datebook_wplang);
				} else {
					dynamic_sidebar('datebook-tours');
				}
			} else {
				if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
					dynamic_sidebar('datebook-page' . $datebook_wplang);
				} else {
					dynamic_sidebar('datebook-page');
				}
			}

			?>

		</div>
	</div>
	
	<?php endif; ?>
	
</div>
<!-- /content -->