<?php
/**
 * Create pages for Profile
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if (is_user_logged_in()) {
		
	$page_id = get_the_ID();

?>

<div class="row datebook-padding-less">
	<div class="col-lg-9 col-md-9 col-sm-12 datebook-registerpage datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-3">

			<?php

			if ($page_id == of_get_option('my_messages_page') || $page_id == of_get_option('my_favorites_page') || (of_get_option('enable_blacklisted_profiles') == '1' && $page_id == of_get_option('my_blacklist_page'))) {

				do_action('datebook_profile_messages');

			} else if ($page_id == of_get_option('my_edit_profile_page')) {

				do_action('datebook_edit_profile');

			} else if ($page_id == of_get_option('my_photos_page')) {

				do_action('datebook_edit_photos');

			} else if ($page_id == of_get_option('my_verification_page')) {
				
				if (of_get_option('enable_verification') == '1') {
					do_action('datebook_edit_verification');
				}

			} else if ($page_id == of_get_option('my_friends_page')) {
				
				if (of_get_option('enable_friendship') == '1') {
					do_action('datebook_friends_settings');
				}

			} else if ($page_id == of_get_option('my_comments_page')) {
				
				if (of_get_option('enable_profile_comments') == '1') {
					do_action('datebook_profile_comments');
				}

			} else if ($page_id == of_get_option('my_classifieds_page')) {
				
				if (of_get_option('enable_classifieds') == '1') {
					do_action('datebook_edit_classifieds');
				}

			} else if ($page_id == of_get_option('my_tours_page')) {
				
				if (of_get_option('enable_profile_tours') == '1') {
					do_action('datebook_edit_tour');
				}

			} else if ($page_id == of_get_option('my_views_page')) {

				do_action('datebook_profile_views');

			} else if ($page_id == of_get_option('my_settings_page')) {

				do_action('datebook_profile_settings');

			} else if ($page_id == of_get_option('my_privacy_page')) {

				do_action('datebook_profile_privacy');

			} else if ($page_id == of_get_option('my_upgrade_page')) {

				if (DateBook_Utilities::check_if_gateway_activated()) {

					do_action('datebook_profile_subscription_page');

				}

			} else if ($page_id == of_get_option('my_cart_page')) {

				if (DateBook_Utilities::check_if_gateway_activated()) {

					do_action('datebook_profile_cart_page');

				}

			} else if ($page_id == of_get_option('my_checkout_page')) {

				if (DateBook_Utilities::check_if_gateway_activated()) {

					do_action('datebook_profile_checkout_page');

				}

			} else if ($page_id == of_get_option('my_notification_page')) {

				do_action('datebook_profile_notifications');

			} else {
				
				$border_width = 0;
				
				switch($border_width) {
					case 0 : $border_width_out = ' border-0'; break;
					case 1 : $border_width_out = ' border'; break;
					case 2 : $border_width_out = ' border-1'; break;
					default: $border_width_out = ''; break;
				}

				$border_width_out = ' border-width: ' . absint($border_width) . 'px !important;';
				
				$shadow = 0;
				
				switch($shadow) {
					case 0 : $shadow_out = ' shadow-none'; break;
					case 1 : $shadow_out = ' shadow-sm'; break;
					case 2 : $shadow_out = ' shadow'; break;
					case 3 : $shadow_out = ' shadow-lg'; break;
					default: $shadow_out = ''; break;
				}
				
				echo '<div class="card ' . $border_width_out . '' . $shadow . '" style="' . $border_width_out . '">';
				echo '<div class="card-body">';
				echo '<h2>' . esc_html__( 'The internal account page', 'datebook' ) . ':</h2>';
				
				$page_array = array(
					'messages' => esc_html__( 'Messages', 'datebook' ),
					'edit_profile' => esc_html__( 'Edit profile', 'datebook' ),
					'photos' => esc_html__( 'Photos', 'datebook' ),
					'verification' => esc_html__( 'Verification', 'datebook' ),
					'friends' => esc_html__( 'Friends', 'datebook' ),
					'favorites' => esc_html__( 'Favorites', 'datebook' ),
					'blacklist' => esc_html__( 'Blacklist', 'datebook' ),
					'comments' => esc_html__( 'Comments', 'datebook' ),
					'classifieds' => esc_html__( 'Classifieds', 'datebook' ),
					'tours' => esc_html__( 'Tours', 'datebook' ),
					'who_viewed_me' => esc_html__( 'Who viewed me', 'datebook' ),
					'settings' => esc_html__( 'Settings', 'datebook' ),
					'privacy' => esc_html__( 'Privacy', 'datebook' ),
					'subscriptions' => esc_html__( 'Subscriptions', 'datebook' ),
					'cart' => esc_html__( 'Cart', 'datebook' ),
					'checkout' => esc_html__( 'Checkout', 'datebook' ),
					'notifications' => esc_html__( 'Notifications', 'datebook' )
				);

				foreach ( $page_array as $key => $value ) {
					
					if($inside_page == $key){
						
						echo '<h4>&#8212; ' . esc_attr($value) . '</h4>';
						
					}

				}

				echo '</div>';
				echo '</div>';

			}


			?>

		</div>
	</div>

	<div class="col-lg-3 col-md-3 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">

		<?php do_action('datebook_sidebar_edit'); ?>

	</div>
</div>
<!-- /content -->

<?php

}