<?php
/**
 * Create pages for Profile
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar('datebook-single-profile' . $datebook_wplang) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar('datebook-single-profile') ? 1 : 0;
}

?>

<!-- content -->
<div class="row datebook-padding-less">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-5">

			<?php
			
			if ( have_posts() ) :

				while ( have_posts() ) : the_post();

					do_action('datebook_single_profile_inside');

				endwhile;

			else :

				get_template_part( 'templates/content', 'none' );

			endif;

			do_action('datebook_related_profiles_bycountry');

			?>

		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php

			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-single-profile' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-single-profile');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->