<?php
/**
 * Top menu
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


if (has_nav_menu('datebook-top-menu-left-' . DATEBOOK_WPLANG) || has_nav_menu('datebook-top-menu-right-' . DATEBOOK_WPLANG)){

?>

<div class="datebook-top-menu">

	<nav class="navbar navbar-expand-lg navbar-dark shadow-none pt-1 pb-1">

		<div class="container">

			<button class="navbar-toggler m-auto" type="button" data-toggle="collapse" data-target="#navbarTopContent" aria-controls="navbarTopContent" aria-expanded="false" aria-label="<?php esc_html_e( 'Menu', 'datebook' ); ?>"><span class="navbar-toggler-icon"></span></button>

			<div class="collapse navbar-collapse" id="navbarTopContent">

			<?php

			if (($is_front_page == 1 && of_get_option( 'top_menu_align_front' ) == 'leftright') || ($is_front_page == 0 && of_get_option( 'top_menu_align_other' ) == 'leftright')) {
				$top_menu_align_left = 'mr-auto';
				$top_menu_align_right = 'ml-auto';
			} else if (($is_front_page == 1 && of_get_option( 'top_menu_align_front' ) == 'centeronside') || ($is_front_page == 0 && of_get_option( 'top_menu_align_other' ) == 'centeronside')) {
				$top_menu_align_left = 'm-auto';
				$top_menu_align_right = 'm-auto';
			} else if (($is_front_page == 1 && of_get_option( 'top_menu_align_front' ) == 'center') || ($is_front_page == 0 && of_get_option( 'top_menu_align_other' ) == 'center')) {
				$top_menu_align_left = 'ml-auto';
				$top_menu_align_right = 'mr-auto';
			} else {
				$top_menu_align_left = 'mr-auto';
				$top_menu_align_right = 'ml-auto';
			}

			wp_nav_menu(array(
				'theme_location'  => 'datebook-top-menu-left-' . DATEBOOK_WPLANG,
				'container'       => 'div',
				'container_id'    => 'datebook-top-menu-left-' . DATEBOOK_WPLANG,
				'container_class' => $top_menu_align_left,
				'menu_id'         => false,
				'menu_class'      => 'navbar-nav datebook-top-menu-left',
				'depth'           => 2,
				'fallback_cb'     => 'bs4navwalker::fallback',
				'walker'          => new bs4navwalker()
			));


			wp_nav_menu(array(
				'theme_location' => 'datebook-top-menu-right-' . DATEBOOK_WPLANG,
				'container'       => 'div',
				'container_id'    => 'datebook-top-menu-right-' . DATEBOOK_WPLANG,
				'container_class' => $top_menu_align_right,
				'menu_id'         => false,
				'menu_class'      => 'navbar-nav datebook-top-menu-right',
				'depth'           => 2,
				'fallback_cb'     => 'bs4navwalker::fallback',
				'walker'          => new bs4navwalker()
			));

			?>

			</div>
		</div>
	</nav>
</div>

<?php }