<?php
/*
 * Profile Upgrade buttons. Used on Upgrade page.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


if(isset($datebook_get_data['profile_subscription'])){

	// Check if Payment and Subscription are activated
	if (DateBook_Utilities::check_if_gateway_activated()) {

		$plans_count = 0;

		if (is_array($get_subscription_plans)){

			foreach($get_subscription_plans as $key => $value){

				if (isset($value['active']) && $value['active'] == 1) {

					$plans_count++;

				}
			}
		}


		if ($plans_count > 0){

			$member_subscriptions = datebook_get_member_subscriptions( array( 'user_id' => $current_user_id ) );

			$member_subscription_status = isset($member_subscriptions[0]->status) && ($member_subscriptions[0]->status == 'active' || $member_subscriptions[0]->status == 'completed') ? 1 : 0;

			if ($member_subscription_status == 0){

				// if profile is private and needs to receive payment first
				if (get_post_status(get_user_meta( $current_user_id, 'profile_postid', true )) == 'private') {

					echo '<div class="alert alert-warning alert-dismissable">';
					echo '<h4 class="alert-heading">' . esc_html__( 'Select a subscription plan', 'datebook' ) . '!</h4>';
					echo '<p class="mb-0">'. esc_html__( 'You must select a subcription plan before your profile gets activated', 'datebook' ).'</p>';
					echo '</div>';

				}

			}
		}
	}
}