<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

if(isset($subscription_temp_cart) && !empty($subscription_temp_cart)) {

	$subscriptionplan_period_ends_title = isset($subscription_temp_cart['subscription_period_ends']) && $subscription_temp_cart['subscription_period_ends'] > 0 ? $subscription_temp_cart['subscriptionplan_period_title'] : esc_html__( 'Unlimited', 'datebook' );

}
?>

<div class="datebook-custom-card card tooltip-demo">
	<div class="card-body">

		<h2><?php esc_html_e( 'Subscription panel', 'datebook' ); ?></h2>

		<?php

		// Display Subscription navigation menu
		do_action( 'datebook_profile_subscription_navigation' );
		
		if(isset($subscription_temp_cart) && !empty($subscription_temp_cart)) {

		?>

		<p><?php esc_html_e( 'Subscription plan', 'datebook' ); ?>: <?php echo esc_attr($subscription_temp_cart['subscriptionplan_title']); ?></p>

		<p><?php esc_html_e( 'Price', 'datebook' ); ?>: <?php echo esc_attr($subscription_temp_cart['subscription_price_title']); ?></p>

		<p><?php esc_html_e( 'Period', 'datebook' ); ?>: <?php echo esc_attr($subscriptionplan_period_ends_title); ?></p>


		<div class="card border-0 datebook-transparent">

			<div class="card-body">

				<form method="post" action="<?php echo esc_url(get_permalink(of_get_option('my_upgrade_page'))); ?>" target="_top">
					<input type="hidden" name="action" value="payment_page">
					<input type="hidden" name="payment_page" value="2">
					<input type="hidden" name="subscriptionplan" value="<?php echo esc_attr($subscription_temp_cart['subscription_id']); ?>">
                    <input type="hidden" name="subscriptionplan_price" value="<?php echo esc_attr($subscription_temp_cart['subscriptionplan_period_key']); ?>">
                    
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo esc_html__( 'Proceed to checkout', 'datebook' ); ?></button>

				</form>            

			</div>

		</div>
        
        <?php } else { ?>
        
			<div class="card border-0 datebook-transparent">
            
            	<p><?php echo esc_html__( 'Your cart is empty', 'datebook' ); ?></p>

			</div>
        
        <?php } ?>
        
        
	</div>
</div>