<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

if(isset($_POST['subscriptionplan'])) {

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

	$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
	$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();
	
	$item_type = 'subscription';

	$get_subscriptionplan = (isset($_POST['subscriptionplan']) && strlen($_POST['subscriptionplan']) > 1) ? $_POST['subscriptionplan'] : (isset($datebook_get_data['subscriptionplan']) && $datebook_get_data['subscriptionplan'] > 0 ? $datebook_get_data['subscriptionplan'] : '');

	$get_subscriptionplan_price = isset($_POST['subscriptionplan_price']) ? $_POST['subscriptionplan_price'] : (isset($datebook_get_data['subscriptionplan_price']) ? $datebook_get_data['subscriptionplan_price'] : '');

	$all_splans = get_option('datebook_subscription_plans');

	$subscription_id = $all_splans[$get_subscriptionplan]['subscription_id'];

	$subscription_period_number_key = $all_splans[$get_subscriptionplan]['register_period_number'][$get_subscriptionplan_price];

	$subscription_period_key = $all_splans[$get_subscriptionplan]['register_period'][$get_subscriptionplan_price];
	
	$subscription_period_title = DateBook_Utilities::datebook_plural_text($subscription_period_number_key, $subscription_period_key);

	$subscription_price_title = isset($all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price]) && $all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price] > 0 ? DateBook_Profile_Subscription::datebook_format_money($all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price]) : esc_html__( 'Free', 'datebook' );
	
	$subscription_price = isset($all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price]) && $all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price] > 0 ? $all_splans[$get_subscriptionplan]['price'][$get_subscriptionplan_price] : 0;
	
	$subscriptionplan_recurring = isset($all_splans[$get_subscriptionplan]['recurring']) && $all_splans[$get_subscriptionplan]['recurring'] > 0 ? $all_splans[$get_subscriptionplan]['recurring'] : 0;

	$subscription_period_out = $subscription_period_number_key > 0 ? $subscription_period_title : esc_html__( 'Unlimited', 'datebook' );
	
	// Detect if a subscription plan is free for selected genders
	$get_subscriptionplan_free_for_genders = 0;
	if(isset($_POST['free_for_gender']) && $_POST['free_for_gender'] == 1) {
		$gender = get_post_meta($profile_id, "gender", true);
		if(isset($all_splans[$get_subscriptionplan]['free_for_gender'][$gender])){
			$get_subscriptionplan_free_for_genders = 1;
		}
	}


	$subscription_arg = array(
		'subscription_id' => $subscription_id,
		'subscription_type' => $item_type,
		'subscriptionplan' => $get_subscriptionplan,
		'subscriptionplan_title' => $all_splans[$get_subscriptionplan]['name_' . DATEBOOK_WPLANG],
		'subscription_price_title' => $subscription_price_title,
		'subscriptionplan_price' => $subscription_price,
		'subscriptionplan_period_number' => $subscription_period_number_key,
		'subscriptionplan_period' => $subscription_period_key,
		'subscriptionplan_period_title' => $subscription_period_title,
		'subscriptionplan_recurring' => $subscriptionplan_recurring,
		'subscriptionplan_period_key' => $get_subscriptionplan_price,
		'subscriptionplan_free_for_genders' => $get_subscriptionplan_free_for_genders,
	);
	
?>

<div class="datebook-custom-card card tooltip-demo">
	<div class="card-body">

		<h2><?php esc_html_e( 'Subscription panel', 'datebook' ); ?></h2>
		
		<?php
            
		// Display Subscription plans and WooCommerce Subscription plans as well if available
		do_action( 'datebook_profile_subscription_navigation' );

		?>
		
		<?php if (isset($all_splans[$get_subscriptionplan]['name_' . DATEBOOK_WPLANG]) && !empty($all_splans[$get_subscriptionplan]['name_' . DATEBOOK_WPLANG])) { ?>

			<p><?php esc_html_e( 'Subscription plan', 'datebook' ); ?>: <?php echo esc_attr($all_splans[$get_subscriptionplan]['name_' . DATEBOOK_WPLANG]); ?></p>

			<p><?php esc_html_e( 'Price', 'datebook' ); ?>: <?php echo esc_attr($subscription_price_title); ?></p>

			<p><?php esc_html_e( 'Period', 'datebook' ); ?>: <?php echo esc_attr($subscription_period_out); ?></p>

		<?php } ?>

		<div class="card border datebook-transparent">

			<div class="card-header">

				<?php esc_html_e( 'Select payment method', 'datebook' ); ?>

			</div>

			<div class="card-body">

				<?php echo DateBook_Profile_Subscription::profile_payment_checkout_form($item_type, $current_user_id, $profile_id, $subscription_arg); ?>

			</div>

		</div>
	</div>
</div>

<?php 

}