<?php
/*
 * Alert box if user did not select a subscription plan yet
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$class = isset($class) ? $class : '';

?>

<div class="datebook-custom-card card <?php echo esc_attr($class); ?>">
	<div class="alert alert-warning alert-dismissable m-0 datebook-must-select-subscription">

		<h4 class="alert-heading"><?php esc_html_e( 'Select a subscription plan!', 'datebook' ); ?></h4>
		
		<p class="mb-0"><?php esc_html_e( 'In order to use all the features, you must select a subscription plan.', 'datebook' ); ?><?php if(get_the_ID() != of_get_option('my_upgrade_page')){ ?> <a class="btn btn-secondary btn-sm" href="<?php echo get_permalink(of_get_option('my_upgrade_page')); ?>"><?php echo esc_html__( 'Go to Subscription panel', 'datebook' ); ?></a><?php } ?></p>

	</div>
</div>