<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $paid_features_subscriptions, $time_in_seconds_array;

$count_plans = 0;

// Get Subscription plans
$get_subscription_plans = get_option('datebook_subscription_plans');

if (is_array($get_subscription_plans)){
	
	$gateway_options = get_option('datebook_gateways');
				
	// Get profile data and check if it has subscription plan
	$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
	$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

	if (isset($datebook_get_data) && is_array($datebook_get_data) && !empty($datebook_get_data)) {

	$gender = get_post_meta($profile_id, 'gender', true);

	$active_woocommerce_subscription = of_get_option('activate_woocommerce_subscription') == '2' && function_exists( 'WC' ) ? 1 : 0;

	$notactive = get_post_meta($profile_id, 'notactive', true) == 1 ? 1 : 0;
	
	$status_active = $status == 'active' || ($active_woocommerce_subscription == 1 && $status == 'completed') ? 1 : 0;

	if ($status_active == 0) { ?>

		<div class="alert alert-warning"><?php echo esc_html__( 'You must select a subscription plan', 'datebook' ); ?></div>

	<?php } ?>


<ul class="list-group list-group-flush datebook-subscription-start">

<?php

foreach($get_subscription_plans as $key => $value){

	if (isset($value['active']) && $value['active'] == 1) {

		$count_plans++;

		$value['subscription_id'] = isset($value['subscription_id']) ? $value['subscription_id'] : '';

		if (isset($value['activate_by_default']) && $value['activate_by_default'] == 1) {

			// Hide this subsctiption plan if hide by default
			if (isset($value['hide_by_default']) && $value['hide_by_default'] == 1 && isset($datebook_get_data['profile_subscription']['activate_plan_by_default']) && $datebook_get_data['profile_subscription']['activate_plan_by_default'] == $value['subscription_id'] && $datebook_get_data['profile_subscription']['hide_plan_by_default'] == $value['subscription_id']) {

				continue;

			}

			// Hide this subsctiption plan after expriration
			if (isset($value['hide_after_expire']) && $value['hide_after_expire'] == 1 && isset($datebook_get_data['profile_subscription']['hide_plan_after_expire']) && $datebook_get_data['profile_subscription']['hide_plan_after_expire'] == $value['subscription_id']) {
				if (!isset($expiration_date) || empty($expiration_date) || (isset($expiration_date) && !empty($expiration_date) && strtotime($expiration_date) < time())) {

					continue;

				}
			}
		}


		$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];
		$value['plan_description'] = isset($value['plan_description_' . DATEBOOK_WPLANG]) ? $value['plan_description_' . DATEBOOK_WPLANG] : $value['plan_description_en_US'];

		$free_for_gender = isset($value['free_for_gender']) && is_array($value['free_for_gender']) && !empty($value['free_for_gender']) && array_key_exists($gender, $value['free_for_gender']) ? 1 : 0;

?>

<li class="list-group-item datebook-transparent datebook-padding-less">

	<div class="row">

		<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">
			<h4 class="d-inline-block"><?php echo esc_attr($value['name']); ?></h4>

			<?php

			// If profile has some subscription plan then show Active sign
			if ($subscription_plan_id == $value['subscription_id']) {

				if(isset($start_date) && strtotime($start_date) <= time()){

					if ($status_active == 1) {

						echo '<span class="badge badge-success shadow-none">' . esc_html__( 'Active', 'datebook' ) . '</span>';

					} else if ($status == 'pending' || ($active_woocommerce_subscription == 1 && $status == 'pending')) {

						echo '<span class="badge badge-warning shadow-none">' . esc_html__( 'Pending', 'datebook' ) . '</span>';

					} else if ($status == 'canceled' || ($active_woocommerce_subscription == 1 && $status == 'canceled')) {

						echo '<span class="badge badge-danger shadow-none">' . esc_html__( 'Canceled', 'datebook' ) . '</span>';

					} else if ($status == 'expired' || ($active_woocommerce_subscription == 1 && $status == 'expired')) {

						echo '<span class="badge badge-dark shadow-none">' . esc_html__( 'Expired', 'datebook' ) . '</span>';

					} 

					if ($status_active == 1 || $status == 'pending' || $status == 'canceled' || $status == 'expired' || ($active_woocommerce_subscription == 1 && ($status_active == 1 || $status == 'pending' || $status == 'canceled' || $status == 'expired'))) {

						$profile_subscription_ends = '';

						if (of_get_option('activate_woocommerce_subscription') == '2' && function_exists( 'WC' ) ) {

							if(isset($value['wc_subscription_product']) && isset($all_subscription_plans[$value['wc_subscription_product']])){

								$profile_subscription_ends = (empty($expiration_date) || $expiration_date == '0000-00-00 00:00:00') ? esc_html__( 'for', 'datebook' ) . ' ' . esc_html__( 'unlimited period', 'datebook' ) : esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(2, $expiration_date);

							}

						} else {

							$profile_subscription_ends = isset($expiration_date) && strtotime($expiration_date) > 0 ? esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(2, $expiration_date, true) : esc_html__( 'for', 'datebook' ) . ' ' . esc_html__( 'unlimited period', 'datebook' );
							
						}

						echo ' <small>' . esc_attr($profile_subscription_ends) . '</small>';

					}

				} else {
					
					echo '<span>' . esc_html__( 'will be', 'datebook' ) . '</span> ';

					if ($status_active == 1) {

						echo '<span class="badge badge-success">' . esc_html__( 'Active', 'datebook' ) . '</span>';

					} else if ($status == 'pending' || ($active_woocommerce_subscription == 1 && $status == 'pending')) {

						echo '<span class="badge badge-warning">' . esc_html__( 'Pending', 'datebook' ) . '</span>';

					} else if ($status == 'canceled' || ($active_woocommerce_subscription == 1 && $status == 'canceled')) {

						echo '<span class="badge badge-danger">' . esc_html__( 'Canceled', 'datebook' ) . '</span>';

					} else if ($status == 'expired' || ($active_woocommerce_subscription == 1 && $status == 'expired')) {

						echo '<span class="badge badge-dark">' . esc_html__( 'Expired', 'datebook' ) . '</span>';

					} 

					if ($status_active == 1 || $status == 'pending' || $status == 'canceled' || $status == 'expired' || ($active_woocommerce_subscription == 1 && ($status_active == 1 || $status == 'pending' || $status == 'canceled' || $status == 'expired'))) {

						if (of_get_option('activate_woocommerce_subscription') == '2' && function_exists( 'WC' ) ) {

							if(isset($value['wc_subscription_product']) && isset($all_subscription_plans[$value['wc_subscription_product']])){

								$profile_subscription_ends = (empty($expiration_date) || $expiration_date == '0000-00-00 00:00:00') ? esc_html__( 'for', 'datebook' ) . ' ' . esc_html__( 'unlimited period', 'datebook' ) : esc_html__( 'from', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(1, $start_date) . ' ' . esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(2, $expiration_date);

							}

						} else {

							$profile_subscription_ends = isset($expiration_date) && strtotime($expiration_date) > 0 ? esc_html__( 'from', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(1, $start_date) . ' ' . esc_html__( 'till', 'datebook' ) . ' ' . DateBook_Utilities::datebook_date_i18n(1, $expiration_date) : esc_html__( 'for', 'datebook' ) . ' ' . esc_html__( 'unlimited period', 'datebook' );
							
						}

						echo ' <span>' . esc_attr($profile_subscription_ends) . '</span>';

					}
				}

			}

			?>

		</div>

		<div class="col-lg-6 col-md-6 col-sm-12 datebook-padding-less">

			<p class="card-text"><?php echo esc_attr($value['plan_description']); ?></p>

			<p class="card-text mb-3">

			<?php
			
			// Add point by myCred
			if (of_get_option('points_system') == 1 && class_exists('myCRED_Core')) {

				$pointsquantity = isset($value['pointsquantity']) ? $value['pointsquantity'] : 0;

				if($pointsquantity > 0){

					echo '&#8212; ' . esc_attr($pointsquantity) . ' ' . esc_html__( 'points added to account', 'datebook' ) . '<br />';

				}
			}

			if ($paid_features_subscriptions) {
				
				foreach ($paid_features_subscriptions as $feature_key => $feature_title) {

					if (isset($value[$feature_key]) && $value[$feature_key] == 1) {
						
						echo '&#8212; ' . esc_html__( $feature_title, 'datebook' );
							
						if (isset($feature_key) && $feature_key == 'top_position' && isset($value['times_top_position']) && $value['times_top_position'] > 0) {

							echo ' <span class="badge badge-light shadow-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__( 'Number of times you can move your profile to Top position', 'datebook' ) . '">' . esc_html__( 'times', 'datebook' ) . ': ' . ' ' . $value['times_top_position'] . '</span>';

						} else if (isset($feature_key) && $feature_key == 'featured_position' && isset($value['times_featured_position']) && $value['times_featured_position'] > 0) {

							echo ' <span class="badge badge-light shadow-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__( 'Number of times you can place your profile in Featured position', 'datebook' ) . '">' . esc_html__( 'times', 'datebook' ) . ': ' . ' ' . $value['times_featured_position'] . '</span>';

						} else if (isset($feature_key) && $feature_key == 'simultaneous_chatters') {

							if (isset($value['quantity_simultaneous_chatters']) && $value['quantity_simultaneous_chatters'] > 0){
								echo ' ' . esc_html__( 'to', 'datebook' ) . ' ';

								echo ' ' . $value['quantity_simultaneous_chatters'];

								echo ' ' . esc_html__( 'users', 'datebook' ) . ' ';

								echo ' ' . esc_html__( 'per', 'datebook' ) . ' ';

								$period_number_simultaneous_chatters = isset($value['period_number_simultaneous_chatters']) ? $value['period_number_simultaneous_chatters'] : 0;
								$period_simultaneous_chatters = isset($value['period_simultaneous_chatters']) ? $value['period_simultaneous_chatters'] : 0;

								echo esc_attr(DateBook_Utilities::datebook_plural_text($period_number_simultaneous_chatters, $period_simultaneous_chatters));

							} else {

								echo ' ' . esc_html__( 'as many as you want', 'datebook' ) . ' ';

							}

						} else if (isset($feature_key) && $feature_key == 'upload_images') {

							if (isset($value['subscription_limitphotos']) && $value['subscription_limitphotos'] > 0){

								echo ' <span class="badge badge-light shadow-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . $value['subscription_limitphotos'] . ' ' . esc_html__( 'photos can be uploaded', 'datebook' ) . '">' . esc_html__( 'quantity', 'datebook' ) . ': ' . $value['subscription_limitphotos'] . '</span>';

							} else {

								echo ' ' . esc_html__( 'Unlimited pictures', 'datebook' );

							}
						}

						echo '<br />';

					}
				}
			}

			?>
			
			</p>

		</div>

		<div class="col-lg-6 col-md-6 col-sm-12 datebook-padding-less">

			<?php
			
			// If profile has some subscription plan then show Active sign
			if ($subscription_plan_id == $value['subscription_id']) {

				$topad_active = get_post_meta($profile_id, 'topad', true) == 1 ? 1 : 0;

				$featured_active = get_post_meta($profile_id, 'featured', true) == 1 ? 1 : 0;

				if ((isset($value['top_position']) && $value['top_position'] == 1) || (isset($value['featured_position']) && $value['featured_position'] == 1)) {

					echo '<div class="card card-body border mb-2">';

					if (isset($value['top_position']) && $value['top_position'] == 1){

						$top_times_total = isset($datebook_get_data['profile_subscription']['top_times_total']) && $datebook_get_data['profile_subscription']['top_times_total'] > 0 ? $datebook_get_data['profile_subscription']['top_times_total'] : 0;
						$top_times_left = isset($datebook_get_data['profile_subscription']['top_times_left']) && $datebook_get_data['profile_subscription']['top_times_left'] > 0 ? $datebook_get_data['profile_subscription']['top_times_left'] : 0;

						$period_number_top_position = isset($value['period_number_top_position']) && $value['period_number_top_position'] > 0 ? $value['period_number_top_position'] : 0;
						$period_top_position = isset($value['period_top_position']) && $value['period_top_position'] > 0 ? $value['period_top_position'] : 0;
						$period_top_starts = isset($datebook_get_data['profile_subscription']['topad_starts']) && $datebook_get_data['profile_subscription']['topad_starts'] > 0 ? $datebook_get_data['profile_subscription']['topad_starts'] : 0;

						$top_position_after_period = $period_top_starts + ($period_number_top_position * $time_in_seconds_array[$period_top_position]);

						echo '<p class="card-text m-0 mb-2 p-0 datebook-period-panel">';

						// Show user's topad expiration
						if ($topad_active == 1) {

							$topad_ends = get_post_meta($profile_id, 'topad_ends', true);

							$topad_ends_time = isset($topad_ends) && $topad_ends > 0 ? DateBook_Utilities::datebook_date_i18n(2, $topad_ends, false) : esc_html__( 'unlimited period', 'datebook' );
							$topad_ends_time_hours = isset($topad_ends) && $topad_ends > 0 ? DateBook_Utilities::datebook_date_i18n(2, $topad_ends, false) : esc_html__( 'unlimited period', 'datebook' );

							echo ' <span class="badge badge-success shadow-none" data-toggle="tooltip" data-placement="top" title="' . esc_html__( 'Top status is active until', 'datebook' ) . ': ' . $topad_ends_time_hours . '" data-original-title="' . esc_html__( 'Top status is active until', 'datebook' ) . ': ' . $topad_ends_time_hours . '">' . esc_html__( 'Top', 'datebook' ) . '</span> ';
							echo ' <small>';
							echo esc_html__( 'till', 'datebook' ) . ': ' . esc_attr($topad_ends_time);
							echo '</small>';

							if($top_times_total > 0 && $top_times_left > 0 && ($top_times_left == $top_times_total || ($top_times_left <= $top_times_total && $top_position_after_period <= time()))){

								echo '<a href="javascript:void(0)" id="datebook-top-' . absint($profile_id) . '" class="btn btn-sm btn-success m-0 float-right datebook-activate-topfeatured" data-toggle="tooltip" data-placement="top" title="' . esc_html__( 'You can move your profile to Top position', 'datebook' ) . ': ' . esc_attr($top_times_left) . ' ' . esc_html__( 'times', 'datebook' ) . '" data-original-title="' . esc_html__( 'You can move your profile to Top position', 'datebook' ) . ': ' . esc_attr($top_times_left) . ' ' . esc_html__( 'times', 'datebook' ) . '">' . esc_html__( 'Activate', 'datebook' ) . '</a>';

							} else {

								echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Activated', 'datebook' ) . '</a>';

							}

						} else {

							echo ' <span class="badge badge-info shadow-none" title="' . esc_html__( 'Top status is not active', 'datebook' ) . '">' . esc_html__( 'Top', 'datebook' ) . '</span> ';
							echo ' <span class="small datebook-period-ends">';
							echo esc_html__( 'not active', 'datebook' );
							echo '</span>';

							if($top_times_total > 0 && $top_times_left > 0){

								if($top_times_left == $top_times_total || ($top_times_left <= $top_times_total && $top_position_after_period <= time())){

									echo '<a href="javascript:void(0)"  id="datebook-top-' . absint($profile_id) . '" class="btn btn-sm btn-success m-0 float-right datebook-activate-topfeatured">' . esc_html__( 'Activate', 'datebook' ) . '</a>';

								} else {

									echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Disabled', 'datebook' ) . '</a>';

								}

							} else {

								echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Disabled', 'datebook' ) . '</a>';

							}
						}

						echo '<br>';

						echo '<span class="small">' . esc_html__( 'Total', 'datebook' ) . ' <span class="datebook-top-total">' . $top_times_total . '</span>; ' . esc_html__( 'Left', 'datebook' ) . ': <span class="datebook-top-left">' . $top_times_left . '</span></span>';

						if($top_times_total > 0 && $top_times_left > 0 && $top_times_left <= $top_times_total){

							$top_position_after_period_left = $top_position_after_period - time();

							$days = floor($top_position_after_period_left / 86400);
							$top_position_after_period_left %= 86400;
							$hours = floor($top_position_after_period_left / 3600);
							$top_position_after_period_left %= 3600;
							$minutes = floor($top_position_after_period_left / 60);
							$top_position_after_period_left %= 60;

							$top_period_title = '';

							if($days > 0 || $hours > 0 || $minutes > 0){
								$top_period_title .= esc_html__( 'in', 'datebook' ) . ' ';
							} else {
								$top_period_title .= esc_html__( 'now', 'datebook' ) . ' ';
							}

							if($days > 0){
								$top_period_title .= $days . ' ' . esc_html__( 'days', 'datebook' ) . ' ';
							}
							if($hours > 0){
								$top_period_title .= $hours . ' ' . esc_html__( 'hours', 'datebook' ) . ' ';
							}
							if($minutes > 0){
								$top_period_title .= $minutes . ' ' . esc_html__( 'minutes', 'datebook' );
							}

							echo '<br><span class="small">' . esc_html__( 'You may activate it again', 'datebook' ) . ' <span class="datebook-top-period-left">' . esc_html($top_period_title) . '</span></span>';

						} else {

							echo '<br><span class="small">' . esc_html__( 'You have reached the limit and may not activate it again', 'datebook' ) . '</span>';

						}

						echo '</p>';

					}


					// Show user's featured expiration
					if (isset($value['featured_position']) && $value['featured_position'] == 1) {

						$featured_times_total = isset($datebook_get_data['profile_subscription']['featured_times_total']) && $datebook_get_data['profile_subscription']['featured_times_total'] > 0 ? $datebook_get_data['profile_subscription']['featured_times_total'] : 0;
						$featured_times_left = isset($datebook_get_data['profile_subscription']['featured_times_left']) && $datebook_get_data['profile_subscription']['featured_times_left'] > 0 ? $datebook_get_data['profile_subscription']['featured_times_left'] : 0;
				
						$period_number_featured_position = isset($value['period_number_featured_position']) && $value['period_number_featured_position'] > 0 ? $value['period_number_featured_position'] : 0;
						$period_featured_position = isset($value['period_featured_position']) && $value['period_featured_position'] > 0 ? $value['period_featured_position'] : 0;
						$period_featured_starts = isset($datebook_get_data['profile_subscription']['featured_starts']) && $datebook_get_data['profile_subscription']['featured_starts'] > 0 ? $datebook_get_data['profile_subscription']['featured_starts'] : 0;

						$featured_position_after_period = $period_featured_starts + ($period_number_featured_position * $time_in_seconds_array[$period_featured_position]);

						echo '<p class="card-text m-0 p-0 datebook-period-panel">';

						if ($featured_active == 1) {

							$featured_ends = get_post_meta($profile_id, 'featured_ends', true);
					
							$featured_ends_time = isset($featured_ends) && $featured_ends > 0 ? DateBook_Utilities::datebook_date_i18n(2, $featured_ends, false) : esc_html__( 'unlimited period', 'datebook' );
							$featured_ends_time_hours = isset($featured_ends) && $featured_ends > 0 ? DateBook_Utilities::datebook_date_i18n(2, $featured_ends, false) : esc_html__( 'unlimited period', 'datebook' );

							echo '<span class="badge badge-success shadow-none" data-toggle="tooltip" data-placement="top" title="' . esc_html__( 'Featured status is active until', 'datebook' ).': ' . esc_attr($featured_ends_time_hours) . '" data-original-title="' . esc_html__( 'Featured status is active until', 'datebook' ).': ' . esc_attr($featured_ends_time_hours) . '">'. esc_html__( 'Featured', 'datebook' ) . '</span> ';
							echo ' <small>';
							echo esc_html__( 'till', 'datebook' ) . ': ' . esc_attr($featured_ends_time);
							echo '</small>';
					
							if($featured_times_left > 0 && $featured_times_total > 0 && ($featured_times_left == $featured_times_total || ($featured_times_left <= $featured_times_total && $featured_position_after_period <= time()))){

								echo '<a href="javascript:void(0)"  id="datebook-featured-' . absint($profile_id) . '" class="btn btn-sm btn-success m-0 float-right datebook-activate-topfeatured" data-toggle="tooltip" data-placement="top" title="' . esc_html__( 'You can move your profile to Featured position', 'datebook' ) . ': ' . esc_attr($featured_times_left) . ' ' . esc_html__( 'times', 'datebook' ) . '" data-original-title="' . esc_html__( 'You can move your profile to Featured position', 'datebook' ) . ': ' . esc_attr($featured_times_left) . ' ' . esc_html__( 'times', 'datebook' ) . '">' . esc_html__( 'Activate', 'datebook' ) . '</a>';

							} else {

								echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Activated', 'datebook' ) . '</a>';

							}

						} else {

							echo ' <span class="badge badge-info shadow-none" title="' . esc_html__( 'Featured status is not active', 'datebook' ) . '">' . esc_html__( 'Featured', 'datebook' ) . '</span> ';
							echo ' <span class="small datebook-period-ends">';
							echo esc_html__( 'not active', 'datebook' );
							echo '</span>';

							if($featured_times_left > 0 && $featured_times_total > 0){

								if($featured_times_left == $featured_times_total || ($featured_times_left <= $featured_times_total && $featured_position_after_period <= time())){

									echo '<a href="javascript:void(0)" id="datebook-featured-' . absint($profile_id) . '" class="btn btn-sm btn-success m-0 float-right datebook-activate-topfeatured">' . esc_html__( 'Activate', 'datebook' ) . '</a>';

								} else {

									echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Disabled', 'datebook' ) . '</a>';

								}

							} else {

								echo '<a href="javascript:void(0)" class="btn btn-sm btn-light m-0 float-right disabled">' . esc_html__( 'Disabled', 'datebook' ) . '</a>';

							}
						}
						
						echo '<br>';

						echo '<span class="small">' . esc_html__( 'Total', 'datebook' ) . ' <span class="datebook-featured-total">' . $featured_times_total . '</span>; ' . esc_html__( 'Left', 'datebook' ) . ': <span class="datebook-featured-left">' . $featured_times_left . '</span></span>';

						if($featured_times_left > 0 && $featured_times_total > 0 && $featured_times_left <= $featured_times_total){

							$featured_position_after_period_left = $featured_position_after_period - time();

							$days = floor($featured_position_after_period_left / 86400);
							$featured_position_after_period_left %= 86400;
							$hours = floor($featured_position_after_period_left / 3600);
							$featured_position_after_period_left %= 3600;
							$minutes = floor($featured_position_after_period_left / 60);
							$featured_position_after_period_left %= 60;

							$featured_period_title = '';

							if($days > 0 || $hours > 0 || $minutes > 0){
								$featured_period_title .= esc_html__( 'in', 'datebook' ) . ' ';
							} else {
								$featured_period_title .= esc_html__( 'now', 'datebook' ) . ' ';
							}

							if($days > 0){
								$featured_period_title .= $days . ' ' . esc_html__( 'days', 'datebook' ) . ' ';
							}
							if($hours > 0){
								$featured_period_title .= $hours . ' ' . esc_html__( 'hours', 'datebook' ) . ' ';
							}
							if($minutes > 0){
								$featured_period_title .= $minutes . ' ' . esc_html__( 'minutes', 'datebook' );
							}

							echo '<br><span class="small">' . esc_html__( 'You may activate it again', 'datebook' ) . ' <span class="datebook-featured-period-left">' . esc_html($featured_period_title) . '</span></span>';

						} else {

							echo '<br><span class="small">' . esc_html__( 'You have reached the limit and may not activate it again', 'datebook' ) . '</span>';

						}

						echo '</p>';
				
					}

					echo '</div>';
				
				}

			}



			if ($active_woocommerce_subscription == 1) {

				if(isset($value['wc_subscription_product']) && isset($all_subscription_plans[$value['wc_subscription_product']])){

					if(isset($value['price']) && is_array($value['price'])) {

						echo '<h5 class="mt-1 mb-3">';

						if(isset($all_subscription_plans[$value['wc_subscription_product']]['get_price']) && $all_subscription_plans[$value['wc_subscription_product']]['get_price'] == 0 && isset($all_subscription_plans[$value['wc_subscription_product']]['price_is_per']) && $all_subscription_plans[$value['wc_subscription_product']]['price_is_per'] == 0){
							
							echo esc_html__( 'Free', 'datebook' );

						} else {

							echo wp_kses($all_subscription_plans[$value['wc_subscription_product']]['get_price_html'], array('span' => array(), 'del' => array()));

						}

						echo '</h5>';

						// Get temporary payment data from database
						$subscription_temp_array = get_post_meta($profile_id, 'subscriptionplan_temp');

						if(isset($subscription_temp_array[0]['subscription_id']) && $subscription_temp_array[0]['subscription_id'] == $value['subscription_id'] && isset($all_subscription_plans[$value['wc_subscription_product']]['subscription_id']) && $all_subscription_plans[$value['wc_subscription_product']]['subscription_id'] != $value['subscription_id'] && isset($all_subscription_plans['last_order']) && $free_for_gender == 0){

							//if($all_subscription_plans['last_order']->get_status() == 'on-hold'){
							
								$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('email_website');

								echo '<div class="card-text border mb-3 p-1 pl-2 pr-2">';
								echo '<p class="deep-orange-text">';
								echo esc_html__( 'Recently you selected the plan below', 'datebook' ) . '<br>';
								echo esc_html__( 'Status', 'datebook' ) . ': ' . esc_html__( 'pending', 'datebook' ) . ' <span class="badge badge-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__( 'Pending status means you have not paid yet. After payment is received, this plan will become active. In case another plan is active, it will be disabled.', 'datebook' ) . '">' . esc_html__( 'What is it?', 'datebook' ) . '</span>';
								echo '</p>';
								echo '<p>' . esc_html__( 'We are currently awaiting payment for your subscription. Send a copy of the receipt to an email shown below.', 'datebook' ) . '</p>';
								echo '<p>' . esc_html__( 'Email', 'datebook' ) . ': ' . sanitize_email($to_email) . '</p>';

								//if($all_subscription_plans['last_order']->get_payment_method() === 'bacs'){

									$bacs_info = get_option('woocommerce_bacs_accounts');

									if ($bacs_info){

									?>

									<div class="woocommerce-bacs-bank-details">
										<h5 class="wc-bacs-bank-details-heading"><?php _e('Our bank details'); ?></h5>

										<?php foreach ( $bacs_info as $account ){ ?>

											<table width="100%" class="table m-0" cellspacing="0">
												<tr>
													<th><?php _e( 'Account name', 'woocommerce' ); ?></th><td><?php echo esc_attr(wp_unslash($account['account_name'])); ?></td>
												</tr>
												<tr>
													<th><?php _e( 'Account number', 'woocommerce' ); ?></th><td><?php echo esc_attr($account['account_number']); ?></td>
												</tr>
												<tr>
													<th><?php _e( 'Bank name', 'woocommerce' ); ?></th><td><?php echo esc_attr(wp_unslash($account['bank_name'])); ?></td>
												</tr>
												<tr>
													<th><?php echo __( 'Sort code', 'woocommerce' ); ?></th><td><?php echo esc_attr($account['sort_code']); ?></td>
												</tr>
												<tr>
													<th><?php _e( 'IBAN', 'woocommerce' ); ?></th><td><?php echo esc_attr($account['iban']); ?></td>
												</tr>
												<tr>
													<th><?php _e( 'BIC / Swift', 'woocommerce' ); ?></th><td><?php echo esc_attr($account['bic']); ?></td>
												</tr>
											</table>

										<?php } ?>

										</div>
									
									<?php
									
									}
								//}

								echo '</div>';

							//}
						}

						// If profile has some subscription plan then show Active sign
						if ($notactive == 0 && (!isset($subscription_plan_id) && !isset($status)) || ($status == 'pending' || $status == 'canceled' || $status == 'expired') || (isset($subscription_plan_id) && $subscription_plan_id != $value['subscription_id'] && $status_active == 1 && of_get_option('allow_change_subscription') == 1)) {

							$add_to_cart_query_page_link = add_query_arg( array(
								'add-to-cart' => $all_subscription_plans[$value['wc_subscription_product']]['get_the_ID']
								), get_permalink(of_get_option('my_upgrade_page')) );

								// Check if genders selected who must pay for a subscription plan
								if ($free_for_gender == 1){
									echo '<input type="hidden" name="free_for_gender" value="1">';
									echo '<p class="card-text mt-3 mb-2 p-2 rounded green text-white">'.esc_html__( 'You may activate this plan for free', 'datebook' ).'</p>';
								}

							?>

							<a href="<?php echo esc_url($add_to_cart_query_page_link); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart btn btn-sm btn-primary text-white mr-1 p-3 pl-5 pr-5" data-product_id="<?php echo absint($all_subscription_plans[$value['wc_subscription_product']]['get_the_ID']); ?>" data-product_sku="" aria-label="<?php echo esc_html__( 'Add this subscription to your cart', 'datebook' ); ?>" rel="nofollow"><?php echo esc_html__( 'Select', 'datebook' ); ?></a>

						<?php

						}
					}
				}

			} else {
				
				
				if(isset($all_subscription_plans['last_order'][0]->subscription_id) && $all_subscription_plans['last_order'][0]->subscription_id == $value['subscription_id'] && isset($all_subscription_plans['last_order'][0]->status) && $all_subscription_plans['last_order'][0]->status == 'pending' && $date_order_placed > $current_date){

					$count_last_price = 0;

					foreach($value['price'] as $key => $price){

						if($all_subscription_plans['last_order'][0]->plan_price_period == $key){

							$count_last_price++;

							$last_price = isset($price) && $price > 0 ? DateBook_Profile_Subscription::datebook_format_money($price) : esc_html__( 'Free', 'datebook' );
							$last_period_out = $value['register_period_number'][$key] > 0 ? DateBook_Utilities::datebook_plural_text($value['register_period_number'][$key], $value['register_period'][$key]) : esc_html__( 'Unlimited period', 'datebook' );
							$last_price_out = esc_attr($last_price . ' / ' . $last_period_out);

						}

					}

					// Get temporary payment data from database
					$subscription_temp_array = get_post_meta($profile_id, 'subscriptionplan_temp');

					if($count_last_price > 0 && is_array($subscription_temp_array) && !empty($subscription_temp_array) && $free_for_gender == 0){

						echo '<p class="card-text border p-1 pl-2 pr-2 deep-orange-text">';
						echo esc_html__( 'Recently you selected the plan below', 'datebook' ) . '<br>';
						echo esc_html__( 'Price', 'datebook' ) . ': ' . esc_attr($last_price_out) . '<br>';
						echo esc_html__( 'Status', 'datebook' ) . ': ' . esc_html__( 'pending', 'datebook' ) . ' <span class="badge badge-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . esc_html__( 'Pending status means you have not paid yet. After payment is received, this plan will become active. In case another plan is active, it will be disabled.', 'datebook' ) . '">' . esc_html__( 'What is it?', 'datebook' ) . '</span>';
						echo '</p>';

						if ($subscription_temp_array[0]['payment_gateway'] == 'bank' && isset($gateway_options['bank']['enabled']) && $gateway_options['bank']['enabled'] == 1) {

							$gateway_option_bank = isset($gateway_options['bank']) ? $gateway_options['bank'] : '';

							?>

							<div class="alert alert-info">
								<p><?php esc_html_e( 'Bank Transfer can take several business days before we can see your payment. Send a copy of the receipt to email shown below. You must include the invoice number sent to your email as a reference.', 'datebook' ); ?></p>
								<p class="lead"><?php echo sanitize_email($gateway_option_bank['email']); ?></p>

								<h4 class="alert-heading"><?php esc_html_e( 'Bank details', 'datebook' ); ?></h4>
								<p class="mb-0"><?php echo nl2br(esc_attr($gateway_option_bank['bank_details'])); ?></p>
							</div>

						<?php

						}
					}
				}


				if(isset($value['price']) && is_array($value['price'])) {

					// If profile has some subscription plan then show Active sign
					if ($notactive == 0 && ($subscription_plan_id != $value['subscription_id'] || $subscription_plan_id == $value['subscription_id'] && ($status == 'pending' || $status == 'canceled' || $status == 'expired'))) {
						
						?>

						<form method="post" action="<?php echo esc_url(get_permalink(of_get_option('my_upgrade_page'))); ?>" target="_top">
							<input type="hidden" name="action" value="payment_page">
							<input type="hidden" name="payment_page" value="2">
							<input type="hidden" name="subscriptionplan" value="<?php echo esc_attr($value['subscription_id']); ?>">
						
							<?php

							echo '<div class="btn-group d-flex btn-group-toggle mb-2 card-text" data-toggle="buttons">';
						

							if(count($value['price']) > 3){
								echo '<select name="subscriptionplan_price" class="custom-select">';
							}
							
							$count_price = 0;

							foreach($value['price'] as $key => $price){
								
								if(isset($price) && $price > 0){
									$count_price++;
									$value_price = DateBook_Profile_Subscription::datebook_format_money($price);
								} else {
									$value_price = esc_html__( 'Free', 'datebook' );
								}

								$subscription_period_out = $value['register_period_number'][$key] > 0 ? DateBook_Utilities::datebook_plural_text($value['register_period_number'][$key], $value['register_period'][$key]) : esc_html__( 'Unlimited period', 'datebook' );

								if(count($value['price']) > 3){
									echo '<option value="' . esc_attr($key) . '">' . esc_attr($value_price). ' / ' . esc_attr($subscription_period_out) . '</option>';
								} else if(count($value['price']) > 1){
									echo '<label class="btn btn-light pl-1 pr-1 form-check-label shadow-none">';
									echo '<input class="form-check-input" type="radio" name="subscriptionplan_price" value="' . esc_attr($key) . '" id="' . esc_attr($key) . '" autocomplete="off"> ' . esc_attr($value_price). '<br>' . esc_attr($subscription_period_out);
									echo '</label>';
								} else {
									echo '<input type="hidden" name="subscriptionplan_price" value="' . esc_attr($key) . '">';
									echo esc_attr($value_price). ' / ' . esc_attr($subscription_period_out);
								}

							}

							if(count($value['price']) > 3){
								echo '</select>';
							}

							echo '</div>';
	
							// Check if genders selected who must pay for a subscription plan
							if ($count_price > 0 && $free_for_gender == 1){
								echo '<input type="hidden" name="subscriptionplan_price" value="0" />';
								echo '<input type="hidden" name="free_for_gender" value="1">';
								echo '<p class="card-text mt-3 mb-2 p-2 rounded green text-white">'.esc_html__( 'You may activate this plan for free', 'datebook' ).'</p>';

							}

							if ($status_active == 0 || $status_active == 1 && of_get_option('allow_change_subscription') == 1){

								echo '<button type="submit" name="submit" class="btn btn-primary">' . esc_html__( 'Select', 'datebook' ) . '</button>';

							}

						?>

					</form>

					<?php

					} else if($subscription_plan_id == $value['subscription_id']){
						
						$count_active_price = $free_price = 0;

						foreach($value['price'] as $key => $price){

							if($plan_price_period == $key){

								$count_active_price++;

								if(isset($price) && $price > 0){
									$free_price++;
									$last_price = DateBook_Profile_Subscription::datebook_format_money($price);
								} else {
									$last_price = esc_html__( 'Free', 'datebook' );
								}
								$last_period_out = $value['register_period_number'][$key] > 0 ? DateBook_Utilities::datebook_plural_text($value['register_period_number'][$key], $value['register_period'][$key]) : esc_html__( 'Unlimited period', 'datebook' );
								$active_price_out = esc_attr($last_price . ' / ' . $last_period_out);

							}

						}

						if($count_active_price > 0){

							echo '<h5 class="mt-1 mb-3">' . esc_attr($active_price_out) . '</h5>';

						} 
					}
				}
			}

			?>
			
		</div>
	</div>
</li>

<?php

			}
		}

	} else {

		$count_plans = 1;

		echo '<li class="list-group-item datebook-transparent datebook-padding-less">' . esc_html__( 'Profile data have not been found', 'datebook' ) . '</li>';

	}
}

if(isset($count_plans) && $count_plans <= 0){
	
	echo '<li class="list-group-item datebook-transparent datebook-padding-less">' . esc_html__( 'No subsciption plan is found', 'datebook' ) . '</li>';
	
}

?>

</ul>