<?php
/*
 * Profile Registration page with Subscription plans
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $paid_features_subscriptions;

?>

<div class="datebook-custom-card card text-center">
	<div class="card-body">

		<h1><?php esc_html_e( 'Registration', 'datebook' ); ?></h1>

		<hr />

		<div class="pricing-header pb-md-4 mx-auto">
			<h3><?php esc_html_e( 'Select a plan', 'datebook' ); ?></h3>
		</div>
		
		
		<div class="row justify-content-center">
		
		<div class="card-deck col-md-8 mb-3 text-center">
		
			<?php

			// Get Subscription plans

			foreach($get_subscription_plans as $key => $value){

				if (isset($value['active']) && $value['active'] == 1) {

					echo '<div class="card border mb-4 box-shadow">';

					echo '<form action="' . esc_url(get_permalink(of_get_option('registration_page'))) . '" method="post" class="form-horizontal">';
					
					echo '<input type="hidden" name="action" value="subscriptionplan" />';
					echo '<input type="hidden" name="subscriptionplan" value="' . $value['slug'] . '" />';

					// if foreign language do not exist, then show title in English
					$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

					$value['plan_description'] = isset($value['plan_description_' . DATEBOOK_WPLANG]) ? $value['plan_description_' . DATEBOOK_WPLANG] : $value['plan_description_en_US'];

					echo '<div class="card-header">';
					echo '<h4 class="my-0 font-weight-normal">' . esc_attr($value['name']) . '</h4>';
					echo '</div>';
					
					echo '<div class="card-body">';

					echo '<h5 class="card-title pricing-card-title">' . esc_attr($value['plan_description']) . '</h5>';

					echo '<ul class="list-unstyled mt-3 mb-4">';

					$value['subscription_limitphotos'] = isset($value['subscription_limitphotos']) && $value['subscription_limitphotos'] > 0 ? $value['subscription_limitphotos'] . ' ' . esc_html__( 'pictures can be uploaded', 'datebook' ) : esc_html__( 'Unlimited pictures', 'datebook' );
					
					echo '<li class="pt-2 pb-2 border-bottom">' . esc_attr($value['subscription_limitphotos']) . '</li>';
					
					if ($paid_features_subscriptions) {

						foreach ($paid_features_subscriptions as $feature_key => $feature_title) {
							
							echo '<li class="pt-2 pb-2 border-bottom">';

							if (isset($value[$feature_key]) && $value[$feature_key] == 1) {
								
								echo esc_html__( $feature_title, 'datebook' );
								
								if (isset($feature_key) && $feature_key == 'simultaneous_chatters') {
									
									if (isset($value['quantity_simultaneous_chatters']) && $value['quantity_simultaneous_chatters'] > 0){
										echo ' ' . esc_html__( 'to', 'datebook' ) . ' ';

										echo ' ' . $value['quantity_simultaneous_chatters'];
									
										echo ' ' . esc_html__( 'users', 'datebook' ) . '<br>';

										echo '<span class="small">';
										echo esc_html__( 'per', 'datebook' ) . ' ';

										$period_number_simultaneous_chatters = isset($value['period_number_simultaneous_chatters']) ? $value['period_number_simultaneous_chatters'] : 0;
										$period_simultaneous_chatters = isset($value['period_simultaneous_chatters']) ? $value['period_simultaneous_chatters'] : 0;

										echo esc_attr(DateBook_Utilities::datebook_plural_text($period_number_simultaneous_chatters, $period_simultaneous_chatters));
										
										echo '</span>';
										
									} else {
										
										echo ' ' . esc_html__( 'as many as you want', 'datebook' ) . ' ';
										
									}

								}
								

							} else {
								
								echo ' &#8212; &nbsp; ';
								
							}
							
							echo '</li>';
						}
					}

					
					echo '</ul>';

					if(isset($value['price']) && is_array($value['price'])) {

					echo '<div class="datebook-margin-top20 datebook-margin-bottom20">';

						if(count($value['price']) > 1){
							echo '<select name="subscriptionplan_price" class="custom-select">';
						}

							foreach($value['price'] as $key => $price){

								$value_price = isset($price) && $price > 0 ? DateBook_Profile_Subscription::datebook_format_money($price) : esc_html__( 'Free', 'datebook' );

								if(count($value['price']) > 1){
									echo '<option value="' . esc_attr($key) . '">';
								} else {
									echo '<input type="hidden" name="subscriptionplan_price" value="' . esc_attr($key) . '" />';
								}

								echo esc_attr($value_price);

								if(isset($value['register_period'][$key]) && is_array($value['register_period'])) {

									$register_period_out = isset($value['register_period_number'][$key]) && $value['register_period_number'][$key] > 0 ? DateBook_Utilities::datebook_plural_text($value['register_period_number'][$key], $value['register_period'][$key]) : esc_html__( 'Unlimited', 'datebook' );

									echo ' - ' . esc_attr($register_period_out);

								}

								if(count($value['price']) > 1){
									echo '</option>';
								}

							}

						if(count($value['price']) > 1){
							echo '</select>';
						}

						echo '</div>';

					}

					echo '<div class="card-foot">';
					echo '<button type="submit" name="submit" class="btn btn-primary btn-lg">' . esc_html__( 'Select', 'datebook' ) . '</button>';
					echo '</div>';

					echo '</form>';
					
					echo '</div>';
					
					echo '</div>';

				}

			}

			?>
			
			</div>

		</div>
	</div>
</div>
