<?php
/*
 * Profile Classifieds form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$classified_id = (isset($_GET['cid']) ? $_GET['cid'] : 0);

if (isset($_GET['action']) && $_GET['action'] == 'edit' && $classified_id > 0) {

	$classifieds = get_post(absint($classified_id));

	$title = $classifieds->post_title;
	$description = $classifieds->post_content;
	$term_list = wp_get_post_terms(absint($classifieds->ID), DATEBOOK_CLASSIFIEDS_TAX, array("fields" => "all"));
	$term_id = isset($term_list[0]->term_id) ? $term_list[0]->term_id : 0;
	
	$edit_classified = 1;

} else if(isset($_POST['action']) && $_POST['action'] == 'addclassifieds'){

	$term_id = (isset($_POST['subject']) && $_POST['subject'] > 0) ? $_POST['subject'] : '';
	$title = (!empty($_POST['title']) && strlen($_POST['title']) > 5) ? $_POST['title'] : '';
	$description = (!empty($_POST['description']) && strlen($_POST['description']) > 10) ? $_POST['description'] : '';

	$edit_classified = 0;

} else {

	$term_id = 0;
	$title = '';
	$description = '';
	$edit_classified = 0;

}
?>

<div class="datebook-custom-card card">
	<div class="card-body">

		<h2><?php esc_html_e( 'My classifieds', 'datebook' ); ?></h2>

		<div class="card border">
			<div class="card-header">

				<?php if ($edit_classified == 1){ esc_html_e( 'Edit Classified ad', 'datebook' ); } else { esc_html_e( 'Add a classifieds advert', 'datebook' ); } ?>

			</div>
			<div class="card-body">

				<form action="<?php echo esc_url(get_permalink(get_the_ID())); ?>" method="post">

					<input type="hidden" name="action" value="addclassifieds" />

					<?php if (isset($edit_classified) && $edit_classified == 1) { ?>
					<input type="hidden" name="cid" value="<?php echo absint($classified_id); ?>" />
					<?php } ?>

					<?php

					$args = array(
						'name'					=> 'subject',
						'orderby'				=> 'name',
						'order'					=> 'ASC',
						'show_last_update'		=> 0,
						'style'					=> '',
						'show_count'			=> 0,
						'hide_empty'			=> 0,
						'use_desc_for_title'	=> 0,
						//'child_of'			=> $catMain->term_id,
						'exclude'				=> '',
						'exclude_tree'			=> '',
						'include'				=> '',
						'hierarchical'			=> true,
						'title_li'				=> '',
						'show_option_none'		=> esc_html__( 'Select a subject', 'datebook' ),
						'number'				=> NULL,
						'echo'					=> 0,
						'depth'					=> 1,
						'current_category'		=> 0,
						'hide_if_empty'			=> true,
						'selected'				=> $term_id,
						'pad_counts'			=> 0,
						'class'					=> 'custom-select',
						'taxonomy'				=> DATEBOOK_CLASSIFIEDS_TAX
					);

					if(!empty(wp_dropdown_categories($args))){

					?>

					<div class="form-group row <?php if (isset($datebook_alert_text['subject'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['subject'])); } ?>">

						<label for="datebook-classifieds-offer-direction" class="col-sm-3 control-label"><?php esc_html_e( 'Subject', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<?php echo wp_dropdown_categories($args); ?>
							
						</div>
					</div>
					
					<?php } ?>

					<div class="form-group row <?php if (isset($datebook_alert_text['title'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['title'])); } ?>">

						<label for="title" class="col-sm-3 control-label"><?php esc_html_e( 'Title', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<input type="text" name="title" id="title" value="<?php echo esc_html($title); ?>" class="form-control" />

						</div>
					</div>

					<div class="form-group row <?php if (isset($datebook_alert_text['description'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['description'])); } ?>">

						<label for="datebook-description" class="col-sm-3 control-label"><?php esc_html_e( 'Description', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<textarea name="description" id="datebook-description" rows="8" cols="42" class="form-control"><?php if (isset($description)) { echo esc_textarea($description); } ?>
</textarea>

						</div>
					</div>
					
					
					<div class="form-group row">

						<label class="col-sm-3 control-label"> </label>

						<div class="col-sm-9">

							<button type="submit" name="submit" class="btn btn-primary btn-lg"><?php if (isset($edit_classified) && $edit_classified == 1) { esc_html_e( 'Save', 'datebook' ); } else { esc_html_e( 'Submit', 'datebook' ); }?></button>

						</div>
					</div>

				</form>

			</div>
		</div>
	</div>
</div>