<?php
/*
 * Profile Classifieds
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$my_classifieds_link = get_permalink(of_get_option('my_classifieds_page'));

$args = array(
	'name'					=> 'subject',
	'hide_empty'			=> 0,
	'use_desc_for_title'	=> 0,
	'hierarchical'			=> true,
	'number'				=> NULL,
	'echo'					=> 0,
	'depth'					=> 1,
	'current_category'		=> 0,
	'hide_if_empty'			=> true,
	'pad_counts'			=> 0,
	'taxonomy'				=> DATEBOOK_CLASSIFIEDS_TAX
);

if(!empty(wp_dropdown_categories($args))){
	$datebook_categories_exists = 1;
} else {
	$datebook_categories_exists = 0;
}

?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h2 class="card-title"><?php esc_html_e( 'My classifieds', 'datebook' ); ?></h2>

		<div class="card border datebook-transparent">

			<div class="card-header">

				<?php esc_html_e( 'Classifieds you added', 'datebook' ); ?>

			</div>

				<?php

				$args = array(
					'author' => $current_user_id,
					'post_type' => DATEBOOK_CLASSIFIEDS_TYPE,
					'post_status' => 'publish, private, draft',
					'posts_per_page' => -1,
					'orderby' => 'date',
					'order' => 'DESC'
				);

				$the_query = new WP_Query( $args );

				if ( $the_query->have_posts() ) :
				
				?>
				
				<ul class="list-group list-group-flush">
				
				<?php
			
				while ( $the_query->have_posts() ) : $the_query->the_post();
				
					$post_id = get_the_ID();
					
					$classified_description = get_the_content();
						
					$term_list = wp_get_post_terms($post_id, DATEBOOK_CLASSIFIEDS_TAX, array("fields" => "all"));

					$term_vals = isset($term_list[0]->term_id) ? get_term_meta($term_list[0]->term_id) : '';
					
					if($datebook_categories_exists == 1){
						$subject_name = isset($term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0]) ? $term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0] : (isset($term_list[0]->name) ? $term_list[0]->name : esc_html__( 'Common', 'datebook' ));
						
						$subject_name_out = ' | ' . esc_html__( 'Subject', 'datebook' ) . ': ' . $subject_name;
						
					} else {
						$subject_name_out = '';
					}
					
					$edit_item_link = add_query_arg( array(
						'action' => 'edit',
						'cid' => $post_id
					), $my_classifieds_link );

					$delete_item_link = add_query_arg( array(
						'action' => 'delete',
						'cid' => $post_id
					), $my_classifieds_link );

				?>

				<li class="list-group-item datebook-transparent">
					<div class="row">
						<div class="col-lg-10 col-md-10 col-sm-10">

							<h4 class="list-group-item-heading"><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>

							<p>
							<?php if(get_post_status($post_id) == 'publish'){ ?>
								<span class="badge badge-success mr-1"><?php esc_html_e( 'Approved', 'datebook' ); ?></span>
							<?php } else { ?>
								<span class="badge badge-warning mr-1"><?php esc_html_e( 'Pending', 'datebook' ); ?></span>
							<?php } ?> 
							<span class="small"><strong><?php esc_html_e( 'Placed', 'datebook' ); ?>:</strong> <?php echo DateBook_Utilities::datebook_date_i18n( 2, get_the_time()); ?><?php echo esc_attr($subject_name_out); ?></span>
							</p>
							
							<hr>
							
							<div class="card border-0">
								<?php echo esc_html($classified_description); ?>
							</div>
							
						</div>

						<div class="col-lg-2 col-md-2 col-sm-2">

							<p><span><?php esc_html_e( 'ID', 'datebook' ); ?>: <?php echo absint($post_id); ?></span></p>

							<a class="btn btn-light btn-sm" href="<?php echo esc_url($edit_item_link); ?>" title="<?php esc_html_e( 'Edit', 'datebook' ); ?>"><i class="fa fa-edit"></i></a>

							<a class="btn btn-link btn-sm" href="<?php echo esc_url($delete_item_link); ?>" title="<?php esc_html_e( 'Delete', 'datebook' ); ?>"><i class="fa fa-trash"></i></a>
							
						</div>
					</div>
				</li>

				<?php endwhile; ?>
				
				</ul>

				<?php else: ?>

				<div class="card-body"><?php esc_html_e( 'No classifieds yet', 'datebook' ); ?></div>

				<?php
		
			endif;

			wp_reset_postdata();

			?>

			
		</div>
	</div>
</div>

<?php 

// display the Edit Profile form
include DateBook_Template_Loader::locate( 'profile/profile-classifieds-addbutton' );