<?php
/*
 * Profile Privacy
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_get_data, $datebook_field_titles, $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}


$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

if(isset($datebook_get_data['enablefriends'])){
	$enablefriends = $datebook_get_data['enablefriends'] == '1' ? 1 : 0;
} else {
	$enablefriends = 1;
}

$enable_friendship = of_get_option('enable_friendship') ? 1 : 0;
$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

if (isset($datebook_alert_text['error_required_fields'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';

}

?>

<?php if (isset($datebook_alert_text['success_friends_settings_updated'])) { ?>

	<div class="alert alert-success"><?php echo esc_attr($datebook_alert_text['success_friends_settings_updated']); ?></div>

<?php } ?>

<div class="datebook-custom-card card mb-3">

	<form action="<?php echo esc_url(get_permalink(of_get_option('my_friends_page'))); ?>" method="post" class="form-horizontal">

		<input type="hidden" name="action" value="change" />
		<input type="hidden" name="friendssettings" value="1" />

		<div class="card-body">

			<h2><?php esc_html_e( 'Friends', 'datebook' ); ?></h2>

			<hr />

			<?php if (of_get_option('user_can_disable_friendship') == 1){ ?>

			<div class="form-group row">

				<label for="datebook-enable-friends" class="col-sm-6 control-label"><?php esc_html_e( 'Enable Friends system', 'datebook' ); ?></label>

				<div class="col-sm-6">
					<div class="checkbox">
						<div class="custom-control custom-checkbox">
								<input type="checkbox" name="enablefriends" class="custom-control-input" id="datebook-enable-friends" value="1" <?php if ($enablefriends == 1){ echo ' checked="checked"'; } ?> /> <label class="custom-control-label" for="datebook-enable-friends"><?php esc_html_e( 'Yes', 'datebook' ); ?></label>
						</div>
					</div>
				</div>
			</div>

			<?php } ?>


			<div class="form-group row">

				<label for="datebook-friend-request" class="col-sm-6 control-label"><?php esc_html_e( 'Who can send friend request to me', 'datebook' ); ?></label>

				<div class="col-sm-6">

					<?php
					
					$who_can_send_friend_request = (isset($_POST['who_can_send_friend_request']) && strlen($_POST['who_can_send_friend_request']) > 0) ? $_POST['who_can_send_friend_request'] : (isset($datebook_get_data['who_can_send_friend_request']) && strlen($datebook_get_data['who_can_send_friend_request']) > 0 ? $datebook_get_data['who_can_send_friend_request'] : '');

					$datebook_who_can_see_recreate = $datebook_who_can_see_array;

					unset($datebook_who_can_see_recreate['friends']);
					unset($datebook_who_can_see_recreate['loggedinusers']);

					?>

					<select name="who_can_send_friend_request" id="datebook-friend-request" class="custom-select">

						<?php foreach ($datebook_who_can_see_recreate as $key => $value ){

							if($enable_friendship == 0 && $key == 'friends') continue;

							if($enable_subscription == 0 && $key == 'subscribedusers') continue;
							
							?>
						
							<option <?php if ($who_can_send_friend_request == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_html__($value, 'datebook'); ?></option>

						<?php } ?>

					</select>

				</div>
			</div>
			
			<div class="form-group row">

				<label for="datebook-see-friends" class="col-sm-6 control-label"><?php esc_html_e( 'Who can see my friends', 'datebook' ); ?></label>

				<div class="col-sm-6">

					<?php
					
					$who_can_see_my_friends = (isset($_POST['who_can_see_my_friends']) && strlen($_POST['who_can_see_my_friends']) > 0) ? $_POST['who_can_see_my_friends'] : (isset($datebook_get_data['who_can_see_my_friends']) && strlen($datebook_get_data['who_can_see_my_friends']) > 0 ? $datebook_get_data['who_can_see_my_friends'] : '');

					?>

					<select name="who_can_see_my_friends" id="datebook-see-friends" class="custom-select">

						<?php foreach ($datebook_who_can_see_array as $key => $value ){

							if($enable_friendship == 0 && $key == 'friends') continue;

							if($enable_subscription == 0 && $key == 'subscribedusers') continue;

							?>

							<option <?php if ($who_can_see_my_friends == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_html__($value, 'datebook'); ?></option>

						<?php } ?>

					</select>

				</div>
			</div>

	</div>

	<div class="card-footer">

		<button type="submit" name="submit" class="btn btn-primary"><?php echo esc_html__( 'Save', 'datebook' ); ?></button>

	</div>
	
	</form>
	
</div>