<?php
/*
 * Profile Messages
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($post->ID, 'image_avatar', $gender, true);

?>

<div id="datebook-messages-profile-box-<?php echo esc_attr($post->ID); ?>" class="card border-0 mb-0 datebook-profilepage datebook-transparent">

	<hr />

	<div class="row">

		<div class="col-lg-6 col-md-7 col-sm-7">

		<?php if (isset($post->ID) && $post->ID > 0) { ?>

			<a class="float-left mr-3 mb-3" href="<?php echo esc_url(get_permalink($post->ID)); ?>" target="<?php echo esc_attr($open_profile_new_tab); ?>"><img class="thumbnail rounded" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" /></a>

			<?php if ($show_name == 1 || $show_age == 1 || $show_gender == 1) { ?>
			<h6 class="datebook-profile-heading datebook-ellipsis">
				<?php $show_comma = 0; if ($show_name == 1) { ?><a href="<?php echo esc_url(get_permalink($post->ID)); ?>" target="<?php echo esc_attr($open_profile_new_tab); ?>"><?php echo esc_attr($post->post_title); ?></a><?php $show_comma = 1; }
				if ($show_age == 1 && isset($age) && !empty($age)) { if ($show_comma > 0) { ?>, <?php } ?><span class="text-muted small"><?php echo esc_attr($age); ?></span><?php $show_comma = 1; }
				if ($show_gender == 1 && isset($icogender) && !empty($icogender)) { ?><?php if ($show_comma > 0) { ?>, <?php } ?><span class="small"><i class="<?php echo esc_attr($icogender); ?>"></i></span><?php } ?>
			</h6>
			<?php } ?>

			<p class="mb-1"><?php do_action('datebook_online_status', $key, $gender, 1, 'full'); ?></p>

			<p class="small mb-0 text-muted">

			<?php

			if ($show_city == 1 && isset($city)) {
				echo esc_attr($city);
			}
			if ($show_city == 1 && !empty($city) && $show_country == 1 && !empty($country)) {
				echo ', ';
			}
			if ($show_country == 1 && isset($country)) {
				echo esc_attr($country);
			}

			?>

			</p>

			<?php } ?>
					
		</div>
		
		<div class="col-lg-6 col-md-5 col-sm-5 text-right">

			<?php if (of_get_option('contact_method') == '3' && of_get_option('chat_placement') == '2') { ?>

				<a class="btn btn-light btn-sm pl-3 pr-3" href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php echo esc_html__( 'Open messages', 'datebook' ); ?></a>

			<?php

			} else if (of_get_option('contact_method') == '3' && of_get_option('chat_placement') == '1') {

				$my_messages_page = add_query_arg( array(
    	    	    'action'	=> 'read',
        	    	'sid'		=> absint($key),
	    	        'rid'		=> absint($current_user_id),
					), get_permalink(of_get_option('my_messages_page')) );

				?>

				<a <?php if ($open_message_new_window == 1) { ?>id="datebook-chatpopup" onClick="return false;" <?php } ?>class="btn btn-light btn-sm pl-3 pr-3 datebook-open-chat-button" href="<?php echo esc_url($my_messages_page); ?>"><?php echo esc_html__( 'Open messages', 'datebook' ); ?></a>

			<?php

			} else {

				if ($message > 0) {

					echo '<span class="datebook-messages-quantity-' . esc_attr($post->ID) . ' small">'. sprintf( _n( "%s message", "%s messages", $message, 'datebook' ), $message ) . '</span>';
 
				}

				$my_messages_page = add_query_arg( array(
    	    	    'action'	=> 'read',
        	    	'sid'		=> absint($key),
	    	        'rid'		=> absint($current_user_id),
					), get_permalink(of_get_option('my_messages_page')) );

				?>

				<a <?php if ($open_message_new_window == 1) { ?>id="datebook-chatpopup" onClick="return false;" <?php } ?>class="btn btn-<?php echo esc_attr($status_message_class); ?> btn-sm pl-3 pr-3 datebook-open-chat-button" href="<?php echo esc_url($my_messages_page); ?>"><span class="datebook-chat-open-btn-text" style=" <?php echo esc_attr($status_open_message); ?>"><?php echo esc_html__( 'Open messages', 'datebook' ); ?></span><span class="datebook-chat-new-btn-text" style=" <?php echo esc_attr($status_new_message); ?>"><?php echo sprintf( _n( "<span class='\"d-inline datebook-chat-button-count'\">%d</span> new message", "<span class='\"d-inline datebook-chat-button-count'\">%d</span> new messages", $countnew, 'datebook' ), $countnew ); ?></span></a>

				<a class="btn btn-light btn-sm pl-3 pr-3 datebook-confirm-action" profile-id="<?php echo absint($key); ?>" onClick="return false;" href="javascript:void(0)" do-action="datebook-delete-messages" confirmtext="<?php echo esc_html__( 'Delete', 'datebook' ); ?>" canceltext="<?php echo esc_html__( 'Cancel', 'datebook' ); ?>" title="<?php echo esc_html__( 'Delete all the messages from this user', 'datebook' ); ?>" what-page="<?php if ($my_favorites_page == 1 && in_array($post->ID, $favorites_or_blacklist)) { ?>favorites<?php } else if ($my_blacklist_page == 1) { ?>blacklist<?php } ?>"><i class="fas fa-trash"></i></a>

				<?php if ($my_blacklist_page == 1 && in_array($post->ID, $favorites_or_blacklist)) { ?>

					<a class="btn btn-dark btn-sm datebook-confirm-action" profile-id="<?php echo absint($post->ID); ?>" onClick="return false;" href="javascript:void(0)" do-action="datebook-blacklist-actions" confirmtext="<?php echo esc_html__( 'Remove', 'datebook' ); ?>" canceltext="<?php echo esc_html__( 'Cancel', 'datebook' ); ?>" title="<?php echo esc_html__( 'Remove from the blacklist', 'datebook' ); ?>"><i class="fas fa-user-secret"></i></a>

				<?php } ?>
			
			<?php } ?>

			<?php if ($my_favorites_page == 1 && in_array($post->ID, $favorites_or_blacklist)) { ?>

				<a class="btn btn-dark btn-sm datebook-confirm-action" profile-id="<?php echo absint($post->ID); ?>" onClick="return false;" href="javascript:void(0)" do-action="datebook-favorited-actions" confirmtext="<?php echo esc_html__( 'Remove', 'datebook' ); ?>" canceltext="<?php echo esc_html__( 'Cancel', 'datebook' ); ?>" title="<?php echo esc_html__( 'Remove from Favorites', 'datebook' ); ?>"><i class="fas fa-bookmark"></i></a>

			<?php }	?>

		</div>
	</div>
</div>