<?php
/*
 * Profile Privacy
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_get_data, $datebook_field_titles, $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}


$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

$current_user_not_admin = get_userdata($current_user_id);
$datebook_get_user = isset($current_user_not_admin->user_login) ? $current_user_not_admin->user_login : '';


if (isset($datebook_alert_text['error_required_fields'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';

}

if (isset($datebook_alert_text['success_profile_updated'])) { ?>

	<div class="alert alert-success"><?php echo esc_attr($datebook_alert_text['success_profile_updated']); ?></div>

<?php } ?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h2><?php esc_html_e( 'Privacy', 'datebook' ); ?></h2>

		<hr />

		<form action="<?php echo esc_url(get_permalink(of_get_option('my_privacy_page'))); ?>" method="post" class="form-horizontal">

			<input type="hidden" name="action" value="change" />
			<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />

			<?php if (of_get_option('registration_method') == 1) { ?>

			<div class="form-group row <?php if (isset($datebook_alert_text['user'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['user'])); } ?>">

				<label for="datebook-user" class="col-sm-3 control-label"><?php esc_html_e( 'Username', 'datebook' ); ?></label>

				<div class="col-sm-9">

					<p class="form-control-static"<?php if (is_user_logged_in()) { echo ' title="' . esc_html__( 'Username is set only once during registration and cannot be changed', 'datebook' ) . '"'; }?>><?php if (isset($datebook_get_user)) { echo esc_attr($datebook_get_user); } ?></p>

				</div>
			</div>

			<?php

			}


			if (is_user_logged_in()) {

			?>

			<div class="form-group row <?php if (isset($datebook_alert_text['currentpass'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['currentpass'])); } ?>">

				<label for="datebook-currentpass" class="col-sm-3 control-label"><?php esc_html_e( 'Current password', 'datebook' ); ?></label>

				<div id="datebook_show_password" class="col-sm-6">

					<a class="position-absolute grey-text" style="bottom:5px; right: 25px;" data-position="right middle" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>

					<input type="password" name="currentpass" id="datebook-currentpass" value="<?php if (isset($currentpass)) { echo esc_attr($currentpass); } ?>" autocomplete="off" class="form-control" /> 

					<?php 

					if (isset($datebook_alert_text['currentpass'])) {

						echo '<em class="text-error">' . esc_attr($datebook_alert_text['currentpass']) . '</em>';

					}

					?>

				</div>
			</div>

			<?php
			
			}


			if (is_user_logged_in() || !is_user_logged_in() && of_get_option('let_users_set_pass') == 1) {

				$min_characters_password = of_get_option('min_characters_password') ? of_get_option('min_characters_password') : 4;
				$max_characters_password = of_get_option('max_characters_password') ? of_get_option('max_characters_password') : 50;

				?>

			<div class="form-group row <?php if (isset($datebook_alert_text['newpass'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['newpass'])); } ?>">

				<label for="datebook-newpass" class="col-sm-3 control-label"><?php if (is_user_logged_in()) { echo esc_html__( 'New password', 'datebook' ); } else { echo esc_html__( 'Password', 'datebook' ); } ?></label>

				<div id="datebook_show_password" class="col-sm-6">
				
					<a class="position-absolute grey-text" style="bottom:5px; right: 25px;" data-position="right middle" href=""><i class="fa fa-eye-slash" aria-hidden="true"></i></a>

					<input type="password" name="newpass" id="datebook-newpass" value="<?php if (isset($newpass)) { echo esc_attr($newpass); } ?>" class="form-control" autocomplete="off" placeholder="<?php echo sprintf(esc_html__( 'between %1$s and %2$s characters', 'datebook' ), $min_characters_password, $max_characters_password); ?>" />

					<?php 

					if (isset($datebook_alert_text['newpass'])) {

						echo '<em class="text-error">' . esc_attr($datebook_alert_text['newpass'])."</em>";

					}

					?>

				</div>
			</div>
	
			<?php } ?>

			<hr>

			<?php

			$allow_choose_who_can_see_profile = of_get_option('allow_choose_who_can_see_profile') ? of_get_option('allow_choose_who_can_see_profile') : array();

			$allow_choose_who_can_see_images = of_get_option('allow_choose_who_can_see_images') ? of_get_option('allow_choose_who_can_see_images') : array();

			$count_allow_choose_who_can_see_profile = count(array_keys($allow_choose_who_can_see_profile, 1));

			$count_allow_choose_who_can_see_images = count(array_keys($allow_choose_who_can_see_images, 1));

			if (isset($count_allow_choose_who_can_see_profile) && $count_allow_choose_who_can_see_profile > 0 || isset($count_allow_choose_who_can_see_images) && $count_allow_choose_who_can_see_images > 0){

				$enable_friendship = of_get_option('enable_friendship') ? 1 : 0;

				if (isset($count_allow_choose_who_can_see_profile) && $count_allow_choose_who_can_see_profile > 0) {

				?>

				<div class="form-group row">

					<label for="datebook-who-see-profile" class="col-sm-3 control-label"><?php esc_html_e( 'Who can see my profile', 'datebook' ); ?></label>

					<div class="col-sm-6">

						<?php
						
						$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

						$datebook_who_can_see_my_profile = (isset($_POST['datebook_who_can_see_my_profile'])) ? $_POST['datebook_who_can_see_my_profile'] : (isset($datebook_get_data['datebook_who_can_see_my_profile']) ? $datebook_get_data['datebook_who_can_see_my_profile'] : '');

						?>

						<select name="datebook_who_can_see_my_profile" id="datebook-who-see-profile" class="custom-select">

							<?php foreach ($datebook_who_can_see_array as $key => $value ){
								
								if($enable_friendship == 0 && $key == 'friends') continue;
								
								if($enable_subscription == 0 && $key == 'subscribedusers') continue;
								
								if(isset($allow_choose_who_can_see_profile[$key]) && $allow_choose_who_can_see_profile[$key] != 1) continue;
								
								?>

								<option <?php if ($datebook_who_can_see_my_profile == $key) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_html__($value, 'datebook');?></option>

							<?php } ?>

						</select>

					</div>
				</div>

				<?php } ?>

				<?php if (isset($count_allow_choose_who_can_see_images) && $count_allow_choose_who_can_see_images > 0){ ?>

				<div class="form-group row">

					<label for="datebook-who-see-images" class="col-sm-3 control-label"><?php esc_html_e( 'Who can see my images', 'datebook' ); ?></label>

					<div class="col-sm-6">

						<?php
					
						$datebook_who_can_see_my_images = (isset($_POST['datebook_who_can_see_my_images'])) ? $_POST['datebook_who_can_see_my_images'] : (isset($datebook_get_data['datebook_who_can_see_my_images']) ? $datebook_get_data['datebook_who_can_see_my_images'] : '');

						?>

						<select name="datebook_who_can_see_my_images" id="datebook-who-see-images" class="custom-select">

							<?php

							foreach ($datebook_who_can_see_array as $key => $value ){

								if($enable_friendship == 0 && $key == 'friends') continue;

								if($enable_subscription == 0 && $key == 'subscribedusers') continue;
								
								if(isset($allow_choose_who_can_see_images[$key]) && $allow_choose_who_can_see_images[$key] != 1) continue;

								?>
						
								<option <?php if ($datebook_who_can_see_my_images == $key) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_html__($value, 'datebook'); ?></option>

							<?php } ?>

						</select>

					</div>
				</div>
			
			<?php } } ?>

			<?php if (of_get_option('enable_hide_zodiac') == 1 && is_user_logged_in() && of_get_option('allow_hide_zodiac') == 1){ ?>

			<div class="form-group row <?php if (isset($datebook_alert_text['hidezodiac'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['hidezodiac'])); } ?>">

				<label for="datebook-hidezodiac" class="col-sm-3 control-label"><?php esc_html_e( 'Hide Zodiac sign', 'datebook' ); ?></label>

				<div class="col-sm-6">
					<div class="checkbox">
						<div class="custom-control custom-checkbox">
								<input type="checkbox" name="hidezodiac" class="custom-control-input" id="datebook-hidezodiac" value="1" <?php if ( isset($datebook_get_data['hidezodiac']) && $datebook_get_data['hidezodiac'] == '1' ) { echo ' checked="checked"'; } ?> /> <label class="custom-control-label" for="datebook-hidezodiac"><?php esc_html_e( 'Yes', 'datebook' ); ?></label>
						</div>
					</div>
				</div>
			</div>

			<?php } ?>

			<div class="form-group row mb-0">
				<label class="col-sm-3 control-label"> </label>
				<div class="col-sm-6">
					<button type="submit" name="submit" class="btn btn-primary"><?php echo esc_html__( 'Save', 'datebook' ); ?></button>
				</div>
			</div>
		
		</form>

	</div>
	
</div>

<?php if (of_get_option('allow_deactivate_account') == 1) { ?>

<script>
function datebook_deactivate_js() {

	var confirmdeactivate = confirm("<?php esc_html_e( 'Do you really want to deactivate your profile?', 'datebook' ); ?>");
	
	if (confirmdeactivate) {
		
		return true;
		
	} else {
		
		return false;
		
	}
	
}
</script>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<form action="<?php echo esc_url(get_permalink(of_get_option('my_privacy_page'))); ?>" method="post" class="form-horizontal">

			<input type="hidden" name="action" value="change" />
			<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />

			<input type="hidden" name="datebook_deactivate_account" value="<?php if ( isset($datebook_get_data['datebook_deactivate_account']) && $datebook_get_data['datebook_deactivate_account'] == '1' ) { echo '0'; } else { echo '1'; } ?>" />

			<div class="form-group row mb-0">
				<label class="col-sm-3 control-label"><?php echo esc_html__( 'Deactivate my profile', 'datebook' ); ?></label>
				<div class="col-sm-6">

					<p class="form-control-static"><?php echo esc_html__( 'You can temporarily deactivate your profile', 'datebook' ); ?></p>

					<button type="submit" name="submit" <?php if ( isset($datebook_get_data['datebook_deactivate_account']) && $datebook_get_data['datebook_deactivate_account'] == "1" ) { echo 'class="btn btn-sm btn-primary"';  } else { echo 'class="btn btn-sm btn-light"'; echo 'onclick="return datebook_deactivate_js();"'; } ?> <?php if ( isset($datebook_get_data['datebook_delete_account']) && $datebook_get_data['datebook_delete_account'] == "1" ) { echo 'disabled="disabled"'; } ?>><?php if ( isset($datebook_get_data['datebook_deactivate_account']) && $datebook_get_data['datebook_deactivate_account'] == "1" ) { echo esc_html__( 'Activate', 'datebook' ); } else { echo esc_html__( 'Deactivate', 'datebook' ); } ?></button>
				</div>
			</div>

		</form>

	</div>
</div>

<?php } ?>

<?php if (of_get_option('allow_delete_account') == 1) { ?>

<script>
function datebook_delete_js() {

	var confirmdelete = confirm("<?php esc_html_e( 'Do you really want to delete your account?', 'datebook' ); ?>");
	
	if (confirmdelete) {
		
		return true;
		
	} else {
		
		return false;
		
	}
	
}
</script>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<form action="<?php echo esc_url(get_permalink(of_get_option('my_privacy_page'))); ?>" method="post" class="form-horizontal">

			<input type="hidden" name="action" value="change" />
			<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />
			
			<input type="hidden" name="datebook_delete_account" value="<?php if ( isset($datebook_get_data['datebook_delete_account']) && $datebook_get_data['datebook_delete_account'] == "1" ) { echo '0'; } else { echo '1'; } ?>" />

			<div class="form-group row mb-0">
				<label class="col-sm-3 control-label"><?php echo esc_html__( 'Delete my account', 'datebook' ); ?></label>
				<div class="col-sm-9">

					<p class="form-control-static">

					<?php 
				
					$delete_profile_days = of_get_option('delete_profile_days') ? of_get_option('delete_profile_days') : 0;
					
					if($delete_profile_days > 0){
						
						echo sprintf(esc_html__( 'You can delete your account. In this case, your profile will be permanently deleted after %d days.', 'datebook' ), $delete_profile_days);
						echo ' ';
						echo esc_html__( 'You can restore it within this period of time.', 'datebook' );

					}
					
					?>

					</p>

					<button type="submit" name="submit" <?php if ( isset($datebook_get_data['datebook_delete_account']) && $datebook_get_data['datebook_delete_account'] == "1" ) { echo 'class="btn btn-sm btn-primary"';  } else { echo 'class="btn btn-sm btn-light"'; echo 'onclick="return datebook_delete_js();"'; } ?>><?php if ( isset($datebook_get_data['datebook_delete_account']) && $datebook_get_data['datebook_delete_account'] == "1" ) { echo esc_html__( 'Restore', 'datebook' ); } else { echo esc_html__( 'Delete', 'datebook' ); } ?></button>

					<?php 

					if( isset($datebook_get_data['datebook_delete_account']) && $datebook_get_data['datebook_delete_account'] == "1" && isset($datebook_get_data['delete_profile_days']) && $datebook_get_data['delete_profile_days'] > 0){

							$days_left_to_delete = (strtotime(date('Y-m-d', ($datebook_get_data['delete_profile_days']))) - strtotime(date('Y-m-d'))) / (60 * 60 * 24);
							
							echo '<span class="text-grey">' . sprintf(esc_html__( '%d day(s) left until your profile is completely deleted', 'datebook' ), $days_left_to_delete) . '</span>';

					}

					?>

				</div>
			</div>

		</form>

	</div>
</div>

<?php } ?>