<?php
/*
 * Profile Settings form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_alert_error, $datebook_alert_text;

if (isset($datebook_alert_text['success_profile_updated'])) {

	echo '<div class="alert alert-success">' . esc_attr($datebook_alert_text['success_profile_updated']) . '</div>';

}

if (isset($datebook_alert_error) && is_array($datebook_alert_error) && !empty($datebook_alert_error) && isset($datebook_alert_text['error_required_fields'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';

}

if (isset($datebook_alert_text['phone_not_allowed'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['phone_not_allowed']) . '</div>';

}

if (isset($datebook_alert_text['website_not_allowed'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['website_not_allowed']) . '</div>';

}

if (isset($datebook_alert_text['not_allowed'])) {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['not_allowed']) . '</div>';

}

?>

<section class="form-light">
	<div class="datebook-custom-card card">
		<div class="card-body">
		
			<!--Header-->
			<div class="header">

				<h2><?php esc_html_e( 'Settings', 'datebook' ); ?></h2>

			</div>
			<!--Header-->

			<hr />
		
			<div class="row justify-content-md-center datebook-login-form-container">

				<!--Grid column-->
				<div class="col-md-6 mb-4 mt-4">

					<?php echo DateBook_Template_Loader::load( 'profile/profile-settings-form' ); ?>

				</div>
			</div>
		</div>
	</div>
</section>