<?php
/*
 * Social buttons
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://datebook.net
 */


$name_for_social = str_replace(" ", "+", $profile_name);
$url_for_social = get_permalink($profile_id);
$urlencode_for_social = urlencode(get_permalink($profile_id));

$enable_share_facebook = (of_get_option("enable_share_facebook") == "1") ? 1 : 0;
$enable_share_twitter = (of_get_option("enable_share_twitter") == "1") ? 1 : 0;
$enable_share_vkontakte = (of_get_option("enable_share_vkontakte") == "1") ? 1 : 0;

if ($enable_share_facebook == 1 || $enable_share_twitter == 1 || $enable_share_vkontakte == 1) {

?>

<div class="datebook-sociallinks datebook-socialbuttons-displayed-shortcode datebook-socialbuttons-template-light-retina" id="datebook-socialbuttons-displayed-shortcode">
	<ul class="datebook-sociallinks-list datebook-socialbuttons-hide-name">

	<?php if ($enable_share_facebook == 1) { ?>
		<li class="datebook-socialbuttons-item datebook-socialbuttons-link-facebook datebook-nolightbox"><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($url_for_social); ?>" rel="nofollow" title="<?php esc_html_e( 'Share this profile and pictures on', 'datebook' ); ?> Facebook" target="_blank" onclick="datebook_socialbutton('https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($url_for_social); ?>', 'facebook'); return false;" ><span class="datebook-socialbuttons-icon"></span></a></li>
	<?php } ?>

	<?php if ($enable_share_twitter == 1) { ?>
		<li class="datebook-socialbuttons-item datebook-socialbuttons-link-twitter datebook-nolightbox" ><a href="#" rel="nofollow" title="<?php esc_html_e( 'Share this profile and pictures on', 'datebook' ); ?> Twitter" target="_blank" onclick="datebook_socialbutton('https://twitter.com/intent/tweet?source=webclient&amp;original_referer=<?php echo esc_url($url_for_social); ?>&amp;text=<?php echo esc_attr($name_for_social); ?>&amp;url=<?php echo esc_url($url_for_social); ?>', 'twitter'); return false;" ><span class="datebook-socialbuttons-icon"></span></a></li>
	<?php } ?>

	<?php if ($enable_share_vkontakte == 1) { ?>
		<li class="datebook-socialbuttons-item datebook-socialbuttons-link-vk datebook-nolightbox" ><a href="https://vkontakte.ru/share.php?url=<?php echo esc_url($url_for_social); ?>" rel="nofollow" title="<?php esc_html_e( 'Share this profile and pictures on', 'datebook' ); ?> VKontakte" onclick="datebook_socialbutton('https://vkontakte.ru/share.php?url=<?php echo esc_url($url_for_social); ?>', 'vk'); return false;" ><span class="datebook-socialbuttons-icon"></span></a></li>
	<?php } ?>

	</ul>
</div>

<?php }