<?php
/**
 * The default template for displaying Featured profiles
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


if ($with_images == 1) {

	$show_feat_profiles_args = array(
		'key' => 'profile_photo_id',
		'value' => '',
		'compare' => '!=',
	);

} else {

	$show_feat_profiles_args = '';

}

$args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'orderby' => 'rand',
	'posts_per_page' => $quantity
);

$the_query = new WP_Query( $args );

if ( $the_query->have_posts()) :

	switch($quantity) {
		case 12 : $quantity_out = 'col-lg-1 col-md-1 col-sm-3'; break;
		case 6 : $quantity_out = 'col-lg-2 col-md-2 col-sm-4'; break;
		case 4 : $quantity_out = 'col-lg-3 col-md-3 col-sm-6'; break;
		case 3 : $quantity_out = 'col-lg-4 col-md-4 col-sm-4'; break;
		default: $quantity_out = 'col-lg-1 col-md-1 col-sm-3'; break;
	}

	switch($round) {
		case 0 : $round_out = ''; break;
		case 1 : $round_out = ' rounded'; break;
		case 2 : $round_out = ' rounded-circle'; break;
		default: $round_out = ''; break;
	}

	$border_width_out = ' border-width: ' . absint($border_width) . 'px !important;';

	if($border_color == 0){
		$border_color_define = 0;
	} else if($border_color == 'random'){
		$border_color_define = 'random';
	} else if($border_color != ''){
		$border_color_define = 1;
	}

	switch($border_style) {
		case 1 : $border_style_out = 'solid'; break;
		case 2 : $border_style_out = 'dashed'; break;
		case 3 : $border_style_out = 'dotted'; break;
		case 4 : $border_style_out = 'double'; break;
		case 5 : $border_style_out = 'groove'; break;
		case 6 : $border_style_out = 'outset'; break;
		case 7 : $border_style_out = 'ridge'; break;
		default: $border_style_out = 'solid'; break;
	}
	
	$space_out = ' m-' . absint($space);
	
	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;
	
	$columns_image_format = 'image_feature_other';

?>

<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">
	<div class="row">

		<?php

		//if (is_user_logged_in()){

			// display the panel suggesting Featured position
			//echo DateBook_Template_Loader::load( 'profiles/offer-add-profile-line' );

		//}
		
		// set up cache folder
		$upload_dir = wp_upload_dir();
		$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');


		while ( $the_query->have_posts() ) : $the_query->the_post();

			$profile_id = absint(get_the_ID());

			$get_profile_data = get_post_meta($profile_id, "profile_personal_data", true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			$country = $region = $city = '';

			if(isset($datebook_get_data['city'])){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$city = isset($term_data->city) ? $term_data->city : '';
				$country = isset($term_data->country) ? $term_data->country : '';

			}

			$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
			$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

			if ($gender == 1) {
				$gender_icon = 'fa fa-venus fa-lg';
			} else if ($gender == 2) {
				$gender_icon = 'fa fa-mars fa-lg';
			} else {
				$gender_icon = 'fa fa-user fa-lg';
			}

			$get_the_title = get_the_title();

			$title_for_alt = $get_the_title . ', ' . $age;

			if (isset($city)) {
				$title_for_alt .= esc_attr($city);
			}
			if (!empty($city) && !empty($country)) {
				$title_for_alt .= ", ";
			}
			if (isset($country)) {
				$title_for_alt .= esc_attr($country);
			}

			$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true);

			if($thumbnail_url['image_exists'] == 'yes'){

				$profile_image_url = $thumbnail_url['img_full_url'];

			} else {

				$profile_image_url = $cache_url . $columns_image_format . '.png';

			}
			
			if($border_color_define == 'random'){
				$border_color_out = 'border-color: ' . DateBook_Utilities::create_random_color('', 'light') . ' !important;';
			} else if($border_color_define == 0){
				$border_color_out = '';
			} else if($border_color_define == 1){
				$border_color_out = 'border-color: ' . $border_color . ' !important;';
			}

		?>

		<div class="<?php echo esc_attr($quantity_out);?> col-2 text-center">
			<div class="row">

				<a class="<?php echo esc_attr($space_out); ?>" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>" data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="<?php echo esc_attr($age) . "<i class='" . esc_attr($gender_icon) . "'></i><br />";

				if (isset($city)) {
					echo esc_attr($city);
				}
				if (!empty($city) && !empty($country)) {
					echo ", ";
				}
				if (isset($country)) {
					echo esc_attr($country);
				}

				?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 75%"><img class="img-fluid<?php echo esc_attr($round_out); ?>" style="border-style:<?php echo esc_attr($border_style_out); ?>; <?php echo esc_attr($border_width_out . ' ' . $border_color_out); ?>" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

			</div>
		</div>

		<?php endwhile; ?>

	</div>
</div>

<?php

	wp_reset_postdata();

endif;