<?php
/*
 * Search form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $time_in_seconds_array;

$datebook_topsuggest_bg = '';

$bg_topsuggest_image = of_get_option('bg_topsuggest_image');

if ($bg_topsuggest_image) {

	$datebook_topsuggest_bg = 'style="background: #000 url(' . esc_url($bg_topsuggest_image) . ') no-repeat center center; background: -ms-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -moz-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -o-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-gradient(linear, left top, left bottom, color-stop(0, rgba(0, 0, 0, 0.1)), color-stop(100, rgba(255, 255, 255, 0.4))) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: -webkit-linear-gradient(top, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover; background: linear-gradient(to bottom, rgba(0, 0, 0, 0.1) 0%, rgba(255, 255, 255, 0.4) 100%) repeat scroll 0 0, rgba(0, 0, 0, 0) url(' . esc_url($bg_topsuggest_image) . ') no-repeat scroll left center / cover;}"';
			
}

?>

<div class="card card-image text-white border-0 mb-3" <?php echo $datebook_topsuggest_bg; ?>>

	<div class="card-body" style="max-width: 80%;">

		<h5 class="card-title mb-0"><?php esc_html_e( 'Move your profile to Top position', 'datebook' ); ?> <button class="btn btn-sm btn-info p-1 pl-3 pr-3" type="button" data-toggle="collapse" data-target="#collapseTopOfferOnSearch" aria-expanded="false" aria-controls="collapseTopOfferOnSearch"><?php esc_html_e( 'show', 'datebook' ); ?></button></h5>

		<div class="collapse mt-2" id="collapseTopOfferOnSearch">

		<hr />

		<?php

		global $period_list_array;

		$topad_status = get_post_meta($profile_id, 'topad', true);

		if ($topad_status == "1") {

			$topad_ends = get_post_meta($profile_id, 'topad_ends', true);

			$topad_ends_time = isset($topad_ends) && $topad_ends > 0 ? DateBook_Utilities::datebook_date_i18n(1, $topad_ends, false) : esc_html__( 'unlimited', 'datebook' );
			$topad_ends_time_hours = isset($topad_ends) && $topad_ends > 0 ? DateBook_Utilities::datebook_date_i18n(2, $topad_ends, false) : esc_html__( 'unlimited', 'datebook' );

			
			echo '<p>';

			echo esc_html__( 'Your profile has been placed in', 'datebook' );

			echo ' <span class="badge badge-success" data-toggle="tooltip" data-placement="top" title="' . esc_html__( 'Top status is active until', 'datebook' ) . ': ' . esc_attr($topad_ends_time_hours) . '" data-original-title="' . esc_html__( 'Top status is active until', 'datebook' ) . ': ' . esc_attr($topad_ends_time_hours) . '">' . esc_html__( 'Top position', 'datebook' ) . '</span> ';

			echo esc_html__( 'till', 'datebook' ) . ' ' . esc_attr($topad_ends_time);

			echo '</p>';


			$top_times_total = isset($profile_top_times_total) && $profile_top_times_total > 0 ? $profile_top_times_total : 0;
			$top_times_left = isset($profile_top_times_left) && $profile_top_times_left > 0 ? $profile_top_times_left : 0;

			$period_number_top_position = isset($value['period_number_top_position']) && $value['period_number_top_position'] > 0 ? $value['period_number_top_position'] : 0;
			$period_top_position = isset($value['period_top_position']) && $value['period_top_position'] > 0 ? $value['period_top_position'] : 0;

			$top_position_after_period = $topad_starts + ($period_number_top_position * $time_in_seconds_array[$period_top_position]);

			echo '<div class="card border-0 mb-0 text-dark grey lighten-3">';
			echo '<div class="card-body">';
			echo '<p class="mb-1">';
			echo esc_html__( 'You may move your profile to Top position', 'datebook' ) . ': ' . sprintf( _n( '%d time', '%d times', $top_times_left, 'datebook' ), $top_times_left );
			echo '</p>';

			if($top_times_left <= $top_times_total && $top_position_after_period <= time()){

				echo '<a href="javascript:void(0)" id="datebook-top-' . esc_attr($profile_id) . '" class="btn btn-sm btn-info datebook-activate-topfeatured">' . esc_html__( 'Move', 'datebook' ) . '</a>';

			} else {

				echo '<a href="javascript:void(0)" class="btn btn-sm btn-success disabled">' . esc_html__( 'Moved', 'datebook' ) . '</a>';

			}
			
			echo '</div>';
			echo '</div>';


		} else {


			echo '<p>';
			echo '<span class="badge badge-info" title="' . esc_html__( 'Top status is not active', 'datebook' ) . '">' . esc_html__( 'Top position', 'datebook' ) . '</span> ' . esc_html__( 'not active', 'datebook' );
			echo '</p>';

			echo '<div class="datebook-custom-card card mb-0 text-dark grey lighten-3">';
			echo '<div class="card-body">';
			echo '<p>';
			echo esc_html__( 'Click on the button and your profile will be moved to Top position.', 'datebook' );
			echo '</p>';

			echo '<a href="javascript:void(0)"  id="datebook-top-' . esc_attr($profile_id) . '" class="btn btn-sm btn-primary datebook-activate-topfeatured">' . esc_html__( 'Activate', 'datebook' ) . '</a>';

			echo '</div>';
			echo '</div>';
			
		}

		?>
		
		</div>
	</div>
</div>