<?php
/*
 * Search form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_reserved_fields;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$count_genders = 0;

if (DateBook_Utilities::datebook_show_field('gender', 1) && DateBook_Utilities::datebook_show_field('gender', 3) && of_get_option('gender_allowed') != '') {

	$allowed_gender = of_get_option('gender_allowed');

	// Add custom Genders
	if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {
		$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

		foreach ($allowed_gender_other_array as $key => $value ){
			$allowed_gender[] = 1;
		}
	}

	if(is_array($allowed_gender)){
		$count_genders = count( array_keys( $allowed_gender, 1 )); // count active genders
	} else {
		$count_genders = 0;
	}

}


$enable_birthdate = (DateBook_Utilities::datebook_show_field('birthdate', 1) && DateBook_Utilities::datebook_show_field('birthdate', 3)) ? 1 : 0;

$enable_location = (DateBook_Utilities::datebook_show_field('countrycity', 1) && DateBook_Utilities::datebook_show_field('countrycity', 3));

if($count_genders > 0 || $enable_birthdate == 1 || $enable_location == 1) {

	global $wpdb, $datebook_gender_titles;

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }
	
	$page_id = get_the_ID();
	
	$is_front_page = is_front_page() ? 1 : 0;
	
	$search_results_page = of_get_option('search_results_page');

	if(of_get_option('search_align_front') == 'right'){
		$search_align_front = 'ml-auto';
	} else if(of_get_option('search_align_front') == 'center'){
		$search_align_front = 'm-auto';
	} else if(of_get_option('search_align_front') == 'left'){
		$search_align_front = 'mr-auto';
	} else {
		$search_align_front = 'm-auto';
	}
	
	$datebook_show_city = (DateBook_Utilities::datebook_show_field('countrycity', 1) == 1 && DateBook_Utilities::datebook_show_field('countrycity', 3) == 1) ? 1 : 0;

	?>

	<div class="datebook-search-panel">
		<div class="datebook-search-form datebook-search-form-h">

		<?php

		if ($page_id == $search_results_page || $is_front_page == 0) {
			$searchform_class = 'datebook-search-other';
			$searchform_max_width = '';
		} else {
			$searchform_class = 'datebook-search-front';
			$searchform_max_width = of_get_option('searchform_max_width') ? 'max-width:' . of_get_option('searchform_max_width') : '';
		}

		?>

			<div class="card <?php echo esc_attr($searchform_class . ' ' . $search_align_front); ?>" style=" <?php echo esc_attr($searchform_max_width); ?>">

			<?php if ($showtitle == 1) { ?>

				<div class="card-header datebook-transparent">

					<h3 class="font-weight-light"><?php esc_html_e( 'Search', 'datebook' ); ?></h3>

				</div>

			<?php } ?>

			<div class="card-body">

				<form action="<?php echo esc_url(get_permalink($search_results_page)); ?>" method="post">

		            <input type="hidden" name="action" value="searchprofiles" />
	    	        <input type="hidden" name="referrer" value="searchform" />

					<div class="form-row datebook-search-firstpart">

					<?php if ($page_id == $search_results_page && $enable_birthdate == 1 && $datebook_show_city == 1) { ?>

						<div class="col-lg-4 col-md-6 col-sm-6">
				
					<?php } else if ($page_id == $search_results_page && $datebook_show_city == 1) { ?>

						<div class="col-lg-4 col-md-4 col-sm-4">
				
					<?php } else if ($page_id == $search_results_page) { ?>

						<div class="col-lg-5 col-md-4 col-sm-12">
				
					<?php } else { ?>
				
						<div class="col-lg-4 col-md-6 col-sm-12">
				
					<?php } ?>

							<label class="datebook-label-title font-weight-normal"><?php esc_html_e( 'I am looking for', 'datebook' ); ?></label>

							<div class="clear"></div>

							<div class="btn-group d-flex btn-group-toggle" data-toggle="buttons">

							<?php
							
							if ($count_genders > 0) {
							
								$search_gender = isset($_REQUEST['gender']) ? $_REQUEST['gender'] : 0;

								if(isset($count_genders) && $count_genders > 2 ) {

									echo '<select class="custom-select form-control datebook-search-btn" name="gender">';

									echo '<option value="0">' . esc_html__( 'Someone', 'datebook' ) . '</option>';

								}

								foreach ($datebook_gender_titles as $key => $gender_name) {

									if(isset($allowed_gender[$key]) && $allowed_gender[$key] == 1){

										$gender_active = '';
										$gender_selected = '';
										$gender_checked = '';
										$gender_icon = '';

										// Set icon
										if ($key == 1) {
											$gender_icon = 'female';
										} else if ($key == 2) {
											$gender_icon = 'male';
										}

										if ($search_gender > 0) {

											if ($key == $search_gender) {
												$gender_active = ' active';
												$gender_selected = ' selected="selected"';
												$gender_checked = 'checked';
											}

										} else if ($is_front_page == 1){
											if ($key == 1) {
												$gender_active = ' active';
												$gender_selected = ' selected="selected"';
												$gender_checked = 'checked';
											} else {
												$gender_active = '';
												$gender_selected = '';
												$gender_checked = '';
											}
										}

										if(isset($count_genders) && $count_genders > 2 ) {

											echo '<option value="' . sanitize_key($key) . '" ' . esc_attr($gender_selected) . '>' . esc_html__( $gender_name, 'datebook' ) . '</option>';

										} else {

											echo '<label class="btn datebook-search-gender w-100 ' . esc_attr($gender_active) . ' datebook-search-btn" title="' . esc_html__( $gender_name, 'datebook' ) . '">';
										
											if (isset($gender_icon)) {
											
												echo '<i class="fas fa-' . esc_attr($gender_icon) . ' fa-lg mr-1"></i>';

											}

											echo '<input type="radio" name="gender" class="datebook-gender" value="' . sanitize_key($key) . '" ' . esc_attr($gender_checked) . ' /> <span class="align-middle">' . esc_html__( $gender_name, 'datebook' ) . '</span></label>';

										}

									}

								}

								if(isset($count_genders) && $count_genders > 2 ) {

									echo '</select>';

								}

							} else {

								echo '<label class="btn w-100 datebook-search-gender datebook-search-btn" title="' . esc_html__( 'Someone', 'datebook' ) . '"><input type="radio" name="gender" class="datebook-gender" value="0"> <span class="align-middle">' . esc_html__( 'Someone', 'datebook' ) . '</span></label>';
							}

							?>

					</div>

				</div>

				<?php if ($enable_birthdate == 1) { ?>
				
				<?php if ($page_id == $search_results_page && $datebook_show_city == 1) { ?>

				<div class="datebook-clear10 d-block d-sm-none"></div>
				
				<div class="col-lg-3 col-md-6 col-sm-6">

				<?php } else if ($page_id == $search_results_page) { ?>

				<div class="datebook-clear20 d-block d-md-none"></div>

				<div class="col-lg-5 col-md-4 col-sm-12">

				<?php } else { ?>

				<div class="datebook-clear20 d-block d-sm-none"></div>

				<div class="col-lg-3 col-md-6 col-sm-6">

				<?php } ?>

					<div id="datebook-agebox" class="datebook-age-form">

						<label for="datebook-agerange" class="datebook-label-title font-weight-normal"><?php esc_html_e( 'between age', 'datebook' ); ?></label>

						<?php 

						$register_age_min = of_get_option('register_age_min') > 0 ? of_get_option('register_age_min') : 18;
						$register_age_max = of_get_option('register_age_max') > 0 ? of_get_option('register_age_max') : 80;
						
						$agefrom = isset($_REQUEST['agefrom']) ? $_REQUEST['agefrom'] : $register_age_min;
						$ageto = isset($_REQUEST['ageto']) ? $_REQUEST['ageto'] : $register_age_max;

						$agerange = $agefrom . ' - ' . $ageto;

						if (($is_front_page == 1 && of_get_option( 'age_range_front' ) == 'ionrangeslider') || ($is_front_page == 0 && of_get_option( 'age_range_other' ) == 'ionrangeslider')) {

						?>
						
						<input type="text" id="datebook-agerange" name="agerange" value="<?php echo esc_attr($agerange);?>" class="form-control form-control-sm border-0 datebook-input-age datebook-search-btn" />
						
						<?php } else if (($is_front_page == 1 && of_get_option( 'age_range_front' ) == 'selector') || ($is_front_page == 0 && of_get_option( 'age_range_other' ) == 'selector')) { ?>
						
							<div class="form-row">
						
								<div class="col">
									<select class="custom-select form-control datebook-search-btn" name="agefrom">

									<?php

									for($i = $register_age_min; $i <= $register_age_max; $i++) {
										
										if ($i == $agefrom) { $selected_minage = ' selected'; } else { $selected_minage = ''; }

										echo '<option value="' . esc_attr($i) . '" ' . $selected_minage . '>' . esc_attr($i) . '</option>';

									}

									?>

									</select>
								</div>
								<div class="col">
									<select class="custom-select form-control datebook-search-btn" name="ageto">

									<?php

									for($i = $register_age_min; $i <= $register_age_max; $i++) {
										
										if ($i == $ageto) { $selected_maxage = ' selected'; } else { $selected_maxage = ''; }

										echo '<option value="' . esc_attr($i) . '" ' . $selected_maxage . '>' . esc_attr($i) . '</option>';

									}

									?>

									</select>
								</div>
							</div>
							
						<?php } ?>

					</div>
					
				</div>

				<?php } ?>

				<?php if ($datebook_show_city == 1) { ?>

					<?php if ($page_id == $search_results_page && $enable_birthdate == 1) { ?>
					
					<div class="datebook-clear20 d-block d-lg-none"></div>

					<div class="col-lg-3 col-md-8 col-sm-6">

					<?php } else if ($page_id == $search_results_page) { ?>

					<div class="datebook-clear20 d-block d-sm-none d-md-none d-lg-none"></div>

					<div class="col-lg-6 col-md-4 col-sm-4">

					<?php } else { ?>
					
					<div class="datebook-clear20 d-block d-lg-none"></div>

					<div class="col-lg-3 col-md-6 col-sm-6">

					<?php } ?>

						<label for="datebook-location" class="datebook-label-title font-weight-normal"><?php esc_html_e( 'from', 'datebook' ); ?></label>

						<div class="clear"></div>

						<?php

						$search_countrycity = '';
						$city_id = '';
						$region_id = '';
						$country_id = '';

						$search_location = 0;

						if(isset($_REQUEST['city']) && $_REQUEST['city'] > 0){
							$search_location = $_REQUEST['city'];
							$deep_level = 1;
						} else if(isset($_REQUEST['region']) && $_REQUEST['region'] > 0){
							$search_location = $_REQUEST['region'];
							$deep_level = 2;
						} else if(isset($_REQUEST['country']) && $_REQUEST['country'] > 0){
							$search_location = $_REQUEST['country'];
							$deep_level = 3;
						}

						if($search_location > 0){

							$term_data = DateBook_Utilities::datebook_get_term_by('id', $search_location, $deep_level);

							$city_title = isset($term_data->city) ? $term_data->city : '';
							$city_id = isset($term_data->city_id) ? $term_data->city_id : '';

							$region_title = isset($term_data->region) ? $term_data->region : '';
							$region_id = isset($term_data->region_id) ? $term_data->region_id : '';

							$country_title = isset($term_data->country) ? $term_data->country : '';
							$country_id = isset($term_data->country_id) ? $term_data->country_id : '';

							if ($city_title){
								$search_countrycity .= $city_title . ', ';
							}

							if ($region_title){
								$search_countrycity .= $region_title . ', ';
							}

							if ($country_title){
								$search_countrycity .= $country_title;
							}

						}

						?>

						<input id="datebook-locationcountry" name="country" type="hidden" value="<?php echo esc_attr($country_id);?>" />
						<input id="datebook-locationregion" name="region" type="hidden" value="<?php echo esc_attr($region_id);?>" />
						<input id="datebook-locationcity" name="city" type="hidden" value="<?php echo esc_attr($city_id);?>" />						

						<input id="datebook-location" name="countrycity" readonly type="text" class="form-control form-control-sm border-0 datebook-search-btn" value="<?php echo esc_attr($search_countrycity);?>" aria-label="<?php esc_html_e( 'Location', 'datebook' ); ?>" data-toggle="modal" data-target="#dbmodalcountriespanel" placeholder="<?php esc_html_e( 'Location', 'datebook' ); ?>" all-locations="<?php echo esc_attr($show_empty_countries); ?>" post-type="profile" />

						<?php echo DateBook_Search::datebook_countries_popup('search_form_other', $show_empty_countries, 0, 'profile'); ?>

					</div>

				<?php } ?>

				<?php if ($enable_birthdate == 1 && $datebook_show_city == 1) { ?>

				<div class="datebook-clear10 d-block d-sm-none"></div>

				<div class="col-lg-2 col-md-4 col-sm-6 text-right">

				<?php } else if ($datebook_show_city == 1) { ?>

				<div class="datebook-clear10 d-block d-sm-none"></div>

				<div class="col-lg-2 col-md-4 col-sm-4 text-right">

				<?php } else { ?>

				<div class="datebook-clear10 d-block d-md-none"></div>

				<div class="col-lg-2 col-md-4 col-sm-12 text-right">

				<?php } ?>

					<label for="datebook-searchbutton"><?php if (($page_id == $search_results_page || $is_front_page == 0) && of_get_option('search_advanced_show') == '1') { ?>

					<a class="collapsed small text-grey" role="button" data-toggle="collapse" href="#datebook-advancedsearch" aria-expanded="false" aria-controls="datebook-advancedsearch"><?php esc_html_e( 'Advanced', 'datebook' ); ?> <i class="fa" aria-hidden="true"></i></a>

				<?php } ?>&nbsp;</label>

					<div class="clear"></div>

					<button id="datebook-searchbutton" type="submit" class="btn btn-block m-0 datebook-search-btn datebook-search-submit"><?php esc_html_e( 'Search', 'datebook' ); ?></button>

				</div>

			</div>

			


			<?php if ($page_id == $search_results_page) { ?>
			
			<?php if (of_get_option('search_advanced_show') == 1) { ?>

			<div id="datebook-advancedsearch" class="collapse">

				<div class="form-row mb-3">

				<?php

				if (of_get_option('search_online_profiles') == 1) { 

					$search_online = isset($_REQUEST['online_status']) ? $_REQUEST['online_status'] : 0;

				?>

					<div class="col-lg-3 col-md-3 col-sm-3 mt-3">
				
						<div class="custom-control custom-checkbox">
							<input type="checkbox" name="online_status" class="custom-control-input datebook-online" id="datebook-online" value="1" <?php if ($search_online == 1) { echo ' checked="checked"'; }?>/>
							<label class="custom-control-label" for="datebook-online"><?php esc_html_e( 'Online', 'datebook' ); ?></label>
						</div>
						
					</div>

				<?php } ?>


				<?php

				/*if (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) {

					if (DateBook_Utilities::datebook_show_field('sexualorientation', 3)) {

						$search_sexualorientation = isset($_REQUEST['sexualorientation']) ? $_REQUEST['sexualorientation'] : 0;

					?>

					<div class="col-lg-3 col-md-3 col-sm-3 mt-3">

						<div class="custom-control custom-radio">
							<input type="radio" id="datebook-sexualorientation0" name="sexualorientation" class="custom-control-input"  value="0"<?php if (isset($search_sexualorientation) && $search_sexualorientation < 1) { echo ' checked="checked"'; }?> />
							<label class="custom-control-label" for="datebook-sexualorientation0"><?php esc_html_e( 'Any', 'datebook' ); ?></label>
						</div>

					<?php 

					$allowed_sexual_orientation = of_get_option('sexual_orientation_allowed');
					
					// Add custom Sexual Orientations
					if (of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {
						$sexual_orientation_allowed_other_array = explode('<br />', strtr(of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));
			
						foreach ($sexual_orientation_allowed_other_array as $key => $value ){
							$allowed_sexual_orientation[] = 1;
						}
					}


					foreach ($datebook_sexualorientation_titles as $key => $value) {

						if(isset($allowed_sexual_orientation[$key]) && $allowed_sexual_orientation[$key] == 1){

					?>

						<div class="custom-control custom-radio">
							<input type="radio" id="datebook-sexualorientation<?php echo sanitize_key($key); ?>" name="sexualorientation" class="custom-control-input"  value="<?php echo sanitize_key($key); ?>"<?php if (isset($search_sexualorientation) && $search_sexualorientation == $key) { echo ' checked="checked"'; }?> />
							<label class="custom-control-label" for="datebook-sexualorientation<?php echo sanitize_key($key); ?>"><?php echo esc_html__( $value, 'datebook' ); ?></label>
						</div>

					<?php } } ?>

					</div>

				<?php

				} }*/


				if (of_get_option('search_by_profilename') == 1 || of_get_option('search_by_userid') == 1 ||of_get_option('search_by_username') == 1) { ?>

					<div class="col-lg-3 col-md-3 col-sm-3 mt-3">

					<?php

					if (of_get_option('search_by_profilename') == 1 || of_get_option('search_by_userid') == 1 || of_get_option('search_by_username') == 1) {
						
						$search_comma = 0;

						$search_profilename_title = '';
						
						$search_by_username = of_get_option('search_by_username') == 1 ? 1 : 0;

						if (of_get_option('search_by_profilename') == 1) {

							$search_profilename_title .= esc_html__( 'Name', 'datebook' );

							$search_comma = 1;

						}

						if (of_get_option('search_by_userid') == 1) {
							
							if ($search_comma > 0 && $search_by_username == 0) {
								$search_profilename_title .= ' ' . esc_html__( 'or', 'datebook' ) . ' ';
							} else if ($search_comma > 0) {
								$search_profilename_title .= ', ';
							}

							$search_profilename_title .= esc_html__( 'ID', 'datebook' );

							$search_comma = 1;

						}

						if ($search_by_username == 1) {

							if ($search_comma > 0) {
								$search_profilename_title .= ' ' . esc_html__( 'or', 'datebook' ) . ' ';
							}

							$search_profilename_title .= esc_html__( 'Username', 'datebook' );

						}

						$search_profilename = isset($_REQUEST['searchbyprofilename']) ? $_REQUEST['searchbyprofilename'] : '';

						?>

						<div class="mb-2">
							<input id="datebook-profilename" name="searchbyprofilename" type="text" placeholder="<?php echo esc_attr($search_profilename_title); ?>" class="form-control" value="<?php echo esc_attr($search_profilename);?>" />
						</div>

					<?php } ?>


					<?php /*?><?php

					if (of_get_option('search_by_username') == 1) {

						$search_username = isset($_REQUEST['searchbyusername']) ? $_REQUEST['searchbyusername'] : '';

						?>

						<input id="datebook-username" name="searchbyusername" type="text" placeholder="<?php esc_html_e( 'Username', 'datebook' ); ?>" class="form-control" value="<?php echo esc_attr($search_username);?>" />

					<?php } ?><?php */?>

					</div>
				
				<?php } ?>

				</div>
				
				<?php
				
				// Display form
				DateBook_Forms::render_form('search_form_other', $current_user_id);

				?>
				
			</div>

			<?php } ?>

			

			<?php /*?><div class="form-row datebook-search-lastpart">
				
				<div class="col-lg-10 col-md-10 col-sm-10">

				<?php if (of_get_option('search_advanced_show') == '1') { ?>
					
					<a class="btn btn-link btn-sm float-right" role="button" data-toggle="collapse" href="#datebook-advancedsearch" aria-expanded="false" aria-controls="datebook-advancedsearch"><?php esc_html_e( 'Advanced search', 'datebook' ); ?></a>
						
				<?php } ?>

				</div>
			
				<div class="datebook-clear10 d-block d-sm-none"></div>

				<div class="col-lg-2 col-md-2 col-sm-2">

					<button id="datebook-searchbutton" type="submit" class="btn btn-block m-0 datebook-search-btn datebook-search-submit"><?php esc_html_e( 'Search', 'datebook' ); ?></button>

				</div>
			
			</div><?php */?>
			
			<?php } ?>

				</form>

				</div>
			</div>
		</div>
	</div>

<?php }