<?php
/**
 * Template part for displaying Tour page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

if ( isset($_POST['period']) && $_POST['period'] == 2 ) {

	$page_title = esc_html__( 'Starting soon', 'datebook' );

	$direction_meta_array = array(
			'key' => 'start',
			'value' => mktime(0, 0, 0, date("m"), date("d"), date("Y")),
			'compare' => '>=',
			'type' => 'NUMERIC'
	);

} else {

	$page_title = esc_html__( 'Happening now', 'datebook' );

	$direction_meta_array = array(
			'key' => 'end',
			'value' => mktime(23, 59, 59, date("m"), date("d"), date("Y")),
			'compare' => '>=',
			'type' => 'NUMERIC'
	);

}

$in_country_city = '';
$country = 0;

if (isset($_POST['country']) && $_POST['country'] != '') {

	$country = absint($_POST['country']);

	if ($country == '0') {
		unset($country);
	}

	if ($country || $city) {
		$in_country_city .= ' ' . esc_html__( 'in', 'datebook' );
	}
	
	if (isset($_POST['city']) && $_POST['city'] != '') {
		
		$city = absint($_POST['city']);
		if ($city == '0') {
			unset($city);
		}
		
		$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city );
		$country_name = isset($term_data->country) ? $term_data->country : '';
		$city_name = isset($term_data->city) ? $term_data->city : '';

		$in_country_city .= ' ' . $city_name;

		$in_country_city .= ',';

		$in_country_city .= ' ' . $country_name;

	}
}

do_action( 'datebook_welcome_message_tour');

do_action( 'datebook_search_tours_form');

?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<?php do_action( 'datebook_all_tours'); ?>

	</div>
</div>

<?php

do_action( 'datebook_add_tour_panel');