<?php 
/**
 * 404 page.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-9 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<div class="datebook-custom-card card mb-3">
			<div class="card-body">

				<h1><?php esc_html_e('Page not found', 'datebook' );?></h1>

				<p><?php esc_html_e('We\'re sorry, but the page you are looking for doesn\'t exist.', 'datebook' );?></p>

				<hr />

				<p><?php esc_html_e('You may try to search for it by entering a keyword.', 'datebook' );?></p>

				<div class="row mb-3">
					<div class="col-lg-8 col-md-8 col-sm-12">

						<?php get_search_form(); ?>

					</div>
				</div>

			</div>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-3 col-sm-3 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-page' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-page');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php get_footer();