<?php
/**
 * Category Page
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<div class="mb-5 datebook-blogs-page">

		<?php 

		if (is_category()){

			$current_category = single_cat_title('', false);

			if(isset($current_category)){

			?>

			<div class="datebook-custom-card card mb-3">
				<div class="card-body">

					<h1><?php echo esc_html($current_category); ?></h1>
					<span><?php echo esc_html__( 'You are on the category page', 'datebook' ); ?></span>

				</div>
			</div>

			<?php } ?>

		<?php } ?>
		
		<?php

		$datebook_blog_style = get_theme_mod('datebook_blog_style', 1);

		if ($datebook_blog_style == 1) {

			$datebook_blog_content = '-horizontal';

			?>

			<div class="container datebook-blog-horizontal">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 2) {

			$datebook_blog_content = '-classic';

		?>

			<div class="datebook-blog-classic">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 3) {

			$datebook_blog_content = '-overlap';

		?>

			<div class="datebook-blog-overlap">
				<div class="row">

		<?php } else if ($datebook_blog_style == 4) {

			$datebook_blog_content = '';

		?>

			<div class="datebook-blog-masonry">
				<div class="card-columns">

		<?php } else if ($datebook_blog_style == 5) {

			$datebook_blog_content = '';

			?>

			<div class="datebook-blog-mdb-masonry">
				<div class="row masonry">
					<div class="grid-sizer col-md-3" style="display:none"></div>

		<?php }

			if ( have_posts() ) :

				// Start the Loop
				while ( have_posts() ) : the_post();

					get_template_part( 'templates/content-list/content' . $datebook_blog_content, get_post_format() );

				endwhile;

				get_template_part( 'templates/post', 'pager' );

			else :

				get_template_part( 'templates/content-list/content' . $datebook_blog_content, 'none' );

			endif;

			?>     

			</div>

			<?php wp_reset_postdata(); ?>

			</div>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-blogs' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-blogs');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php get_footer(); ?>