<?php
/**
 *
 * All menus and sidebars
 *
 */


// Create menu wp_nav_menu()
if ( function_exists('register_nav_menus') ) {

	// get languages
	$languages_array = $languages = array();

	$languages_array[] = 'en_US';
	
	if(function_exists('of_get_option')){

		$directory = new DateBook_Localization();
		if(method_exists($directory,'datebook_all_available_language_files')){

			$languages = DateBook_Localization::datebook_all_available_language_files();

		}
	}

	foreach($languages as $language) {
		if($language['checked'] == 1){
			$languages_array[] = $language['locale'];
		}
	}
	
	$languages_array = array_unique($languages_array);

	foreach ( $languages_array as $locale_value ) :

		register_nav_menus( array(
			'datebook-top-menu-left-'.esc_attr( $locale_value ) => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Top Left Menu (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Top Left Menu', 'datebook' ),
			'datebook-top-menu-right-'.esc_attr( $locale_value ) => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Top Right Menu (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Top Right Menu', 'datebook' ),
			'datebook-primary-menu-'.esc_attr( $locale_value ) => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Primary Menu (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Primary Menu', 'datebook' ),
			'datebook-footer-menu-'.esc_attr( $locale_value ) => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Footer Menu (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Footer Menu', 'datebook' )
		) );

	endforeach;

}


// Register sidebars
add_action( 'widgets_init', 'datebook_widgets_init' );
function datebook_widgets_init() {
	
	global $wp_locale_all;

	// get languages
	$languages_array = $languages = array();

	$languages_array[] = 'en_US';

	if(function_exists('of_get_option')){

		$directory = new DateBook_Localization();
		if(method_exists($directory,'datebook_all_available_language_files')){

			$languages = DateBook_Localization::datebook_all_available_language_files();

		}
	}

	foreach($languages as $language) {
		if($language['checked'] == 1){
			$languages_array[] = $language['locale'];
		}
	}

	$languages_array = array_unique($languages_array);

	foreach ( $languages_array as $locale_value ) :

		$locale_value_lower = $locale_value == 'en_US' ? '' : '-' . strtolower($locale_value);

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Page (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Page', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Default page.', 'datebook' ),
			'id' => 'datebook-page' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="widgetadbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Blogs (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Blogs', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Blogs page.', 'datebook' ),
			'id' => 'datebook-blogs' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Single Blog (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Single Blog', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Single blog page.', 'datebook' ),
			'id' => 'datebook-singleblog' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Single Profile (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Single Profile', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Single Profile page.', 'datebook' ),
			'id' => 'datebook-single-profile' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Search (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Search', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Profiles Search page.', 'datebook' ),
			'id' => 'datebook-search' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Tours (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Tours', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Tours page.', 'datebook' ),
			'id' => 'datebook-tours' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Single Tour (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Single Tour', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Single Tour page.', 'datebook' ),
			'id' => 'datebook-single-tour' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Classifieds (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Classifieds', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Classifieds page.', 'datebook' ),
			'id' => 'datebook-classifieds' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Single Classified (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Single Classified', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the Single Classified page.', 'datebook' ),
			'id' => 'datebook-single-classified' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Shop (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Shop', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the sidebar of the WooCommerce shop page.', 'datebook' ),
			'id' => 'datebook-shop' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="sidebarbox widget"><div class="datebook-custom-card card mb-3 %2$s"><div class="card-body">',
			'after_widget' => '</div></div></div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Footer 1 (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Footer 1', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the footer of the site.', 'datebook' ),
			'id' => 'datebook-footer-1' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="datebook-footerbox widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Footer 2 (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Footer 2', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the footer of the site.', 'datebook' ),
			'id' => 'datebook-footer-2' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="datebook-footerbox widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Footer 3 (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Footer 3', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the footer of the site.', 'datebook' ),
			'id' => 'datebook-footer-3' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="datebook-footerbox widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

		register_sidebar(array(
			'name' => isset($wp_locale_all[ $locale_value ]) ? sprintf( esc_html__( 'Footer 4 (%s)', 'datebook' ), esc_html($wp_locale_all[ $locale_value ]) ) : esc_html__( 'Footer 4', 'datebook' ),
			'description' => esc_html__( 'A widget area loaded in the footer of the site.', 'datebook' ),
			'id' => 'datebook-footer-4' . esc_attr( $locale_value_lower ),
			'before_widget' => '<div id="%1$s" class="datebook-footerbox widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4><hr>'
		));

	endforeach;

}