<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' ) ? 1 : 0;
}


$datebook_wc_is_active = function_exists( 'WC' ) && (is_account_page() || is_cart() || is_checkout()) ? 1 : 0;

if($datebook_wc_is_active == 1 && $datebook_is_active_sidebar == 1){

	if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
		$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-shop' . $datebook_wplang ) ? 1 : 0;
	} else {
		$datebook_is_active_sidebar = is_active_sidebar( 'datebook-shop' ) ? 1 : 0;
	}

}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-9 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-3 datebook-blogs-page">

		<?php

		if($datebook_wc_is_active == 1){
			
			while ( have_posts() ) : the_post();
			
				//the_title( '<h1 class="entry-title">', '</h1>' );

				the_content();

			endwhile; // End of the loop.

		} else {

			while ( have_posts() ) : the_post();

				get_template_part( 'templates/content-list/content', 'page' );

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open($post->ID) || get_comments_number() ) :

					global $post;

					if($post->comment_status == 'open'){

						comments_template();

					}

				endif;

			endwhile; // End of the loop.

		}

		wp_reset_postdata();

		?>

		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-3 col-sm-3 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php

			if($datebook_wc_is_active == 1){

				if( class_exists( 'DateBook' ) ) {

					do_action('datebook_sidebar_edit');

				} else {

					get_sidebar('shop');

				}

			} else {

				if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
					$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
					dynamic_sidebar('datebook-page' . $datebook_wplang);
				} else {
					dynamic_sidebar('datebook-page');
				}

			}

			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php

get_footer();