<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-search' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<div id="datebook-primary" class="datebook-blogs-page datebook-content-area">
			<main id="datebook-main" class="datebook-site-main">

			<?php if ( have_posts() ) : ?>

				<div class="datebook-custom-card card">
					<div class="card-body">

						<header class="datebook-entry-header">

							<h1 class="datebook-page-title"><?php echo esc_html__( 'Search Results', 'datebook' ); ?></h1>

						</header>
						<!-- .page-header -->

						<span><?php printf( esc_html__( 'You have searched for: %s', 'datebook' ), '<strong>' . get_search_query() . '</strong>' ); ?></span>

					</div>
				</div>

				<?php

				$datebook_blog_style = get_theme_mod('datebook_blog_style', 1);

				if ($datebook_blog_style == 1) {

					$datebook_blog_content = '-horizontal';

					?>

				<div class="container datebook-blog-horizontal">
					<div class="row">

				<?php

				} else if ($datebook_blog_style == 2) {

					$datebook_blog_content = '-classic';

				?>

				<div class="datebook-blog-container">
					<div class="row">

				<?php

				} else if ($datebook_blog_style == 3) {

					$datebook_blog_content = '-overlap';

				?>

				<div class="datebook-blog-container">
					<div class="row">

				<?php } else if ($datebook_blog_style == 4) {

					$datebook_blog_content = '';

				?>

				<div class="datebook-blog-container">
					<div class="card-columns">

				<?php } else if ($datebook_blog_style == 5) {

					$datebook_blog_content = '';

				?>

				<div class="datebook-blog-container">
					<div class="row masonry">
						<div class="grid-sizer col-md-3" style="display:none"></div>

				<?php } ?>

						<?php

						while ( have_posts() ) : the_post();

							get_template_part( 'templates/content-list/content' . $datebook_blog_content, 'excerpt' );

						endwhile;

						?>

					</div>

					<?php

					the_posts_pagination( array(
						'prev_text' => '<span class="screen-reader-text">' . esc_html__( 'Previous page', 'datebook' ) . '</span>',
						'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next page', 'datebook' ) . '</span>',
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'datebook' ) . ' </span>',
					) );

					?>

				<?php else : ?>

					<div class="datebook-custom-card card datebook-blogs-page">
						<div class="card-body">

							<h1><?php esc_html_e( 'Nothing Found', 'datebook' ); ?></h1>

							<p><?php esc_html_e( 'Sorry, but nothing matched your search terms', 'datebook' ); ?>: <?php printf( esc_html__( '%s', 'datebook' ), '<strong>' . get_search_query() . '</strong>' ); ?></p>

							<hr />

							<p><?php esc_html_e('Please try again with some different keywords.', 'datebook' );?></p>
								
							<div class="row">
								<div class="col-lg-8 col-md-8 col-sm-8">

									<?php get_search_form(); ?>

								</div>
							</div>
						</div>
					</div>

				<?php endif; ?>

				</div>
			</main>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php get_sidebar(); ?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php get_footer();