<?php
/*
 * Single template
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-singleblog' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-singleblog' ) ? 1 : 0;
}


?>

<!-- content -->
<div class="row datebook-padding-less">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-3 datebook-blogs-page datebook-post-page">

		<?php
		
		while (have_posts()) : the_post();

			get_template_part( 'templates/content-single/content', get_post_format() );

			if (comments_open() || get_comments_number()){

				global $post;

				if($post->comment_status == 'open'){

					comments_template();

				}
			}

		endwhile;

		wp_reset_postdata();

		?>

		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-singleblog' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-singleblog');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php

get_footer();