<?php
/**
 * The template for displaying Tag pages.
 *
 * Used to display archive-type pages for posts in a tag.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' ) ? 1 : 0;
}


?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<div class="mb-5 datebook-blogs-page">

		<?php 

		if (is_tag()){

			$current_tag = single_tag_title("", false);

			if(isset($current_tag)){

			?>

			<div class="datebook-custom-card card mb-3">
				<div class="card-body">

					<h1><?php echo esc_html($current_tag); ?></h1>
					<span><?php echo esc_html__( 'You are on the tag page', 'datebook' ); ?></span>

				</div>
			</div>

			<?php } ?>

		<?php } ?>

		<?php

		$datebook_blog_style = get_theme_mod('datebook_blog_style', 1);

		if ($datebook_blog_style == 1) {

			$datebook_blog_content = '-horizontal';

			?>

			<div class="container datebook-blog-horizontal">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 2) {

			$datebook_blog_content = '-classic';

		?>

			<div class="datebook-blog-container">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 3) {

			$datebook_blog_content = '-overlap';

		?>

			<div class="datebook-blog-container">
				<div class="row">

		<?php } else if ($datebook_blog_style == 4) {

			$datebook_blog_content = '';

		?>

			<div class="datebook-blog-container">
				<div class="card-columns">

		<?php } else if ($datebook_blog_style == 5) {

			$datebook_blog_content = '';

			?>

			<div class="datebook-blog-container">
				<div class="row masonry">
					<div class="grid-sizer col-md-3" style="display:none"></div>

		<?php } ?>

			<?php

			$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

			$args = array(
				'post_type' => 'post',
				'paged' => $paged
			);

			$wp_query = new WP_Query( $args );

			if ( $wp_query->have_posts() ) {

				while ( $wp_query->have_posts() ) {

					$wp_query->the_post();

					get_template_part( 'templates/content-list/content' . $datebook_blog_content, get_post_format() );

				}

			}

			?>

			</div>
		

			<?php

			get_template_part( 'templates/post', 'pager' );

			wp_reset_postdata();

			?>
		
		</div>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php

			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-blogs' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-blogs');
			}

			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php get_footer(); ?>