<?php
/**
 * The default template for displaying content with Featured image. Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 2.1
 */


switch(get_theme_mod('datebook_blog_columns', 3)){
	case '1' : $datebook_blog_columns = 'col-md-12'; break;
	case '2' : $datebook_blog_columns = 'col-md-6'; break;
	case '3' : $datebook_blog_columns = 'col-md-4'; break;
	case '4' : $datebook_blog_columns = 'col-md-3'; break;
	default: $datebook_blog_columns = 'col-md-4'; break;
}
				
$datebook_blog_class = ' ';
$datebook_blog_subclass = 'datebook-custom-card card';

?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" class="<?php echo esc_attr($datebook_blog_columns . $datebook_blog_class); ?> mb-3 datebook-blogs-item">
	<div <?php post_class($datebook_blog_subclass); ?>>
		<div class="datebook-article-media">

			<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(the_title_attribute( 'echo=0' )); ?>" rel="bookmark">

			<?php
			
			if (get_post_thumbnail_id()) {

				the_post_thumbnail('datebook-featured', array('class' => 'card-img-top'));

			}  else {

			?>

			<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/blog-no-image.jpg' ); ?>" class="card-img-top wp-post-image" alt="<?php echo esc_attr(the_title_attribute( 'echo=0' )); ?>" width="358" height="200" />

			<?php } ?>

			</a>

			<div class="text-muted small datebook-article-meta">

				<?php datebook_entry_meta(); ?>

			</div>
			<!--end article-meta--> 

		</div>
		<!--end article-media-->

		<div class="card-body">

		<?php if (get_the_title()): ?>

			<?php if ( is_single() ) : ?>

				<header class="datebook-entry-header">

					<h1><?php the_title(); ?></h1>

				</header>

			<?php else : ?>

				<h5 class="card-title datebook-article-title"><a class="black-text" href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( esc_html__( 'Permalink to %s', 'datebook' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h5>

			<?php endif; // is_single() ?>

		<?php endif; // get_the_title() ?>

			<div class="datebook-article-content">

				<?php

				if ( !is_single() ) : // Only display Excerpts for Search

					if (has_excerpt()):

						echo '<p class="card-text">' . wp_strip_all_tags(do_shortcode(get_the_excerpt())) . '</p>';

					else:

						$datebook_get_content = substr(wp_strip_all_tags(do_shortcode(get_the_content())), 0, 200);

						if(strlen($datebook_get_content) > 0 && $datebook_get_content != '&nbsp;'){
							echo '<p class="card-text">' . esc_attr($datebook_get_content) . '</p>';
						}

					endif;

					?>

					<?php /*?><a class="btn btn-secondary btn-sm" href="<?php the_permalink()?>"><?php esc_html_e( 'Continue reading', 'datebook' );?></a><?php */?>
					<a class="text-muted d-flex justify-content-end small" href="<?php the_permalink()?>"><?php esc_html_e( 'Continue reading', 'datebook' );?> <i class="fas fa-sm mt-1 ml-1 fa-angle-double-right"></i></a>

				<?php

				else :

					the_content();

					wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ), 'after' => '</div>' ) );

				endif;

				?>

			</div>
		</div>
	</div>
</div>
<!-- End  Article -->