<?php
/**
 * Template part for displaying posts with excerpts
 *
 * Used in Search Results and for Recent Posts in Front Page panels.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" <?php post_class('datebook-custom-card card mb-3'); ?>>
	<div class="card-body">

		<?php if ( is_single() ) : ?>

			<header class="datebook-entry-header">

				<h1><?php the_title(); ?></h1>

			</header>

		<?php else : ?>

			<h4 class="card-title datebook-article-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( esc_html__( 'Permalink to %s', 'datebook' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h4>

		<?php endif; // is_single() ?>


		<?php if ( 'post' === get_post_type() ) : ?>
			<div class="datebook-article-meta">
				<?php datebook_entry_meta(); ?>
			</div>
			<!--end article-meta-->
		<?php endif; ?>


		<div class="datebook-article-content">
		
			<?php

			if ( !is_single() ) : // Only display Excerpts for Search

				if (has_excerpt()):

					echo '<p class="card-text">' . wp_strip_all_tags(do_shortcode(get_the_excerpt())) . '</p>';

				else:

					$datebook_get_content = substr(wp_strip_all_tags(do_shortcode(get_the_content())), 0, 200);

					if(strlen($datebook_get_content) > 0 && $datebook_get_content != '&nbsp;'){
						echo '<p class="card-text">' . esc_attr($datebook_get_content) . '</p>';
					}

				endif;

				?>

				<a class="btn btn-secondary btn-sm" href="<?php the_permalink()?>"><?php esc_html_e( 'Continue reading', 'datebook' );?></a>

				<?php

			else :

				the_content();

				wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ), 'after' => '</div>' ) );

			endif;

			?>

		</div>
		<!--end article-content-->

	</div>

	<div class="card-footer datebook-article-meta-footer">

		<?php datebook_entry_meta_footer(); ?>

	</div>
	<!--end article-meta-footer-->

</div>
<!-- End  Article -->