<?php
/**
 * The default template for displaying content with Featured image. Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 2.1
 */

$datebook_blog_class = 'w-100 mb-4';
$datebook_blog_subclass = 'w-100 datebook-custom-card card shadow';

if (get_post_thumbnail_id()) {

	$get_post_thumbnail_id = 1;

	$datebook_columns_text_class = 'col-lg-7 col-md-6 col-sm-12';

} else {

	$get_post_thumbnail_id = 0;

	$datebook_columns_text_class = 'col-lg-12 col-md-12 col-sm-12';

}

?>
<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" class="<?php echo esc_attr($datebook_blog_class); ?> datebook-blogs-item">
	<div <?php post_class($datebook_blog_subclass); ?>>
		<div class="row">

			<div class="<?php echo esc_attr($datebook_columns_text_class); ?>">

				<div class="card-body">
				
					<div class="text-muted small datebook-article-meta">

						<?php datebook_entry_meta(); ?>

					</div>
					<!--end article-meta--> 
			
					<?php if (get_the_title()): ?>

						<?php if ( is_single() ) : ?>

							<header class="datebook-entry-header">

								<h1><?php the_title(); ?></h1>

							</header>

						<?php else : ?>

							<h4 class="card-title datebook-article-title"><a class="black-text" href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( esc_html__( 'Permalink to %s', 'datebook' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h4>

						<?php endif; // is_single() ?>

					<?php endif; // get_the_title() ?>

					<div class="datebook-article-content">

						<?php

						if ( !is_single() ) : // Only display Excerpts for Search

							if (has_excerpt()):

								echo '<p class="card-text">' . wp_strip_all_tags(do_shortcode(get_the_excerpt())) . '</p>';

							else:

								$datebook_get_content = substr(wp_strip_all_tags(do_shortcode(get_the_content())), 0, 255);

								if(strlen($datebook_get_content) > 0 && $datebook_get_content != '&nbsp;'){
									echo '<p class="card-text overflow-hidden">' . esc_attr($datebook_get_content) . '</p>';
								}

							endif;
							
						else :

							the_content();

							wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ), 'after' => '</div>' ) );

						endif;

						?>

					</div>
				</div>
			</div>

			<?php
			
			if ($get_post_thumbnail_id == 1) {

				if ($get_post_thumbnail_id == 1) {

					// grab the url for the full size featured image
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'datebook-featured');

				}  else {

					// grab the url for the first image in an article
					$featured_img_url = datebook_catch_first_post_image();

				}

				if($featured_img_url == ''){

					$featured_img_url = get_template_directory_uri() . '/assets/images/blog-no-image.jpg';

				}

			?>
			
			<div class="col-lg-5 col-md-6 col-sm-12">

				<!-- Card image -->
				<div class="view overlay d-block rounded w-100 h-100 datebook-article-media" style="background-image: url('<?php echo esc_url($featured_img_url); ?>'); background-repeat: no-repeat; background-size: cover; background-position: center center; min-height:200px">

					<a class="d-block" href="<?php the_permalink(); ?>" title="<?php echo esc_attr(the_title_attribute( 'echo=0' )); ?>" rel="bookmark">
						<div class="mask rgba-white-slight d-block w-100 h-100"></div>
					</a>

				</div>
				<!-- end Card image -->

				<?php /*?><div class="view overlay datebook-article-media">
				
					<?php

					if (get_post_thumbnail_id()) {

						the_post_thumbnail('datebook-featured', array('class' => 'card-img'));

					}  else {

					?>

						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/blog-no-image.jpg' ); ?>" class="card-img wp-post-image" alt="<?php echo esc_attr(the_title_attribute( 'echo=0' )); ?>" width="358" height="200" />

					<?php } ?>

					<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(the_title_attribute( 'echo=0' )); ?>" rel="bookmark">
						<div class="mask rgba-white-slight"></div>
					</a>

				</div><?php */?>

			</div>

			<?php } ?>

		</div>
	</div>
</div>
<!-- End  Article -->